/**
 * ---------------------------------------------------------------------------------------------
 * Copyright (c) 2020 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * --------------------------------------------------------------------------------------------
 */
package org.eclipse.gemoc.protocols.eaop.api.data;

import java.util.Map;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

/**
 * A structured message object. Used to return errors from requests.
 */
@SuppressWarnings("all")
public class Message {
  /**
   * Unique identifier for the message.
   */
  private Integer id;

  /**
   * A format string for the message. Embedded variables have the form '{name}'.
   * If variable name starts with an underscore character, the variable does not contain user data (PII) and can be safely used for telemetry purposes.
   */
  private String format;

  /**
   * An object used as a dictionary for looking up the variables in the format string.
   */
  private Map<String, String> variables;

  /**
   * If true send to telemetry.
   */
  private boolean sendTelemetry;

  /**
   * If true show user.
   */
  private boolean showUser;

  /**
   * An optional url where additional information about this message can be found.
   */
  private String url;

  /**
   * An optional label that is presented to the user as the UI for opening the url.
   */
  private String urlLabel;

  /**
   * Unique identifier for the message.
   */
  @Pure
  public Integer getId() {
    return this.id;
  }

  /**
   * Unique identifier for the message.
   */
  public void setId(final Integer id) {
    this.id = id;
  }

  /**
   * A format string for the message. Embedded variables have the form '{name}'.
   * If variable name starts with an underscore character, the variable does not contain user data (PII) and can be safely used for telemetry purposes.
   */
  @Pure
  public String getFormat() {
    return this.format;
  }

  /**
   * A format string for the message. Embedded variables have the form '{name}'.
   * If variable name starts with an underscore character, the variable does not contain user data (PII) and can be safely used for telemetry purposes.
   */
  public void setFormat(final String format) {
    this.format = format;
  }

  /**
   * An object used as a dictionary for looking up the variables in the format string.
   */
  @Pure
  public Map<String, String> getVariables() {
    return this.variables;
  }

  /**
   * An object used as a dictionary for looking up the variables in the format string.
   */
  public void setVariables(final Map<String, String> variables) {
    this.variables = variables;
  }

  /**
   * If true send to telemetry.
   */
  @Pure
  public boolean isSendTelemetry() {
    return this.sendTelemetry;
  }

  /**
   * If true send to telemetry.
   */
  public void setSendTelemetry(final boolean sendTelemetry) {
    this.sendTelemetry = sendTelemetry;
  }

  /**
   * If true show user.
   */
  @Pure
  public boolean isShowUser() {
    return this.showUser;
  }

  /**
   * If true show user.
   */
  public void setShowUser(final boolean showUser) {
    this.showUser = showUser;
  }

  /**
   * An optional url where additional information about this message can be found.
   */
  @Pure
  public String getUrl() {
    return this.url;
  }

  /**
   * An optional url where additional information about this message can be found.
   */
  public void setUrl(final String url) {
    this.url = url;
  }

  /**
   * An optional label that is presented to the user as the UI for opening the url.
   */
  @Pure
  public String getUrlLabel() {
    return this.urlLabel;
  }

  /**
   * An optional label that is presented to the user as the UI for opening the url.
   */
  public void setUrlLabel(final String urlLabel) {
    this.urlLabel = urlLabel;
  }

  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("id", this.id);
    b.add("format", this.format);
    b.add("variables", this.variables);
    b.add("sendTelemetry", this.sendTelemetry);
    b.add("showUser", this.showUser);
    b.add("url", this.url);
    b.add("urlLabel", this.urlLabel);
    return b.toString();
  }

  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    Message other = (Message) obj;
    if (this.id == null) {
      if (other.id != null)
        return false;
    } else if (!this.id.equals(other.id))
      return false;
    if (this.format == null) {
      if (other.format != null)
        return false;
    } else if (!this.format.equals(other.format))
      return false;
    if (this.variables == null) {
      if (other.variables != null)
        return false;
    } else if (!this.variables.equals(other.variables))
      return false;
    if (other.sendTelemetry != this.sendTelemetry)
      return false;
    if (other.showUser != this.showUser)
      return false;
    if (this.url == null) {
      if (other.url != null)
        return false;
    } else if (!this.url.equals(other.url))
      return false;
    if (this.urlLabel == null) {
      if (other.urlLabel != null)
        return false;
    } else if (!this.urlLabel.equals(other.urlLabel))
      return false;
    return true;
  }

  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.id== null) ? 0 : this.id.hashCode());
    result = prime * result + ((this.format== null) ? 0 : this.format.hashCode());
    result = prime * result + ((this.variables== null) ? 0 : this.variables.hashCode());
    result = prime * result + (this.sendTelemetry ? 1231 : 1237);
    result = prime * result + (this.showUser ? 1231 : 1237);
    result = prime * result + ((this.url== null) ? 0 : this.url.hashCode());
    return prime * result + ((this.urlLabel== null) ? 0 : this.urlLabel.hashCode());
  }
}
