/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.core;

import java.io.File;
import org.aspectj.ajde.core.IBuildMessageHandler;
import org.aspectj.ajde.core.IBuildProgressMonitor;
import org.aspectj.ajde.core.ICompilerConfiguration;
import org.aspectj.ajde.core.internal.AjdeCoreBuildManager;
import org.aspectj.ajdt.internal.core.builder.AjState;
import org.aspectj.ajdt.internal.core.builder.IncrementalStateManager;
import org.aspectj.asm.AsmManager;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.Message;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class AjCompiler {
    private final String compilerId;
    private final ICompilerConfiguration compilerConfig;
    private final IBuildProgressMonitor monitor;
    private final IBuildMessageHandler handler;
    private final AjdeCoreBuildManager buildManager;

    public AjCompiler(String compilerId, ICompilerConfiguration compilerConfig, IBuildProgressMonitor buildProgressMonitor, IBuildMessageHandler buildMessageHandler) {
        this.compilerConfig = compilerConfig;
        this.monitor = buildProgressMonitor;
        this.handler = buildMessageHandler;
        this.compilerId = compilerId;
        this.buildManager = new AjdeCoreBuildManager(this);
    }

    public String getId() {
        return this.compilerId;
    }

    public ICompilerConfiguration getCompilerConfiguration() {
        return this.compilerConfig;
    }

    public IBuildProgressMonitor getBuildProgressMonitor() {
        return this.monitor;
    }

    public IBuildMessageHandler getMessageHandler() {
        return this.handler;
    }

    public void build() {
        if (this.hasValidId()) {
            this.buildManager.performBuild(false);
        }
    }

    public void buildFresh() {
        if (this.hasValidId()) {
            this.buildManager.performBuild(true);
        }
    }

    public void clearLastState() {
        IncrementalStateManager.removeIncrementalStateInformationFor(this.compilerId);
        this.buildManager.cleanupEnvironment();
    }

    public boolean addDependencies(File file, String[] typeNameDependencies) {
        AjState state = IncrementalStateManager.retrieveStateFor(this.compilerId);
        return state.recordDependencies(file, typeNameDependencies);
    }

    public boolean isJava6Compatible() {
        return CompilerOptions.versionToJdkLevel("1.6") != 0L;
    }

    private boolean hasValidId() {
        if (this.compilerId == null) {
            Message msg = new Message("compiler didn't have an id associated with it", IMessage.ABORT, null, null);
            this.handler.handleMessage((IMessage)msg);
            return false;
        }
        return true;
    }

    public void setCustomMungerFactory(Object factory) {
        this.buildManager.setCustomMungerFactory(factory);
    }

    public Object getCustomMungerFactory() {
        return this.buildManager.getCustomMungerFactory();
    }

    public AsmManager getModel() {
        return this.buildManager.getStructureModel();
    }

    public AjdeCoreBuildManager getBuildManager() {
        return this.buildManager;
    }
}

