/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.vcdgenerator;

import fr.inria.aoste.timesquare.vcd.model.IScopeCommand;
import fr.inria.aoste.timesquare.vcd.model.ISimulationCommand;
import fr.inria.aoste.timesquare.vcd.model.ScalarValueChange;
import fr.inria.aoste.timesquare.vcd.model.VCDDefinitions;
import fr.inria.aoste.timesquare.vcd.model.Value;
import fr.inria.aoste.timesquare.vcd.model.ValueChange;
import fr.inria.aoste.timesquare.vcd.model.command.ScopeCommand;
import fr.inria.aoste.timesquare.vcd.model.command.SimulationCommand;
import fr.inria.aoste.timesquare.vcd.model.command.VarCommand;
import fr.inria.aoste.timesquare.vcd.model.keyword.ScopeType;
import fr.inria.aoste.timesquare.vcd.model.keyword.VarType;
import fr.inria.aoste.timesquare.vcd.model.visitor.IScopeVisitor;
import fr.inria.aoste.timesquare.vcd.model.visitor.ISimulationCollector;
import fr.inria.aoste.timesquare.vcd.model.visitor.TraceCollector;
import fr.inria.aoste.timesquare.vcd.model.visitor.VarCollector;
import fr.inria.aoste.timesquare.vcd.preferences.VcdColorPreferences;
import fr.inria.aoste.timesquare.vcd.view.VcdFactory;
import java.util.HashMap;

public final class ScoreBoard {
    private static final HashMap<String, ScoreBoard> map = new HashMap();
    private VCDDefinitions vcdModel;
    private VcdFactory factory;
    private ScopeCommand scope;
    private SimulationCommand sim = null;
    private VarCollector vc;
    private TraceCollector tc;
    private String scoreBoardId;
    private HashMap<String, Integer> changes = new HashMap();

    private ScoreBoard(VcdColorPreferences mca) {
        this.factory = new VcdFactory(mca);
        this.vcdModel = new VCDDefinitions();
        this.vcdModel.setFactory(this.factory);
        this.scope = new ScopeCommand(ScopeType.module, "top");
        this.vcdModel.setScope(this.scope);
        this.vc = new VarCollector(this.vcdModel.getArraylistDeclarationCommand());
        this.vcdModel.visit((IScopeVisitor)this.vc);
        this.tc = new TraceCollector((Iterable)this.vc, this.factory);
        this.vcdModel.visit((ISimulationCollector)this.tc);
    }

    public void start() {
        for (String id : this.changes.keySet()) {
            this.changes.put(id, -1);
        }
    }

    public SimulationCommand tick(int tick) {
        this.sim = new SimulationCommand(tick, this.vcdModel);
        this.vcdModel.addSimulation((ISimulationCommand)this.sim);
        return this.sim;
    }

    public int getSize() {
        return this.vcdModel.getArraylistSimulationCommand().size();
    }

    public String addVar(String name, String id) {
        this.scope.addChild((IScopeCommand)new VarCommand(VarType.integer, 1, id, name));
        return id;
    }

    public String addVar(String name, VarType vt, String id) {
        this.scope.addChild((IScopeCommand)new VarCommand(vt, 1, id, name));
        return id;
    }

    public void addScalarValueChange(Value v, String clockId) {
        this.add(v, clockId);
    }

    private void add(Value v, String id) {
        this.sim.addValueChange((ValueChange)new ScalarValueChange(v, id));
    }

    public void add(ValueChange v) {
        this.sim.addValueChange(v);
    }

    public static ScoreBoard getScoreboard(String id, VcdColorPreferences mca) {
        ScoreBoard res = map.get(id);
        res = new ScoreBoard(mca);
        res.setId(id);
        map.put(id, res);
        return res;
    }

    public static void removeScoreboard(String id) {
        map.remove(id);
    }

    public static void removeScoreboard(ScoreBoard sc) {
        if (sc != null) {
            map.remove(sc.getId());
        }
    }

    public VCDDefinitions getVcdModel() {
        return this.vcdModel;
    }

    protected void setId(String id) {
        this.scoreBoardId = id;
    }

    public String getId() {
        return this.scoreBoardId;
    }
}

