/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.ui.wizards;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecoretools.ale.ide.ui.Activator;
import org.eclipse.emf.ecoretools.ale.ide.ui.project.WorkspaceAleProject;
import org.eclipse.emf.ecoretools.ale.ide.ui.wizards.NewAleProjectConfigurationWizardPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewAleProjectWizard
extends Wizard
implements INewWizard {
    private WizardNewProjectCreationPage newProjectPage;
    private NewAleProjectConfigurationWizardPage aleConfigurationPage;

    public NewAleProjectWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("ALE Project Wizard");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        super.addPages();
        this.newProjectPage = new WizardNewProjectCreationPage("ALE Project");
        this.newProjectPage.setTitle("New ALE Project");
        this.newProjectPage.setDescription("Create a new ALE project.");
        this.aleConfigurationPage = new NewAleProjectConfigurationWizardPage();
        this.addPage((IWizardPage)this.newProjectPage);
        this.addPage((IWizardPage)this.aleConfigurationPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.newProjectPage) {
            this.aleConfigurationPage.setDefaultEcorePackage(this.newProjectPage.getProjectName());
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        return !this.newProjectPage.getProjectName().isEmpty() && !this.newProjectPage.getLocationPath().isEmpty() && this.aleConfigurationPage.isPageComplete();
    }

    public boolean performFinish() {
        try {
            final String projectName = this.newProjectPage.getProjectName();
            boolean defaultProjectLocation = this.newProjectPage.useDefaults();
            final IPath projectLocation = defaultProjectLocation ? this.newProjectPage.getLocationPath().append(projectName) : this.newProjectPage.getLocationPath();
            final boolean useAnExistingEcoreModel = this.aleConfigurationPage.useExistingEcoreModel();
            final IPath ecoreModelFilePath = this.aleConfigurationPage.getEcoreModelFile();
            final boolean createRepresentation = this.aleConfigurationPage.createRepresentation();
            final boolean activateJava = this.aleConfigurationPage.activateJava();
            final boolean createDslFile = this.aleConfigurationPage.createDslFile();
            final String ecorePackageName = this.aleConfigurationPage.getEcorePackageName() == null ? projectName : this.aleConfigurationPage.getEcorePackageName();
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        WorkspaceAleProject.Description desc = new WorkspaceAleProject.Description(useAnExistingEcoreModel, ecoreModelFilePath, ecorePackageName, createRepresentation, activateJava, createDslFile);
                        WorkspaceAleProject.Template project = new WorkspaceAleProject.Template(ResourcesPlugin.getWorkspace(), desc);
                        project.create(projectName, projectLocation, monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e, "An error occurred while creating the new ALE project " + projectName);
                    }
                }
            });
            return true;
        }
        catch (InterruptedException | InvocationTargetException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Activator.error("An error occurred while creating the new ALE project", e);
            this.showErrorDialog(e, "Project creation failed", e.getMessage());
            return false;
        }
    }

    private void showErrorDialog(Exception e, String title, String message) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String trace = sw.toString();
        ArrayList<Status> childStatuses = new ArrayList<Status>();
        String[] stringArray = trace.split(System.getProperty("line.separator"));
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            childStatuses.add(new Status(4, "org.eclipse.emf.ecoretools.ale.ide.ui", line));
            ++n2;
        }
        MultiStatus status = new MultiStatus("org.eclipse.emf.ecoretools.ale.ide.ui", 4, (IStatus[])childStatuses.toArray(new Status[0]), e.toString(), (Throwable)e);
        ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)status);
    }
}

