/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public abstract class ConstrainedLayoutEditPolicy
extends LayoutEditPolicy {
    protected static final Dimension UNSPECIFIED_SIZE = new Dimension();

    protected Command createAddCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        return this.createAddCommand(child, constraint);
    }

    protected Command createAddCommand(EditPart child, Object constraint) {
        return null;
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        return this.createChangeConstraintCommand(child, constraint);
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        return null;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new ResizableEditPolicy();
    }

    protected Command getAddCommand(Request generic) {
        ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
        List editParts = request.getEditParts();
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel("Add in ConstrainedLayoutEditPolicy");
        int i = 0;
        while (i < editParts.size()) {
            GraphicalEditPart child = (GraphicalEditPart)editParts.get(i);
            command.add(this.createAddCommand(request, child, this.translateToModelConstraint(this.getConstraintFor(request, child))));
            ++i;
        }
        return command.unwrap();
    }

    protected Command getAlignChildrenCommand(AlignmentRequest request) {
        return this.getResizeChildrenCommand(request);
    }

    public Command getCommand(Request request) {
        if ("resize children".equals(request.getType())) {
            return this.getResizeChildrenCommand((ChangeBoundsRequest)request);
        }
        if ("align children".equals(request.getType())) {
            return this.getAlignChildrenCommand((AlignmentRequest)request);
        }
        return super.getCommand(request);
    }

    protected Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        PrecisionRectangle locationAndSize = new PrecisionRectangle(child.getFigure().getBounds());
        child.getFigure().translateToAbsolute((Translatable)locationAndSize);
        locationAndSize = request.getTransformedRectangle((Rectangle)locationAndSize);
        this.translateFromAbsoluteToLayoutRelative((Translatable)locationAndSize);
        return this.getConstraintFor(request, child, (Rectangle)locationAndSize);
    }

    protected Object getConstraintFor(Request request, GraphicalEditPart child, Rectangle rectangle) {
        if (UNSPECIFIED_SIZE.equals((Object)rectangle.getSize())) {
            return this.getConstraintFor(rectangle.getLocation());
        }
        return this.getConstraintFor(rectangle);
    }

    protected abstract Object getConstraintFor(Point var1);

    protected abstract Object getConstraintFor(Rectangle var1);

    protected Object getConstraintFor(CreateRequest request) {
        PrecisionRectangle locationAndSize = null;
        locationAndSize = request.getSize() == null || request.getSize().isEmpty() ? new PrecisionRectangle(request.getLocation(), UNSPECIFIED_SIZE) : new PrecisionRectangle(request.getLocation(), request.getSize());
        this.translateFromAbsoluteToLayoutRelative((Translatable)locationAndSize);
        return this.getConstraintFor(request, null, (Rectangle)locationAndSize);
    }

    protected Object getConstraintForClone(GraphicalEditPart part, ChangeBoundsRequest request) {
        return this.getConstraintFor(request, part);
    }

    protected Object translateToModelConstraint(Object figureConstraint) {
        return figureConstraint;
    }

    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        return this.getChangeConstraintCommand(request);
    }

    protected Command getChangeConstraintCommand(ChangeBoundsRequest request) {
        CompoundCommand resize = new CompoundCommand();
        List children = request.getEditParts();
        int i = 0;
        while (i < children.size()) {
            GraphicalEditPart child = (GraphicalEditPart)children.get(i);
            Command c = this.createChangeConstraintCommand(request, child, this.translateToModelConstraint(this.getConstraintFor(request, child)));
            resize.add(c);
            ++i;
        }
        return resize.unwrap();
    }

    protected Command getMoveChildrenCommand(Request request) {
        return this.getResizeChildrenCommand((ChangeBoundsRequest)request);
    }
}

