/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.utils;

import com.google.common.collect.Multimap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class Copier {
    public static Object clone(Object o) {
        if (o instanceof Cloneable) {
            try {
                Method m = o.getClass().getMethod("clone", new Class[0]);
                m.setAccessible(true);
                return m.invoke(o, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (o instanceof Number) {
            return (Number)o;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Collection) {
            Collection l = (Collection)o;
            Collection r = Copier.allocateCloneContainer(l, l.size());
            for (Object oo : l) {
                r.add(Copier.clone(oo));
            }
            return r;
        }
        if (o instanceof Map) {
            Map l = (Map)o;
            Map r = Copier.allocateCloneContainer(l, l.size());
            Set entrySet = l.entrySet();
            for (Map.Entry e : entrySet) {
                r.put(Copier.clone(e.getKey()), Copier.clone(e.getValue()));
            }
            return r;
        }
        if (o instanceof Multimap) {
            Multimap l = (Multimap)o;
            Multimap r = Copier.allocateCloneContainerGoogleCollect(l, l.size());
            Collection entrySet = l.entries();
            for (Map.Entry e : entrySet) {
                r.put(Copier.clone(e.getKey()), Copier.clone(e.getValue()));
            }
            return r;
        }
        throw new IllegalArgumentException("unable to clone instances of " + o.getClass());
    }

    private static <E> E allocateCloneContainer(E o, int size) {
        try {
            Object r = o.getClass().getConstructor(Integer.TYPE).newInstance(size);
            return (E)r;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static <E> E allocateCloneContainerGoogleCollect(E o, int size) {
        try {
            Method m = o.getClass().getDeclaredMethod("create", Integer.TYPE);
            Object r = m.invoke(null, size);
            return (E)r;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

