/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.gemoc.dsl.debug.ide.DSLBreakpoint;
import org.eclipse.gemoc.dsl.debug.ide.ui.DebugIdeUiPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public final class EMFEditorUtils {
    private EMFEditorUtils() {
    }

    public static IEditorInput getEditorInput(Object element) {
        Resource resource;
        IEditorInput res = element instanceof EObject ? ((resource = ((EObject)element).eResource()) != null ? EMFEditorUtils.getEditorInputFromURI(resource.getURI()) : null) : (element instanceof DSLBreakpoint ? EMFEditorUtils.getEditorInputFromURI(((DSLBreakpoint)element).getURI().trimFragment()) : null);
        return res;
    }

    public static IEditorInput getEditorInputFromURI(URI uri) {
        Object res;
        if (uri != null) {
            if (uri.isPlatformResource()) {
                String path = uri.toPlatformString(true);
                IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
                res = workspaceResource instanceof IFile ? new FileEditorInput((IFile)workspaceResource) : new URIEditorInput(uri);
            } else {
                res = new URIEditorInput(uri);
            }
        } else {
            res = null;
        }
        return res;
    }

    public static String getEditorID(IEditorInput input, Object element) {
        IEditorDescriptor defaultEditor;
        String res = input instanceof URIEditorInput ? PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(((URIEditorInput)input).getURI().lastSegment()).getId() : (input instanceof IFileEditorInput ? ((defaultEditor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(((IFileEditorInput)input).getFile().getName())) != null ? defaultEditor.getId() : "org.eclipse.emf.ecore.presentation.ReflectiveEditorID") : null);
        return res;
    }

    public static void selectInstruction(IEditorPart editorPart, URI instructionUri) {
        if (editorPart instanceof IViewerProvider && editorPart instanceof IEditingDomainProvider) {
            EditingDomain domain = ((IEditingDomainProvider)editorPart).getEditingDomain();
            EObject selection = domain.getResourceSet().getEObject(instructionUri, false);
            if (selection != null) {
                ((IViewerProvider)editorPart).getViewer().setSelection((ISelection)new StructuredSelection((Object)selection), true);
            } else {
                DebugIdeUiPlugin.getPlugin().log(new IllegalStateException("can't find source for " + instructionUri));
            }
        }
    }

    public static void selectInstructions(IEditorPart editorPart, List<URI> instructionUris) {
        if (editorPart instanceof IViewerProvider && editorPart instanceof IEditingDomainProvider) {
            EditingDomain domain = ((IEditingDomainProvider)editorPart).getEditingDomain();
            ArrayList<EObject> selection = new ArrayList<EObject>();
            for (URI uri : instructionUris) {
                EObject eObject = domain.getResourceSet().getEObject(uri, false);
                if (eObject == null) continue;
                selection.add(eObject);
            }
            if (!selection.isEmpty()) {
                ((IViewerProvider)editorPart).getViewer().setSelection((ISelection)new StructuredSelection(selection), true);
            } else {
                DebugIdeUiPlugin.getPlugin().log(new IllegalStateException("can't find source for " + instructionUris));
            }
        }
    }
}

