/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gemoc.commons.eclipse.core.resources.NewProjectWorkspaceListener;
import org.eclipse.gemoc.commons.eclipse.ui.WizardFinder;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.Activator;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.wizards.CreateNewMoCProject;
import org.eclipse.gemoc.xdsmlframework.ui.utils.XDSMLProjectHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class CreateMOCCWizardContextAction {
    public static final String MOCCWIZARD_ID = "org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.wizards.CreateNewMoCProject";
    public CreateMOCCAction actionToExecute = CreateMOCCAction.CREATE_NEW_MOCC_PROJECT;
    protected IProject gemocLanguageIProject = null;
    protected String gemocLanguage = null;

    public CreateMOCCWizardContextAction(IProject updatedGemocLanguageProject) {
        this.gemocLanguageIProject = updatedGemocLanguageProject;
    }

    public CreateMOCCWizardContextAction(IProject updatedGemocLanguageProject, String melangeLanguage) {
        this.gemocLanguageIProject = updatedGemocLanguageProject;
        this.gemocLanguage = melangeLanguage;
    }

    public void execute() {
        switch (this.actionToExecute) {
            case CREATE_NEW_MOCC_PROJECT: {
                this.createNewMOCCProject();
                break;
            }
            case SELECT_EXISTING_MOCC_PROJECT: {
                this.selectExistingMOCCProject();
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createNewMOCCProject() {
        IWizardDescriptor descriptor = WizardFinder.findNewWizardDescriptor((String)MOCCWIZARD_ID);
        if (descriptor != null) {
            NewProjectWorkspaceListener workspaceListener = new NewProjectWorkspaceListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)workspaceListener);
            try {
                try {
                    IWorkbenchWizard wizard = descriptor.createWizard();
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    CreateNewMoCProject createNewMoCCProjectWizard = (CreateNewMoCProject)wizard;
                    String mLanguage = this.getLanguage();
                    if (mLanguage != null) {
                        this.initWizardFromLanguage(createNewMoCCProjectWizard, mLanguage);
                    }
                    wizard.init(workbench, null);
                    WizardDialog wd = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                    wd.create();
                    wd.setTitle(wizard.getWindowTitle());
                    int res = wd.open();
                    if (res != 0) return;
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
                    IProject createdProject = workspaceListener.getLastCreatedProject();
                    if (createdProject != null) {
                        this.addMOCCProjectToConf(createNewMoCCProjectWizard.createdProjectName);
                        return;
                    }
                    Activator.error("not able to detect which project was created by wizard", null);
                    return;
                }
                catch (CoreException e) {
                    Activator.error(e.getMessage(), e);
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
                }
                return;
            }
            finally {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
            }
        } else {
            Activator.error("wizard with id=org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.wizards.CreateNewMoCProject not found", null);
        }
    }

    protected void initWizardFromLanguage(CreateNewMoCProject createNewMOCProjectWizard, String language) {
        createNewMOCProjectWizard._askProjectNamePage.setInitialProjectName(String.valueOf(XDSMLProjectHelper.baseProjectName((IProject)this.gemocLanguageIProject)) + ".mocc");
        createNewMOCProjectWizard._askMoCInfoPage.initialTemplateMoCFileFieldValue = language.replaceAll(" ", "_");
    }

    protected void selectExistingMOCCProject() {
        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Gemoc Language Workbench UI", (String)"selectExistingMOCCProject. Action not implemented yet");
    }

    protected void addMOCCProjectToConf(String projectName) {
        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Gemoc Language Workbench UI", (String)"addMOCCProjectToConf. Action not implemented yet");
    }

    protected String getLanguage() {
        if (this.gemocLanguage != null) {
            return this.gemocLanguage;
        }
        return null;
    }

    public static enum CreateMOCCAction {
        CREATE_NEW_MOCC_PROJECT,
        SELECT_EXISTING_MOCC_PROJECT;

    }
}

