/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.statements;

import java.util.ConcurrentModificationException;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.query.internal.EMFQueryPlugin;
import org.eclipse.emf.query.internal.statements.QueryResultSet;
import org.eclipse.emf.query.internal.statements.QueryStatement;
import org.eclipse.emf.query.statements.FROM;
import org.eclipse.emf.query.statements.IQueryResult;
import org.eclipse.emf.query.statements.WHERE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SELECT
extends QueryStatement {
    public static final int UNBOUNDED = 0;
    private FROM from;
    private WHERE where;
    private int maximumResultSize;
    private TreeIterator<EObject> it;

    public SELECT(FROM from, WHERE where) {
        this(true, from, where);
    }

    public SELECT(boolean cancellable, FROM from, WHERE where) {
        this(0, cancellable, from, where);
    }

    public SELECT(int maximumResultSize, FROM from, WHERE where) {
        this(maximumResultSize, true, from, where);
    }

    public SELECT(int maximumResultSize, boolean cancellable, FROM from, WHERE where) {
        this(maximumResultSize, cancellable, from, where, (IProgressMonitor)new NullProgressMonitor());
    }

    public SELECT(int maximumResultSize, boolean cancellable, FROM from, WHERE where, IProgressMonitor progressMonitor) {
        super(cancellable, progressMonitor);
        this.from = from;
        this.where = where;
        this.maximumResultSize = maximumResultSize < 0 ? 0 : maximumResultSize;
    }

    @Override
    protected void doExecute() {
        this.it = this.getFromClause().iterator();
        this.doResume();
    }

    @Override
    protected void handleException(Exception exception, String functionName) {
        this.it = null;
        super.handleException(exception, functionName);
    }

    @Override
    public boolean canBeResumed() {
        try {
            return this.it != null && this.it.hasNext();
        }
        catch (ConcurrentModificationException ex) {
            EMFQueryPlugin.catching(this.getClass(), "canBeResumed", ex);
            EMFQueryPlugin.warning(10, ex.getMessage(), ex);
            this.it = null;
            return false;
        }
    }

    @Override
    protected void doResume() {
        EObject eObject = null;
        this.setResultSet(new QueryResultSet());
        boolean canPrune = this.getFromClause().canBePruned();
        WHERE whereClause = this.getWhereClause();
        while (this.it.hasNext() && !this.isCancelled()) {
            eObject = (EObject)this.it.next();
            if (whereClause.matches(eObject)) {
                this.addEObject(eObject);
                if (this.getResultSet().size() == this.maximumResultSize) break;
            }
            if (canPrune && whereClause.shouldPrune(eObject)) {
                this.it.prune();
            }
            this.getProgressMonitor().worked(1);
        }
        if (!this.it.hasNext()) {
            this.it = null;
        }
        if (this.isCancelled()) {
            ((QueryResultSet)this.getResultSet()).cancel();
            this.it = null;
        }
    }

    protected void addEObject(EObject eObject) {
        this.getResultSet().add(eObject);
    }

    protected boolean isCancelled() {
        return this.isCancellable() && this.getProgressMonitor().isCanceled();
    }

    private FROM getFromClause() {
        return this.from;
    }

    private WHERE getWhereClause() {
        return this.where;
    }

    @Override
    public final IQueryResult execute() {
        return super.execute();
    }

    @Override
    public final Set<? extends EObject> getEObjects() {
        return super.getEObjects();
    }

    @Override
    public final IQueryResult resume(IProgressMonitor progressMon) {
        return super.resume(progressMon);
    }
}

