/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.delegate;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicInvocationDelegate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.delegate.ValidationBehavior;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationException;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.delegate.InvocationBehavior;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.pivot.internal.helper.BasicQueryImpl;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.SemanticException;
import org.eclipse.ocl.pivot.utilities.StringUtil;

public class OCLInvocationDelegate
extends BasicInvocationDelegate {
    protected final OCLDelegateDomain delegateDomain;
    private Operation operation;
    private ExpressionInOCL specification;

    public OCLInvocationDelegate(@NonNull OCLDelegateDomain delegateDomain, @NonNull EOperation operation) {
        super(operation);
        this.delegateDomain = delegateDomain;
    }

    public Object dynamicInvoke(InternalEObject target, EList<?> arguments) throws InvocationTargetException {
        try {
            EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.getEnvironmentFactory((Object)target);
            PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
            IdResolver idResolver = environmentFactory.getIdResolver();
            ExpressionInOCL specification2 = this.specification;
            if (specification2 == null) {
                Operation operation2 = this.operation;
                NamedElement namedElement = (NamedElement)this.delegateDomain.getPivot(NamedElement.class, (EObject)ClassUtil.nonNullEMF((Object)this.eOperation));
                if (namedElement instanceof Operation) {
                    operation2 = this.operation = (Operation)namedElement;
                    specification2 = this.specification = InvocationBehavior.INSTANCE.getQueryOrThrow((MetamodelManager)metamodelManager, operation2);
                    InvocationBehavior.INSTANCE.validate((EObject)operation2);
                } else if (namedElement instanceof Constraint) {
                    Constraint constraint = (Constraint)namedElement;
                    specification2 = this.specification = this.getExpressionInOCL((MetamodelManager)metamodelManager, constraint);
                    ValidationBehavior.INSTANCE.validate((EObject)constraint);
                } else {
                    if (namedElement != null) {
                        throw new OCLDelegateException((Exception)new SemanticException("Unsupported InvocationDelegate for a " + namedElement.eClass().getName()));
                    }
                    throw new OCLDelegateException((Exception)new SemanticException("Unsupported InvocationDelegate for null"));
                }
            }
            BasicQueryImpl query = new BasicQueryImpl((EnvironmentFactory)environmentFactory, specification2);
            EvaluationEnvironment env = query.getEvaluationEnvironment((Object)target);
            Object object = target;
            Object value = idResolver.boxedValueOf((Object)target);
            env.add((TypedElement)ClassUtil.nonNullModel((Object)specification2.getOwnedContext()), value);
            List parms = specification2.getOwnedParameters();
            if (!parms.isEmpty()) {
                int i = 0;
                while (i < parms.size()) {
                    object = arguments.get(i);
                    value = idResolver.boxedValueOf(object);
                    env.add((TypedElement)ClassUtil.nonNullModel((Object)((Variable)parms.get(i))), value);
                    ++i;
                }
            }
            Object result = query.evaluateEcore(this.eOperation.getEType().getInstanceClass(), (Object)target);
            return result;
        }
        catch (EvaluationException e) {
            throw new OCLDelegateException((Exception)((Object)new EvaluationException((Throwable)e, PivotMessagesInternal.EvaluationResultIsInvalid_ERROR_, new Object[]{this.operation})));
        }
    }

    public @NonNull ExpressionInOCL getExpressionInOCL(@NonNull MetamodelManager metamodelManager, @NonNull Constraint constraint) {
        ExpressionInOCL query = null;
        Type contextType = (Type)constraint.getContext();
        if (contextType != null) {
            query = ValidationBehavior.INSTANCE.getQueryOrThrow(metamodelManager, constraint);
        }
        if (query == null) {
            String message = StringUtil.bind((String)PivotMessagesInternal.MissingBodyForInvocationDelegate_ERROR_, (Object[])new Object[]{constraint.getContext()});
            throw new OCLDelegateException((Exception)new SemanticException(message));
        }
        return query;
    }

    public @NonNull Operation getOperation() {
        Operation operation2 = this.operation;
        if (operation2 == null) {
            NamedElement pivot = (NamedElement)this.delegateDomain.getPivot(NamedElement.class, (EObject)ClassUtil.nonNullEMF((Object)this.eOperation));
            if (pivot instanceof Operation) {
                operation2 = this.operation = (Operation)pivot;
            }
            if (operation2 == null) {
                throw new OCLDelegateException((Exception)new SemanticException("No pivot property for " + this.eOperation));
            }
        }
        return operation2;
    }

    public String toString() {
        if (this.operation != null) {
            return "<" + this.delegateDomain.getURI() + ":invocation> " + this.operation;
        }
        String name = String.valueOf(this.eOperation.getEContainingClass().getEPackage().getName()) + "::" + this.eOperation.getEContainingClass().getName() + "." + this.eOperation.getName();
        return "<" + this.delegateDomain.getURI() + ":invocation> " + name;
    }
}

