/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dsa.executors.explorer;

import grph.Grph;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons.MoccmlModelExecutionContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dsa.executors.explorer.ControlAndRTDState;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dsa.executors.explorer.StateSpace;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.engine.MoccmlExecutionEngine;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.dsa.helper.IK3ModelStateHelper;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dse.IMoccmlFutureAction;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.moc.ICCSLExplorer;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.moc.ICCSLSolver;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericParallelStep;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericStep;
import org.eclipse.gemoc.trace.commons.model.trace.SmallStep;
import org.eclipse.gemoc.trace.commons.model.trace.Step;

public class ExhaustiveConcurrentExecutionEngine
extends MoccmlExecutionEngine {
    public StateSpace stateSpace = new StateSpace();
    protected ArrayList<ControlAndRTDState> statesToExplore = new ArrayList();
    private boolean savedDotRegularly = true;

    public ExhaustiveConcurrentExecutionEngine(MoccmlModelExecutionContext concurrentexecutionContext, ICCSLSolver s) throws CoreException {
        super(concurrentexecutionContext, s);
    }

    @Override
    protected void performExecutionStep() {
        Grph internalGrph;
        IProject modelProject;
        ControlAndRTDState initialState;
        String fullLanguageName = ((MoccmlModelExecutionContext)this._executionContext).getLanguageDefinitionExtension().getName();
        int lastDot = fullLanguageName.lastIndexOf(".");
        if (lastDot == -1) {
            lastDot = 0;
        }
        String languageName = fullLanguageName.substring(lastDot + 1);
        String languageToUpperFirst = String.valueOf(languageName.substring(0, 1).toUpperCase()) + languageName.substring(1);
        IK3ModelStateHelper modelStateHelper = null;
        try {
            modelStateHelper = (IK3ModelStateHelper)((MoccmlModelExecutionContext)this._executionContext).getDslBundle().loadClass(String.valueOf(languageToUpperFirst.toLowerCase()) + ".xdsml.api.impl." + languageToUpperFirst + "ModelStateHelper").newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        EObject model = (EObject)((MoccmlModelExecutionContext)this._executionContext).getResourceModel().getContents().get(0);
        ((ICCSLExplorer)this._solver).initSolverForExploration();
        this.stateSpace.initialState = initialState = new ControlAndRTDState(modelStateHelper.getK3StateSpaceModelState(model), ((ICCSLSolver)this._solver).getState(), this.saveState());
        this.stateSpace.addVertex(initialState);
        this.statesToExplore.add(initialState);
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
        LocalDateTime now = LocalDateTime.now();
        System.out.println("starts exploring state space on " + now);
        int exploredStates = 0;
        while (!this.statesToExplore.isEmpty()) {
            System.out.println("###################  explored " + exploredStates + "  ##################### still " + this.statesToExplore.size() + " steps to explore ###########");
            ++exploredStates;
            this._possibleLogicalSteps = null;
            ControlAndRTDState currentState = this.statesToExplore.remove(0);
            modelStateHelper.restoreModelState(currentState.modelState);
            ((ICCSLSolver)this._solver).setState(currentState.moCCState);
            this.restoreState((Pair<Map<String, Boolean>, ArrayList<IMoccmlFutureAction>>)Pair.of(currentState.nextEventToForce, currentState.futurActions));
            this.beforeUpdatePossibleLogicalSteps();
            ((ICCSLExplorer)this._solver).computeAndGetPossibleLogicalStepsForExploration();
            this._possibleLogicalSteps = ((ICCSLExplorer)this._solver).updatePossibleLogicalStepsForExploration();
            int originalPossibleLogicalStepSize = this._possibleLogicalSteps.size();
            int i = 0;
            while (i < this._possibleLogicalSteps.size()) {
                StringBuffer buf;
                if (this.getPossibleLogicalSteps().size() != originalPossibleLogicalStepSize) {
                    System.err.println("something went wrong during mocc state save/restore");
                }
                ((ICCSLExplorer)this._solver).prepareSolverForNewStepForExploration();
                Step aStep = (Step)this.getPossibleLogicalSteps().get(i);
                this.setSelectedLogicalStep(aStep);
                try {
                    this.executeSelectedLogicalStep();
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
                ((ICCSLExplorer)this._solver).applyLogicalStepForExploration(aStep);
                this.engineStatus.incrementNbLogicalStepRun();
                ControlAndRTDState newState = new ControlAndRTDState(modelStateHelper.getK3StateSpaceModelState(model), ((ICCSLSolver)this._solver).getState(), this.saveState());
                ControlAndRTDState theExistingState = null;
                for (ControlAndRTDState s : this.stateSpace.getVertices()) {
                    if (!newState.equals(s)) continue;
                    theExistingState = s;
                    break;
                }
                if (theExistingState == null) {
                    this.stateSpace.addVertex(newState);
                    buf = new StringBuffer(this.prettyPrint((GenericParallelStep)aStep));
                    this.stateSpace.addDirectedSimpleEdge(currentState, buf, newState);
                    this.statesToExplore.add(newState);
                } else {
                    assert (theExistingState != null);
                    buf = new StringBuffer(this.prettyPrint((GenericParallelStep)aStep));
                    this.stateSpace.addDirectedSimpleEdge(currentState, buf, theExistingState);
                }
                modelStateHelper.restoreModelState(currentState.modelState);
                ((ICCSLSolver)this._solver).setState(currentState.moCCState);
                this.restoreState((Pair<Map<String, Boolean>, ArrayList<IMoccmlFutureAction>>)Pair.of(currentState.nextEventToForce, currentState.futurActions));
                ++i;
            }
            ((ICCSLExplorer)this._solver).resetCurrentStepForExploration();
            if (!this.savedDotRegularly || exploredStates % 100 != 0) continue;
            String modelPath = ((MoccmlModelExecutionContext)this._executionContext).getResourceModel().getURI().toPlatformString(true);
            modelProject = ResourcesPlugin.getWorkspace().getRoot().getProject(modelPath.substring(1, modelPath.substring(1).indexOf(47) + 1));
            IFile autFile = modelProject.getFile(String.valueOf(modelPath.replace("/" + modelProject.getName() + "/", "")) + "_temp_statespace.dot");
            PrintStream psDot = null;
            try {
                psDot = new PrintStream(autFile.getLocationURI().toString().substring(5));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            internalGrph = this.stateSpace.getGrph();
            psDot.print(internalGrph.toDot().replaceAll("##", "#"));
            psDot.close();
        }
        this._solver = null;
        this.stop();
        PrintStream psDot = null;
        PrintStream psAut = null;
        String modelPath = ((MoccmlModelExecutionContext)this._executionContext).getResourceModel().getURI().toPlatformString(true);
        modelProject = ResourcesPlugin.getWorkspace().getRoot().getProject(modelPath.substring(1, modelPath.substring(1).indexOf(47) + 1));
        IFile dotFile = modelProject.getFile(String.valueOf(modelPath.replace("/" + modelProject.getName() + "/", "")) + "_statespace.dot");
        IFile autFile = modelProject.getFile(String.valueOf(modelPath.replace("/" + modelProject.getName() + "/", "")) + "_statespace.aut");
        try {
            psDot = new PrintStream(dotFile.getLocationURI().toString().substring(5));
            psAut = new PrintStream(autFile.getLocationURI().toString().substring(5));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        internalGrph = this.stateSpace.getGrph();
        now = LocalDateTime.now();
        System.out.println("just finished exploring state space on " + now);
        System.out.println("################################################res: " + internalGrph.getVertices().size() + " states and " + internalGrph.getEdges().size() + " transitions");
        psDot.print(internalGrph.toDot().replaceAll("##", "#").replaceAll("MSE_", "").replaceAll("([^_]*)_[^_]*_([^ ]*)", "$1::$2"));
        psDot.close();
        this.createAutStateSpaceFormat(psAut);
    }

    private String prettyPrint(GenericParallelStep aStep) {
        StringBuilder sbStep = new StringBuilder();
        for (GenericStep s : aStep.getSubSteps()) {
            sbStep.append(String.valueOf(((SmallStep)s).getMseoccurrence().getMse().getName()) + " ");
        }
        return sbStep.toString();
    }

    @Override
    public String engineKindName() {
        return "GEMOC Moccml Exhaustive Concurrent Engine";
    }

    private void createAutStateSpaceFormat(PrintStream psAut) {
        Iterator iterVertices = this.stateSpace.getVertices().iterator();
        ControlAndRTDState aState = (ControlAndRTDState)iterVertices.next();
        if (aState == null) {
            System.err.println("no State space to serialize");
            return;
        }
        StringBuilder fileContent = new StringBuilder();
        fileContent.append("des(");
        fileContent.append(this.stateSpace.v2i(this.stateSpace.initialState));
        fileContent.append(",");
        fileContent.append(this.stateSpace.getGrph().getEdges().size());
        fileContent.append(",");
        fileContent.append(this.stateSpace.getGrph().getVertices().size());
        fileContent.append(")\n");
        for (ControlAndRTDState s1 : this.stateSpace.getVertices()) {
            for (ControlAndRTDState s2 : this.stateSpace.getVertices()) {
                for (StringBuffer t : this.stateSpace.getEdges(s1, s2)) {
                    String aLine = "(" + this.stateSpace.v2i(s1) + ", " + this.mclFormat(t) + "\", " + this.stateSpace.v2i(s2) + ")";
                    fileContent.append(aLine);
                    fileContent.append("\n");
                }
            }
        }
        psAut.print(fileContent.toString());
        psAut.close();
    }

    private String mclFormat(StringBuffer t) {
        StringBuffer res = new StringBuffer("\"LS !");
        String[] stringArray = t.toString().split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            res.append(":");
            res.append(s);
            ++n2;
        }
        return res.toString().replaceAll("\\[", "").replaceAll("\\]", "");
    }
}

