/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.compiler.helpers;

import fr.inria.aoste.timesquare.ccslkernel.compiler.Activator;
import fr.inria.aoste.timesquare.ccslkernel.compiler.CompilerParameters;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.pde.core.project.IBundleClasspathEntry;
import org.eclipse.pde.core.project.IBundleProjectDescription;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.eclipse.pde.core.project.IPackageExportDescription;
import org.eclipse.pde.core.project.IRequiredBundleDescription;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class PluginProjectHelper {
    protected IWorkspace workspace = ResourcesPlugin.getWorkspace();
    protected IWorkspaceRoot root = this.workspace.getRoot();

    public IProject createPluginProject(String projectName) throws CoreException {
        BundleContext context = Activator.getContext();
        ServiceReference ref = context.getServiceReference(IBundleProjectService.class);
        IBundleProjectService service = (IBundleProjectService)context.getService(ref);
        IProject project = this.getExistingProject(projectName);
        if (project != null) {
            this.fixExistingProject(project);
            return project;
        }
        project = this.createProject(projectName);
        IBundleProjectDescription bundleDesc = service.getDescription(project);
        service.setBundleRoot(project, null);
        if (bundleDesc.getSymbolicName() == null || bundleDesc.getSymbolicName().compareTo(projectName) != 0) {
            bundleDesc.setSymbolicName(projectName);
        }
        if (bundleDesc.getBundleName() == null || bundleDesc.getBundleName().compareTo(projectName) != 0) {
            bundleDesc.setBundleName(projectName);
        }
        bundleDesc.setLocationURI(project.getLocationURI());
        bundleDesc.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature"});
        bundleDesc.setExecutionEnvironments(new String[]{"JavaSE-1.7", "JavaSE-1.6"});
        bundleDesc.setRequiredBundles(new IRequiredBundleDescription[0]);
        IPath[] iPathTab = new IPath[]{new Path(".")};
        bundleDesc.setBinIncludes(iPathTab);
        bundleDesc.apply((IProgressMonitor)new NullProgressMonitor());
        this.initializePluginProjectBuilders(project);
        this.setPluginProjectClassPath(project);
        IBundleClasspathEntry cpe2 = service.newBundleClasspathEntry((IPath)new Path(CompilerParameters.genSourceFolder), null, null);
        bundleDesc.setBundleClasspath(new IBundleClasspathEntry[]{cpe2});
        bundleDesc.apply((IProgressMonitor)new NullProgressMonitor());
        context.ungetService(ref);
        return project;
    }

    private void fixExistingProject(IProject project) throws CoreException {
        String[] newNatures;
        BundleContext context = Activator.getContext();
        ServiceReference ref = context.getServiceReference(IBundleProjectService.class);
        IBundleProjectService service = (IBundleProjectService)context.getService(ref);
        IBundleProjectDescription bundleDesc = service.getDescription(project);
        if (!this.isJavaProject(project)) {
            newNatures = Arrays.copyOf(bundleDesc.getNatureIds(), bundleDesc.getNatureIds().length + 1);
            newNatures[bundleDesc.getNatureIds().length] = "org.eclipse.jdt.core.javanature";
            bundleDesc.setNatureIds(newNatures);
            bundleDesc.apply((IProgressMonitor)new NullProgressMonitor());
        }
        if (!this.isPluginProject(project)) {
            newNatures = Arrays.copyOf(bundleDesc.getNatureIds(), bundleDesc.getNatureIds().length + 1);
            newNatures[bundleDesc.getNatureIds().length] = "org.eclipse.pde.PluginNature";
            bundleDesc.setNatureIds(newNatures);
            bundleDesc.apply((IProgressMonitor)new NullProgressMonitor());
        }
        String[] execEnv = bundleDesc.getExecutionEnvironments();
        boolean envJava6Found = false;
        boolean envJava7Found = false;
        if (execEnv != null) {
            String[] stringArray = execEnv;
            int n = execEnv.length;
            int n2 = 0;
            while (n2 < n) {
                String env = stringArray[n2];
                if (env.compareTo("JavaSE-1.7") == 0) {
                    envJava7Found = true;
                } else if (env.compareTo("JavaSE-1.6") == 0) {
                    envJava6Found = true;
                }
                ++n2;
            }
        }
        if (!envJava6Found) {
            this.addExecutionEnvironment(bundleDesc, "JavaSE-1.6");
        }
        if (!envJava7Found) {
            this.addExecutionEnvironment(bundleDesc, "JavaSE-1.7");
        }
        this.fixPluginProjectBuilders(project);
        this.fixPluginProjectClassPath(project);
        context.ungetService(ref);
    }

    private boolean isJavaProject(IProject project) throws CoreException {
        BundleContext context = Activator.getContext();
        ServiceReference ref = context.getServiceReference(IBundleProjectService.class);
        IBundleProjectService service = (IBundleProjectService)context.getService(ref);
        IBundleProjectDescription bundleDesc = service.getDescription(project);
        boolean isJavaProject = false;
        String[] stringArray = bundleDesc.getNatureIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (nature.compareTo("org.eclipse.jdt.core.javanature") == 0) {
                isJavaProject = true;
            }
            ++n2;
        }
        context.ungetService(ref);
        return isJavaProject;
    }

    private boolean isPluginProject(IProject project) throws CoreException {
        BundleContext context = Activator.getContext();
        ServiceReference ref = context.getServiceReference(IBundleProjectService.class);
        IBundleProjectService service = (IBundleProjectService)context.getService(ref);
        IBundleProjectDescription bundleDesc = service.getDescription(project);
        boolean isPluginProject = false;
        String[] stringArray = bundleDesc.getNatureIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (nature.compareTo("org.eclipse.pde.PluginNature") == 0 || nature.compareTo("org.eclipse.pde.PluginNature") == 0) {
                isPluginProject = true;
            }
            ++n2;
        }
        context.ungetService(ref);
        return isPluginProject;
    }

    private void addExecutionEnvironment(IBundleProjectDescription bundleDesc, String env) throws CoreException {
        String[] newEnvs;
        String[] currentEnvs = bundleDesc.getExecutionEnvironments();
        if (currentEnvs != null) {
            newEnvs = Arrays.copyOf(currentEnvs, currentEnvs.length + 1);
            newEnvs[currentEnvs.length] = env;
        } else {
            newEnvs = new String[]{env};
        }
        bundleDesc.setExecutionEnvironments(newEnvs);
        bundleDesc.apply((IProgressMonitor)new NullProgressMonitor());
    }

    private IProject createProject(final String projectName) throws CoreException {
        final IProject[] result = new IProject[1];
        IWorkspaceRunnable operation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProject project = PluginProjectHelper.this.root.getProject(projectName);
                if (project.exists()) {
                    project.open((IProgressMonitor)new NullProgressMonitor());
                    project.refreshLocal(2, null);
                    result[0] = project;
                    return;
                }
                project.create((IProgressMonitor)new NullProgressMonitor());
                project.open((IProgressMonitor)new NullProgressMonitor());
                project.refreshLocal(2, null);
                result[0] = project;
            }
        };
        this.workspace.run(operation, (IProgressMonitor)new NullProgressMonitor());
        return result[0];
    }

    private IProject getExistingProject(final String projectName) throws CoreException {
        final IProject[] result = new IProject[1];
        IWorkspaceRunnable operation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProject project = PluginProjectHelper.this.root.getProject(projectName);
                if (project.exists()) {
                    project.open((IProgressMonitor)new NullProgressMonitor());
                    project.refreshLocal(2, null);
                    result[0] = project;
                    return;
                }
                result[0] = null;
            }
        };
        this.workspace.run(operation, (IProgressMonitor)new NullProgressMonitor());
        return result[0];
    }

    private void setPluginProjectClassPath(IProject project) throws CoreException {
        IFolder genSrcFolder;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IFolder srcFolder = project.getFolder((IPath)new Path(CompilerParameters.sourceFolder));
        if (!srcFolder.exists()) {
            srcFolder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!(genSrcFolder = project.getFolder((IPath)new Path(CompilerParameters.genSourceFolder))).exists()) {
            genSrcFolder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
        }
        IClasspathEntry src = JavaCore.newSourceEntry((IPath)srcFolder.getFullPath());
        IClasspathEntry genSrc = JavaCore.newSourceEntry((IPath)genSrcFolder.getFullPath());
        IClasspathEntry jre = JavaCore.newContainerEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER), (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)false);
        IClasspathEntry reqPlugins = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins"), (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)false);
        IClasspathEntry[] entries = new IClasspathEntry[]{src, genSrc, jre, reqPlugins};
        javaProject.setRawClasspath(entries, project.getFullPath().append("bin"), (IProgressMonitor)new NullProgressMonitor());
        javaProject.save((IProgressMonitor)new NullProgressMonitor(), true);
    }

    private void fixPluginProjectClassPath(IProject project) throws CoreException {
        IClasspathEntry entry;
        IFolder genSrcFolder;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IFolder srcFolder = project.getFolder((IPath)new Path(CompilerParameters.sourceFolder));
        if (!srcFolder.exists()) {
            srcFolder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!(genSrcFolder = project.getFolder((IPath)new Path(CompilerParameters.genSourceFolder))).exists()) {
            genSrcFolder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
        }
        IClasspathEntry[] currentClasspath = javaProject.getRawClasspath();
        boolean srcgenEntryFound = false;
        boolean jreEntryFound = false;
        boolean reqPluginsEntryFound = false;
        IClasspathEntry[] iClasspathEntryArray = currentClasspath;
        int n = currentClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && entry.getPath().equals((Object)genSrcFolder.getFullPath())) {
                srcgenEntryFound = true;
            }
            if (entry.getEntryKind() == 5 && entry.getPath().toString().equals(JavaRuntime.JRE_CONTAINER)) {
                jreEntryFound = true;
            }
            if (entry.getEntryKind() == 5 && entry.getPath().toString().equals("org.eclipse.pde.core.requiredPlugins")) {
                reqPluginsEntryFound = true;
            }
            ++n2;
        }
        if (!srcgenEntryFound) {
            entry = JavaCore.newSourceEntry((IPath)genSrcFolder.getFullPath());
            this.addClasspathEntry(javaProject, entry);
        }
        if (!jreEntryFound) {
            entry = JavaCore.newContainerEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER));
            this.addClasspathEntry(javaProject, entry);
        }
        if (!reqPluginsEntryFound) {
            entry = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins"));
            this.addClasspathEntry(javaProject, entry);
        }
    }

    private void addClasspathEntry(IProject project, IClasspathEntry entry) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            this.addClasspathEntry(javaProject, entry);
        }
    }

    private void addClasspathEntry(IJavaProject javaProject, IClasspathEntry entry) throws JavaModelException {
        IClasspathEntry[] currentClasspath = javaProject.getRawClasspath();
        IClasspathEntry[] newClasspath = Arrays.copyOf(currentClasspath, currentClasspath.length + 1);
        newClasspath[currentClasspath.length] = entry;
        javaProject.setRawClasspath(newClasspath, (IProgressMonitor)new NullProgressMonitor());
        javaProject.save((IProgressMonitor)new NullProgressMonitor(), true);
    }

    private void fixPluginProjectBuilders(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        if (commands == null || commands.length == 0) {
            this.initializePluginProjectBuilders(project);
            return;
        }
        boolean javaBuilderFound = false;
        boolean manifestBuilderFound = false;
        boolean schemaBuilderFound = false;
        ArrayList<ICommand> otherBuilders = new ArrayList<ICommand>();
        Object object = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand cmd = object[n2];
            if (cmd.getBuilderName().compareTo("org.eclipse.jdt.core.javabuilder") == 0) {
                javaBuilderFound = !manifestBuilderFound && !schemaBuilderFound;
            } else if (cmd.getBuilderName().compareTo("org.eclipse.pde.ManifestBuilder") == 0) {
                manifestBuilderFound = javaBuilderFound && !schemaBuilderFound;
            } else if (cmd.getBuilderName().compareTo("org.eclipse.pde.SchemaBuilder") == 0) {
                schemaBuilderFound = javaBuilderFound && schemaBuilderFound;
            } else {
                otherBuilders.add(cmd);
            }
            ++n2;
        }
        if (!(javaBuilderFound && manifestBuilderFound && schemaBuilderFound)) {
            ICommand[] newCmds = new ICommand[otherBuilders.size() + 3];
            newCmds[0] = description.newCommand();
            newCmds[1] = description.newCommand();
            newCmds[2] = description.newCommand();
            newCmds[0].setBuilderName("org.eclipse.jdt.core.javabuilder");
            newCmds[1].setBuilderName("org.eclipse.pde.ManifestBuilder");
            newCmds[2].setBuilderName("org.eclipse.pde.SchemaBuilder");
            int i = 3;
            object = otherBuilders.iterator();
            while (object.hasNext()) {
                ICommand cmd;
                newCmds[i] = cmd = (ICommand)object.next();
                ++i;
            }
            description.setBuildSpec(newCmds);
            project.setDescription(description, 1, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void initializePluginProjectBuilders(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = new ICommand[]{description.newCommand(), description.newCommand(), description.newCommand()};
        commands[0].setBuilderName("org.eclipse.jdt.core.javabuilder");
        commands[1].setBuilderName("org.eclipse.pde.ManifestBuilder");
        commands[2].setBuilderName("org.eclipse.pde.SchemaBuilder");
        description.setBuildSpec(commands);
        project.setDescription(description, 1, (IProgressMonitor)new NullProgressMonitor());
    }

    public void addRequiredBundle(IProject project, String bundleName) throws CoreException {
        IRequiredBundleDescription reqBundle;
        ServiceReference ref;
        BundleContext context = Activator.getContext();
        IBundleProjectService service = (IBundleProjectService)context.getService(ref = context.getServiceReference(IBundleProjectService.class));
        IBundleProjectDescription bundleDesc = service.getDescription(project);
        IRequiredBundleDescription[] required = bundleDesc.getRequiredBundles();
        int newLength = required != null ? required.length + 1 : 1;
        IRequiredBundleDescription[] newRequired = new IRequiredBundleDescription[newLength];
        if (required != null) {
            System.arraycopy(required, 0, newRequired, 0, required.length);
        }
        newRequired[newLength - 1] = reqBundle = service.newRequiredBundle(bundleName, null, false, false);
        bundleDesc.setRequiredBundles(newRequired);
        bundleDesc.apply((IProgressMonitor)new NullProgressMonitor());
        context.ungetService(ref);
    }

    public void addExportedPackage(IProject project, String packageName) throws CoreException {
        ServiceReference ref;
        BundleContext context = Activator.getContext();
        IBundleProjectService service = (IBundleProjectService)context.getService(ref = context.getServiceReference(IBundleProjectService.class));
        IBundleProjectDescription bundleDesc = service.getDescription(project);
        IPackageExportDescription[] exports = bundleDesc.getPackageExports();
        int newLength = exports != null ? exports.length + 1 : 1;
        IPackageExportDescription[] newExports = new IPackageExportDescription[newLength];
        if (exports != null) {
            System.arraycopy(exports, 0, newExports, 0, exports.length);
        }
        newExports[newLength - 1] = service.newPackageExport(packageName, null, true, null);
        bundleDesc.setPackageExports(newExports);
        bundleDesc.apply((IProgressMonitor)new NullProgressMonitor());
        context.ungetService(ref);
    }

    private void createFolder(IFolder folder) throws CoreException {
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            this.createFolder((IFolder)parent);
        }
        if (!folder.exists()) {
            folder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void createFolder(IProject project, IPath path) throws CoreException {
        IFolder newFolder = project.getFolder(path);
        this.createFolder(newFolder);
    }

    public void createFolder(IProject project, String path) throws CoreException {
        this.createFolder(project, (IPath)new Path(path));
    }

    public void createPackage(IProject project, String packageName) throws CoreException {
        String packageFolder = packageName.replace('.', File.separatorChar);
        this.createFolder(project, String.valueOf(CompilerParameters.genSourceFolder) + File.separator + packageFolder);
        this.addExportedPackage(project, packageName);
    }

    public IFile createFile(IProject project, String path, String content) throws CoreException {
        IFile file = project.getFile(path);
        if (file.exists()) {
            file.delete(true, null);
        }
        file.create((InputStream)new ByteArrayInputStream(content.getBytes()), true, null);
        return file;
    }
}

