/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.ui.services;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecoretools.ale.Attribute;
import org.eclipse.emf.ecoretools.ale.BehavioredClass;
import org.eclipse.emf.ecoretools.ale.Operation;
import org.eclipse.emf.ecoretools.ale.Unit;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.ide.env.WithAbsoluteBehaviorPathsAleEnvironment;
import org.eclipse.emf.ecoretools.ale.ide.project.IAleProject;
import org.eclipse.emf.ecoretools.ale.ide.ui.Activator;
import org.eclipse.emf.ecoretools.ale.ide.ui.AlePreferenceStore;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;
import org.eclipse.emf.ecoretools.design.service.EcoreToolsDesignPlugin;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.impl.LeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class Services {
    public static final String IMPLEM_EXTENSION = "ale";
    public static final String DSL_EXTENSION = "dsl";

    public boolean isImplemented(EObject elem) {
        if (elem instanceof EOperation) {
            EOperation op = (EOperation)elem;
            List<ModelUnit> modelUnits = this.getModelBehavior(elem);
            Optional<ExtendedClass> searchCls = modelUnits.stream().map(elm -> elm).flatMap(u -> u.getClassExtensions().stream()).filter(ext -> ext.getBaseClass().getName().equals(op.getEContainingClass().getName())).findFirst();
            if (searchCls.isPresent()) {
                ExtendedClass xtdClass = searchCls.get();
                return xtdClass.getMethods().stream().anyMatch(mtd -> mtd.getOperationRef() != null && mtd.getOperationRef().getName().equals(op.getName()) && mtd.getOperationRef().getEContainingClass() == xtdClass.getBaseClass());
            }
        }
        return false;
    }

    private List<ModelUnit> getModelBehavior(EObject element) {
        IAleEnvironment env;
        if (element.eResource() == null) {
            return Collections.emptyList();
        }
        Session session = SessionManager.INSTANCE.getSession(element);
        if (session == null) {
            Path modelFilePath = new Path(element.eResource().getURI().toPlatformString(true));
            IFile modelFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)modelFilePath);
            IProject modelProject = modelFile.getProject();
            env = IAleProject.from((IProject)modelProject).getEnvironment();
            Activator.warn("Unable to find representation file for '" + element + "', Behavior layer will be filled from project '" + modelProject.getName() + "' instead", null);
        } else {
            Optional<AirdResource> aird = session.getAllSessionResources().stream().filter(AirdResource.class::isInstance).map(AirdResource.class::cast).findAny();
            if (!aird.isPresent()) {
                return new ArrayList<ModelUnit>(0);
            }
            IFile airdFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(aird.get().getURI().toPlatformString(true)));
            env = IAleProject.from((IProject)airdFile.getProject()).getEnvironment();
        }
        return env.getBehaviors().getUnits();
    }

    public List<org.eclipse.emf.ecoretools.ale.implementation.Attribute> getDynaAttrib(EClass cls) {
        List<ModelUnit> modelUnits = this.getModelBehavior((EObject)cls);
        Optional<ExtendedClass> searchCls = modelUnits.stream().flatMap(u -> u.getClassExtensions().stream()).filter(ext -> ext.getBaseClass().getName().equals(cls.getName())).findFirst();
        if (searchCls.isPresent()) {
            ExtendedClass xtdCls = searchCls.get();
            return xtdCls.getAttributes().stream().collect(Collectors.toList());
        }
        return new ArrayList<org.eclipse.emf.ecoretools.ale.implementation.Attribute>();
    }

    public List<org.eclipse.emf.ecoretools.ale.implementation.Attribute> getDynaAttrib(RuntimeClass cls) {
        return cls.getAttributes().stream().collect(Collectors.toList());
    }

    public List<Method> getMethod(EClass cls) {
        List<ModelUnit> modelUnits = this.getModelBehavior((EObject)cls);
        Optional<ExtendedClass> searchCls = modelUnits.stream().flatMap(u -> u.getClassExtensions().stream()).filter(ext -> ext.getBaseClass().getName().equals(cls.getName())).findFirst();
        if (searchCls.isPresent()) {
            ExtendedClass xtdCls = searchCls.get();
            return xtdCls.getMethods().stream().filter(op -> op instanceof Method).map(op -> op).filter(op -> !this.isImplemented((EObject)op.getOperationRef())).collect(Collectors.toList());
        }
        return new ArrayList<Method>();
    }

    public List<Method> getMethod(RuntimeClass cls) {
        return cls.getMethods().stream().filter(op -> op instanceof Method).map(op -> op).collect(Collectors.toList());
    }

    public ModelUnit getModelUnit(EPackage pkg) {
        List<ModelUnit> res = this.getModelBehavior((EObject)pkg);
        if (!res.isEmpty()) {
            return res.get(0);
        }
        return null;
    }

    public EOperation editImplementation(final EOperation op) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IFile file = Services.getImplemFile(op.getEContainingClass().getName(), op.eResource());
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        try {
            IEditorPart oldEditor = page.getActiveEditor();
            IEditorPart editor = page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
            if (!this.hasXtextFocus(file.getProject())) {
                page.activate((IWorkbenchPart)oldEditor);
            }
            if (editor instanceof XtextEditor) {
                final XtextEditor xEditor = (XtextEditor)editor;
                final IXtextDocument document = xEditor.getDocument();
                document.modify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                    public void process(XtextResource state) throws Exception {
                        if (!state.getContents().isEmpty()) {
                            Unit root = (Unit)state.getContents().get(0);
                            String returnType = "void";
                            if (op.getEType() != null) {
                                returnType = op.getEType().getName();
                            }
                            String parameters = op.getEParameters().stream().map(p -> String.valueOf(p.getEType().getName()) + " " + p.getName()).collect(Collectors.joining(",", "(", ")"));
                            String opName = op.getName();
                            String content = "/* Write your code here */";
                            String template = "\toverride " + returnType + " " + opName + " " + parameters + " {\n\t\t" + content + "\n\t}\n";
                            EList allXtdCls = root.getXtendedClasses();
                            Optional<BehavioredClass> search = allXtdCls.stream().filter(xtd -> xtd.getName().equals(op.getEContainingClass().getName())).findFirst();
                            BehavioredClass xtdCls = null;
                            if (search.isPresent()) {
                                xtdCls = search.get();
                                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)xtdCls);
                                Optional<Operation> opSearch = xtdCls.getOperations().stream().filter(o -> o.getName().equals(opName)).findFirst();
                                if (!opSearch.isPresent()) {
                                    int endOffset = node.getEndOffset();
                                    document.replace(endOffset - 1, 0, template);
                                    int bodyOffset = endOffset + returnType.length() + opName.length() + parameters.length() + 16;
                                    xEditor.selectAndReveal(bodyOffset, content.length());
                                }
                            } else {
                                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)root);
                                int endOffset = node.getEndOffset();
                                String newXtdClass = "\n\nopen class " + op.getEContainingClass().getName() + " {\n" + template + "}";
                                document.replace(endOffset, 0, newXtdClass);
                                int templateOffset = endOffset + op.getEContainingClass().getName().length() + 16;
                                int bodyOffset = templateOffset + returnType.length() + opName.length() + parameters.length() + 17;
                                xEditor.selectAndReveal(bodyOffset, content.length());
                            }
                        }
                    }
                });
                editor.doSave((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (PartInitException e) {
            EcoreToolsDesignPlugin.INSTANCE.log((Object)e);
        }
        return op;
    }

    public EObject addMethod(EObject obj) {
        String keyword;
        String className;
        if (obj instanceof EClass) {
            className = ((EClass)obj).getName();
            keyword = "open class";
        } else if (obj instanceof RuntimeClass) {
            className = ((RuntimeClass)obj).getName();
            keyword = "class";
        } else {
            return obj;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IFile file = Services.getImplemFile(className, obj.eResource());
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        try {
            IEditorPart oldEditor = page.getActiveEditor();
            IEditorPart editor = page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
            if (!this.hasXtextFocus(file.getProject())) {
                page.activate((IWorkbenchPart)oldEditor);
            }
            if (editor instanceof XtextEditor) {
                final XtextEditor xEditor = (XtextEditor)editor;
                final IXtextDocument document = xEditor.getDocument();
                document.modify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                    public void process(XtextResource state) throws Exception {
                        if (!state.getContents().isEmpty()) {
                            Unit root = (Unit)state.getContents().get(0);
                            String returnType = "int";
                            String parameters = "()";
                            String opName = "newMethod";
                            String template = "\tdef " + returnType + " " + opName + " " + parameters + " {\n\t\t/* Write your code here */\n\t\tresult := 0;\n\t}\n";
                            EList allXtdCls = root.getXtendedClasses();
                            Optional<BehavioredClass> search = allXtdCls.stream().filter(xtd -> xtd.getName().equals(className)).findFirst();
                            BehavioredClass xtdCls = null;
                            if (search.isPresent()) {
                                xtdCls = search.get();
                                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)xtdCls);
                                Optional<Operation> opSearch = xtdCls.getOperations().stream().filter(o -> o.getName().equals(opName)).findFirst();
                                if (!opSearch.isPresent()) {
                                    int endOffset = node.getEndOffset();
                                    document.replace(endOffset - 1, 0, template);
                                    int nameOffest = endOffset + returnType.length() + 5;
                                    xEditor.selectAndReveal(nameOffest, opName.length());
                                } else {
                                    int i = 2;
                                    while (i <= xtdCls.getOperations().size() + 1) {
                                        String suffixedOpName = String.valueOf(opName) + i;
                                        opSearch = xtdCls.getOperations().stream().filter(o -> o.getName().equals(suffixedOpName)).findFirst();
                                        if (!opSearch.isPresent()) {
                                            template = "\tdef " + returnType + " " + suffixedOpName + " " + parameters + " {\n\t\t/* Write your code here */\n\t\tresult := 0;\n\t}\n";
                                            int endOffset = node.getEndOffset();
                                            document.replace(endOffset - 1, 0, template);
                                            int nameOffest = endOffset + returnType.length() + 5;
                                            xEditor.selectAndReveal(nameOffest, suffixedOpName.length());
                                            break;
                                        }
                                        ++i;
                                    }
                                }
                            } else {
                                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)root);
                                int endOffset = node.getEndOffset();
                                String newXtdClass = "\n\n" + keyword + " " + className + " {\n" + template + "}";
                                document.replace(endOffset, 0, newXtdClass);
                                int nameOffest = endOffset + keyword.length() + className.length() + returnType.length() + 12;
                                xEditor.selectAndReveal(nameOffest, opName.length());
                            }
                        }
                    }
                });
            }
            editor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        catch (PartInitException e) {
            EcoreToolsDesignPlugin.INSTANCE.log((Object)e);
        }
        return obj;
    }

    public EObject addDynamicFeature(EObject obj) {
        return this.addDynamicFeature(obj, "newFeature", "int");
    }

    public EObject addDynamicFeature(EObject obj, final String featureName, final String typeName) {
        String keyword;
        String className;
        if (obj instanceof EClass) {
            className = ((EClass)obj).getName();
            keyword = "open class";
        } else if (obj instanceof RuntimeClass) {
            className = ((RuntimeClass)obj).getName();
            keyword = "class";
        } else {
            return obj;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IFile file = Services.getImplemFile(className, obj.eResource());
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        try {
            IEditorPart oldEditor = page.getActiveEditor();
            IEditorPart editor = page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
            if (!this.hasXtextFocus(file.getProject())) {
                page.activate((IWorkbenchPart)oldEditor);
            }
            if (editor instanceof XtextEditor) {
                final XtextEditor xEditor = (XtextEditor)editor;
                final IXtextDocument document = xEditor.getDocument();
                document.modify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                    public void process(XtextResource state) throws Exception {
                        if (!state.getContents().isEmpty()) {
                            Unit root = (Unit)state.getContents().get(0);
                            String template = "\n\t" + typeName + " " + featureName + ";\n";
                            EList allXtdCls = root.getXtendedClasses();
                            Optional<BehavioredClass> search = allXtdCls.stream().filter(xtd -> xtd.getName().equals(className)).findFirst();
                            BehavioredClass xtdCls = null;
                            if (search.isPresent()) {
                                xtdCls = search.get();
                                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)xtdCls);
                                Optional<Attribute> attrSearch = xtdCls.getAttributes().stream().filter(a -> a.getName().equals(featureName)).findFirst();
                                if (!attrSearch.isPresent()) {
                                    int endOffset = node.getEndOffset();
                                    Iterable leafs = node.getLeafNodes();
                                    ArrayList l = new ArrayList();
                                    leafs.forEach(e -> {
                                        boolean bl = l.add(e);
                                    });
                                    Optional<ILeafNode> openBraceSearch = l.stream().filter(n -> n instanceof LeafNode && ((LeafNode)n).getGrammarElement() instanceof Keyword && ((Keyword)((LeafNode)n).getGrammarElement()).getValue().equals("{")).findFirst();
                                    if (openBraceSearch.isPresent()) {
                                        endOffset = openBraceSearch.get().getEndOffset() + 1;
                                    }
                                    document.replace(endOffset - 1, 0, template);
                                    int nameOffest = endOffset + typeName.length() + 2;
                                    xEditor.selectAndReveal(nameOffest, featureName.length());
                                } else {
                                    int i = 2;
                                    while (i <= xtdCls.getAttributes().size() + 1) {
                                        String suffixedFeatureName = String.valueOf(featureName) + i;
                                        attrSearch = xtdCls.getAttributes().stream().filter(a -> a.getName().equals(suffixedFeatureName)).findFirst();
                                        if (!attrSearch.isPresent()) {
                                            int endOffset = node.getEndOffset();
                                            Iterable leafs = node.getLeafNodes();
                                            ArrayList l = new ArrayList();
                                            leafs.forEach(e -> {
                                                boolean bl = l.add(e);
                                            });
                                            Optional<ILeafNode> openBraceSearch = l.stream().filter(n -> n instanceof LeafNode && ((LeafNode)n).getGrammarElement() instanceof Keyword && ((Keyword)((LeafNode)n).getGrammarElement()).getValue().equals("{")).findFirst();
                                            if (openBraceSearch.isPresent()) {
                                                endOffset = openBraceSearch.get().getEndOffset() + 1;
                                            }
                                            template = "\n\t" + typeName + " " + suffixedFeatureName + ";\n";
                                            document.replace(endOffset - 1, 0, template);
                                            int nameOffest = endOffset + typeName.length() + 2;
                                            xEditor.selectAndReveal(nameOffest, suffixedFeatureName.length());
                                            break;
                                        }
                                        ++i;
                                    }
                                }
                            } else {
                                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)root);
                                int endOffset = node.getEndOffset();
                                String newXtdClass = "\n\n" + keyword + " " + className + " {\n" + template + "}";
                                document.replace(endOffset, 0, newXtdClass);
                                int nameOffest = endOffset + keyword.length() + className.length() + typeName.length() + 9;
                                xEditor.selectAndReveal(nameOffest, featureName.length());
                            }
                        }
                    }
                });
                editor.doSave((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (PartInitException e) {
            EcoreToolsDesignPlugin.INSTANCE.log((Object)e);
        }
        return obj;
    }

    public void createRuntimeClass(EObject obj) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IFile file = Services.getImplemFile("", obj.eResource());
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        try {
            IEditorPart oldEditor = page.getActiveEditor();
            IEditorPart editor = page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
            if (!this.hasXtextFocus(file.getProject())) {
                page.activate((IWorkbenchPart)oldEditor);
            }
            if (editor instanceof XtextEditor) {
                final XtextEditor xEditor = (XtextEditor)editor;
                final IXtextDocument document = xEditor.getDocument();
                document.modify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                    public void process(XtextResource state) throws Exception {
                        if (!state.getContents().isEmpty()) {
                            Unit root = (Unit)state.getContents().get(0);
                            String newClassName = "NewRuntimeClass";
                            String template = "\n\t/* Write your code here */\n";
                            String newClass = "\n\nclass " + newClassName + " {\n" + template + "}";
                            EList allXtdCls = root.getXtendedClasses();
                            Optional<BehavioredClass> search = allXtdCls.stream().filter(xtd -> xtd.getName().equals(newClassName)).findFirst();
                            if (!search.isPresent()) {
                                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)root);
                                int endOffset = node.getEndOffset();
                                document.replace(endOffset, 0, newClass);
                                int templateOffset = endOffset + newClassName.length() + 13;
                                int nameOffest = endOffset + 8;
                                xEditor.selectAndReveal(nameOffest, newClassName.length());
                            } else {
                                int i = 2;
                                while (i <= allXtdCls.size() + 1) {
                                    String suffixedClassName = String.valueOf(newClassName) + i;
                                    search = allXtdCls.stream().filter(xtd -> xtd.getName().equals(suffixedClassName)).findFirst();
                                    if (!search.isPresent()) {
                                        newClass = "\n\nclass " + suffixedClassName + " {\n" + template + "}";
                                        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)root);
                                        int endOffset = node.getEndOffset();
                                        document.replace(endOffset, 0, newClass);
                                        int templateOffset = endOffset + newClassName.length() + 13;
                                        int nameOffest = endOffset + 8;
                                        xEditor.selectAndReveal(nameOffest, suffixedClassName.length());
                                        break;
                                    }
                                    ++i;
                                }
                            }
                        }
                    }
                });
            }
            editor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        catch (PartInitException e) {
            EcoreToolsDesignPlugin.INSTANCE.log((Object)e);
        }
    }

    private static IFile getImplemFile(String className, Resource ecoreResource) {
        URI uri = ecoreResource.getURI();
        Path path = new Path(uri.toPlatformString(false));
        IProject enclosingProject = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path).getProject();
        WithAbsoluteBehaviorPathsAleEnvironment env = new WithAbsoluteBehaviorPathsAleEnvironment(IAleProject.from((IProject)enclosingProject).getEnvironment());
        Pattern openClass = Pattern.compile(".*open\\s+class\\s+" + className + ".*");
        for (String behavior : env.getBehaviorsSources()) {
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (Stream<String> lines = Files.lines(Paths.get(behavior, new String[0]));){
                    boolean definesClass = lines.anyMatch(line -> openClass.matcher((CharSequence)line).matches());
                    if (!definesClass) continue;
                    return FileBuffers.getWorkspaceFileAtLocation((IPath)Path.fromOSString((String)new File(behavior).getPath()));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public EObject getSource(org.eclipse.emf.ecoretools.ale.implementation.Attribute attrib) {
        EObject container = attrib.eContainer();
        if (container instanceof ExtendedClass) {
            return ((ExtendedClass)container).getBaseClass();
        }
        if (container instanceof RuntimeClass) {
            return container;
        }
        return null;
    }

    public EObject getTarget(org.eclipse.emf.ecoretools.ale.implementation.Attribute attrib) {
        List modelUnits;
        Optional<RuntimeClass> searchCls;
        EClassifier type = attrib.getFeatureRef().getEType();
        if (type.eResource() == null && (searchCls = (modelUnits = attrib.eResource().getContents().stream().filter(elem -> elem instanceof ModelUnit).map(elm -> (ModelUnit)elm).collect(Collectors.toList())).stream().flatMap(u -> u.getClassDefinitions().stream()).filter(cls -> cls.getName().equals(type.getName())).findFirst()).isPresent()) {
            return (EObject)searchCls.get();
        }
        return type;
    }

    public boolean isContainment(org.eclipse.emf.ecoretools.ale.implementation.Attribute attrib) {
        EStructuralFeature feature = attrib.getFeatureRef();
        if (feature instanceof EReference) {
            return ((EReference)feature).isContainment();
        }
        return false;
    }

    private boolean hasXtextFocus(IProject project) {
        AlePreferenceStore store = new AlePreferenceStore((IScopeContext)new ProjectScope(project), "org.eclipse.emf.ecoretools.ale.ide.ui");
        return store.getBoolean("xtextFocus");
    }
}

