/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.ui.launchconfig;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.ide.ui.Activator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

abstract class AbstractAleLaunchShortcut
implements ILaunchShortcut {
    AbstractAleLaunchShortcut() {
    }

    protected abstract void prepareLaunchOn(IResource var1) throws Exception;

    protected abstract Optional<IResource> getModel();

    protected abstract String getBaseConfigurationName();

    protected abstract IAleEnvironment getEnvironment();

    public void launch(ISelection selection, String mode) {
        try {
            IResource resource = AbstractAleLaunchShortcut.toResource(selection);
            this.prepareLaunchOn(resource);
            if (!this.getModel().isPresent()) {
                return;
            }
            ILaunchConfiguration configuration = AbstractAleLaunchShortcut.createLaunchConfiguration(this.getBaseConfigurationName(), this.getEnvironment(), this.getModel().get());
            configuration.launch("run", null);
        }
        catch (Exception e) {
            Activator.error("An error occurred while launching ALE", e);
        }
    }

    public void launch(IEditorPart editor, String mode) {
    }

    private static ILaunchConfiguration createLaunchConfiguration(String baseConfigurationName, IAleEnvironment conf, IResource model) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.emf.ecoretools.ale.ide.ui.launchConfigurationType");
        ILaunchConfiguration[] configurations = manager.getLaunchConfigurations(type);
        String launchConfigurationName = AbstractAleLaunchShortcut.availableLaunchConfigurationName(baseConfigurationName, configurations);
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, launchConfigurationName);
        workingCopy.setAttribute("METAMODELS_PATH", String.join((CharSequence)",", conf.getMetamodelsSources()));
        workingCopy.setAttribute("BEHAVIORS_PATH", String.join((CharSequence)",", conf.getBehaviorsSources()));
        workingCopy.setAttribute("MODEL_FILE", model.getFullPath().toPortableString());
        return workingCopy.doSave();
    }

    private static String availableLaunchConfigurationName(String baseConfigurationName, ILaunchConfiguration[] configurations) {
        String launchConfigurationName = baseConfigurationName;
        int index = 0;
        while (AbstractAleLaunchShortcut.configurationExists(configurations, launchConfigurationName)) {
            launchConfigurationName = String.valueOf(baseConfigurationName) + " (" + ++index + ")";
            AbstractAleLaunchShortcut.preventInfiniteLoop(index);
        }
        return launchConfigurationName;
    }

    private static boolean configurationExists(ILaunchConfiguration[] configurations, String name) {
        ILaunchConfiguration[] iLaunchConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
            if (launchConfiguration.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void preventInfiniteLoop(int loopIndex) {
        boolean overflowed;
        boolean bl = overflowed = loopIndex < 0;
        if (overflowed) {
            throw new IndexOutOfBoundsException("Unable to create a new configuration: there are already 2147483647 of them");
        }
    }

    private static IResource toResource(ISelection selection) {
        Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
        try {
            if (selectedElement instanceof IJavaProject) {
                IJavaProject javaProject = (IJavaProject)selectedElement;
                return javaProject.getCorrespondingResource();
            }
        }
        catch (NoClassDefFoundError javaProject) {
        }
        catch (JavaModelException e) {
            throw new RuntimeException("Unable to get the IResource corresponding to the Java project", e);
        }
        return (IResource)selectedElement;
    }

    protected static Optional<IResource> askUserToSelectAnXmiModel(IResource dslFile) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(shell, false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
        dialog.setTitle("Select the model to execute");
        dialog.setInitialPattern("*.xmi");
        Optional<IResource> siblingXmi = AbstractAleLaunchShortcut.findSiblingXmi(dslFile);
        siblingXmi.ifPresent(iResource -> dialog.setInitialSelections(new Object[]{iResource}));
        dialog.open();
        Object[] selected = dialog.getResult();
        if (selected != null && selected.length == 1 && selected[0] instanceof IResource) {
            return Optional.of((IResource)selected[0]);
        }
        return Optional.empty();
    }

    private static Optional<IResource> findSiblingXmi(IResource dslFile) {
        Stream<IResource> siblings;
        try {
            siblings = Arrays.stream(dslFile.getParent().members());
        }
        catch (NullPointerException | CoreException e) {
            return Optional.empty();
        }
        return siblings.filter(AbstractAleLaunchShortcut.isXMI()).findAny();
    }

    private static Predicate<? super IResource> isXMI() {
        return sibling -> "xmi".equalsIgnoreCase(sibling.getFileExtension());
    }
}

