/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.clocktree.generator;

import fr.inria.aoste.timesquare.ccslkernel.clocktree.generator.ClockTreeConstructor;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.IntegerElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.PrimitiveElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.SequenceElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntegerVariableRef;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Concatenation;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Defer;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Inf;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Intersection;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.NonStrictSampling;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.StrictSampling;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Sup;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Union;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.UpTo;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Wait;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.util.KernelExpressionSwitch;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiatedElement;

public class KernelExpressionClockTreeBuilder
extends KernelExpressionSwitch<Boolean> {
    private InstantiatedElement concrete;
    private ClockTreeConstructor builder;

    public KernelExpressionClockTreeBuilder(InstantiatedElement concrete, ClockTreeConstructor c) {
        this.concrete = concrete;
        this.builder = c;
    }

    public Boolean caseConcatenation(Concatenation object) {
        boolean isCond = false;
        try {
            isCond = this.concrete.getParent().isConditional();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        InstantiatedElement left = this.concrete.resolveAbstractEntity(object.getLeftClock());
        InstantiatedElement right = this.concrete.resolveAbstractEntity(object.getRightClock());
        this.builder.addConcat(left, right, this.concrete, isCond);
        return true;
    }

    public Boolean caseDefer(Defer object) {
        InstantiatedElement intelem;
        int tmp;
        boolean isCond = false;
        try {
            isCond = this.concrete.getParent().isConditional();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        InstantiatedElement base = this.concrete.resolveAbstractEntity(object.getBaseClock());
        InstantiatedElement delayClock = this.concrete.resolveAbstractEntity(object.getDelayClock());
        InstantiatedElement ie = this.concrete.resolveAbstractEntity(object.getDelayPattern());
        SequenceElement pattern = (SequenceElement)ie.getValue();
        String patternString = "";
        for (PrimitiveElement elt : pattern.getFinitePart()) {
            tmp = -1;
            if (elt instanceof IntegerElement) {
                tmp = ((IntegerElement)elt).getValue();
            } else {
                intelem = this.concrete.resolveAbstractEntity(((IntegerVariableRef)elt).getReferencedVar());
                tmp = ((IntegerElement)intelem.getValue()).getValue();
            }
            patternString = String.valueOf(patternString) + "[" + tmp + ";" + tmp + "],";
        }
        patternString = String.valueOf(patternString) + "(";
        for (PrimitiveElement elt : pattern.getNonFinitePart()) {
            tmp = -1;
            if (elt instanceof IntegerElement) {
                tmp = ((IntegerElement)elt).getValue();
            } else {
                intelem = this.concrete.resolveAbstractEntity(((IntegerVariableRef)elt).getReferencedVar());
                tmp = 0;
            }
            patternString = String.valueOf(patternString) + "[" + tmp + ";" + tmp + "],";
        }
        String k_affine = patternString = String.valueOf(patternString) + ")w";
        this.builder.addSubClockConstrained(delayClock, k_affine, this.concrete, isCond);
        this.builder.addPrecedence(base, this.concrete, isCond);
        return true;
    }

    public Boolean caseInf(Inf object) {
        boolean isCond = false;
        try {
            isCond = this.concrete.getParent().isConditional();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        InstantiatedElement c1 = this.concrete.resolveAbstractEntity(object.getClock1());
        InstantiatedElement c2 = this.concrete.resolveAbstractEntity(object.getClock2());
        this.builder.addInfRelation(c1, c2, this.concrete, isCond);
        return true;
    }

    public Boolean caseIntersection(Intersection object) {
        boolean isCond = false;
        try {
            isCond = this.concrete.getParent().isConditional();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        InstantiatedElement c1 = this.concrete.resolveAbstractEntity(object.getClock1());
        InstantiatedElement c2 = this.concrete.resolveAbstractEntity(object.getClock2());
        this.builder.addSubClockFree(c1, this.concrete, isCond);
        this.builder.addSubClockFree(c2, this.concrete, isCond);
        return true;
    }

    public Boolean caseNonStrictSampling(NonStrictSampling object) {
        boolean isCond = false;
        try {
            isCond = this.concrete.getParent().isConditional();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        InstantiatedElement samplingClock = this.concrete.resolveAbstractEntity(object.getSamplingClock());
        InstantiatedElement sampledClock = this.concrete.resolveAbstractEntity(object.getSampledClock());
        this.builder.addNonStrictSampledOnExpression(samplingClock, sampledClock, this.concrete, isCond);
        return true;
    }

    public Boolean caseStrictSampling(StrictSampling object) {
        boolean isCond = false;
        try {
            isCond = this.concrete.getParent().isConditional();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        InstantiatedElement samplingClock = this.concrete.resolveAbstractEntity(object.getSamplingClock());
        InstantiatedElement sampledClock = this.concrete.resolveAbstractEntity(object.getSampledClock());
        this.builder.addSampledOnExpression(samplingClock, sampledClock, this.concrete, isCond);
        return true;
    }

    public Boolean caseSup(Sup object) {
        boolean isCond = false;
        try {
            isCond = this.concrete.getParent().isConditional();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        InstantiatedElement c1 = this.concrete.resolveAbstractEntity(object.getClock1());
        InstantiatedElement c2 = this.concrete.resolveAbstractEntity(object.getClock2());
        this.builder.addSupRelation(c1, c2, this.concrete, isCond);
        return true;
    }

    public Boolean caseUnion(Union object) {
        boolean isCond = false;
        try {
            isCond = this.concrete.getParent() == null || this.concrete.getParent().isConditional();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        InstantiatedElement c1 = this.concrete.resolveAbstractEntity(object.getClock1());
        InstantiatedElement c2 = this.concrete.resolveAbstractEntity(object.getClock2());
        this.builder.addSubClockFree(this.concrete, c1, isCond);
        this.builder.addSubClockFree(this.concrete, c2, isCond);
        return true;
    }

    public Boolean caseUpTo(UpTo object) {
        boolean isCond = false;
        try {
            isCond = this.concrete.getParent().isConditional();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        InstantiatedElement toFollow = this.concrete.resolveAbstractEntity(object.getClockToFollow());
        InstantiatedElement killer = this.concrete.resolveAbstractEntity(object.getKillerClock());
        String k_affine = "([1;1])w";
        this.builder.addSubClockConstrained(toFollow, k_affine, this.concrete, isCond);
        this.builder.addKiller(killer, this.concrete, isCond);
        return true;
    }

    public Boolean caseWait(Wait object) {
        boolean isCond = false;
        try {
            isCond = this.concrete.getParent().isConditional();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        InstantiatedElement waitingClock = this.concrete.resolveAbstractEntity(object.getWaitingClock());
        InstantiatedElement ie = this.concrete.resolveAbstractEntity(object.getWaitingValue());
        IntegerElement v = (IntegerElement)ie.getValue();
        Integer waitValue = 0;
        if (v != null) {
            waitValue = v.getValue();
        }
        ie = this.concrete.resolveAbstractEntity(object.getWaitingClock());
        String waitingClockName = ie.getQualifiedName();
        String k_affine = "[" + waitValue + ";" + waitValue + "]";
        this.builder.addSubClockConstrained(waitingClock, k_affine, this.concrete, isCond);
        return true;
    }
}

