/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.jdt.autosrcfolder;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class AutoSrcFolderCreator {
    public static final String PLUGINID = "org.eclipse.gemoc.commons.eclipse.jdt.autosrcfolder";
    public static final String ENABLE_KEY = "org.eclipse.gemoc.commons.eclipse.jdt.autosrcfolder_enable";
    public static final IPreferenceStore preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.gemoc.commons.eclipse.jdt.autosrcfolder");
    private static final String JOBMESSAGE = "Creating missing source folders.";
    private static final String ERRORMESSAGE = "An error occured while trying to create missing source folders:\n\n";
    private IResourceChangeListener listener;

    public void start() {
        preferenceStore.setDefault(ENABLE_KEY, true);
        preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(AutoSrcFolderCreator.ENABLE_KEY)) {
                    if (((Boolean)event.getNewValue()).booleanValue()) {
                        AutoSrcFolderCreator.this.realStart();
                    } else {
                        AutoSrcFolderCreator.this.stop();
                    }
                }
            }
        });
        if (AutoSrcFolderCreator.isEnabled()) {
            this.realStart();
        }
    }

    private static boolean isEnabled() {
        return preferenceStore.getBoolean(ENABLE_KEY);
    }

    private void realStart() {
        if (this.listener == null) {
            Job j = new Job(JOBMESSAGE){

                protected IStatus run(IProgressMonitor monitor) {
                    IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    int n = iProjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject p = iProjectArray[n2];
                        if (p.isOpen()) {
                            try {
                                IMarker[] iMarkerArray = p.findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 0);
                                int n3 = iMarkerArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IMarker m = iMarkerArray[n4];
                                    AutoSrcFolderCreator.handleMarker(m, monitor);
                                    ++n4;
                                }
                            }
                            catch (CoreException e) {
                                return AutoSrcFolderCreator.this.createError(e);
                            }
                        }
                        ++n2;
                    }
                    return Status.OK_STATUS;
                }
            };
            j.schedule();
            this.listener = new IResourceChangeListener(){

                public void resourceChanged(final IResourceChangeEvent event) {
                    Job j = new Job(AutoSrcFolderCreator.JOBMESSAGE){

                        protected IStatus run(IProgressMonitor monitor) {
                            IMarkerDelta[] markers;
                            IMarkerDelta[] iMarkerDeltaArray = markers = event.findMarkerDeltas("org.eclipse.jdt.core.buildpath_problem", false);
                            int n = markers.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IMarkerDelta m = iMarkerDeltaArray[n2];
                                try {
                                    AutoSrcFolderCreator.handleMarkerDelta(m, monitor);
                                }
                                catch (CoreException e) {
                                    return AutoSrcFolderCreator.this.createError(e);
                                }
                                ++n2;
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    j.schedule();
                }
            };
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener);
        }
    }

    private IStatus createError(Throwable t) {
        t.printStackTrace();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return new Status(4, PLUGINID, ERRORMESSAGE + sw.toString());
    }

    private void stop() {
        if (this.listener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
            this.listener = null;
        }
    }

    private static void handleMarkerDelta(IMarkerDelta marker, IProgressMonitor monitor) throws CoreException {
        if (marker.getKind() != 2 && (Integer)marker.getAttribute("id") == 964) {
            String message = (String)marker.getAttribute("message");
            AutoSrcFolderCreator.handleMessage((IProject)marker.getResource(), message, monitor);
        }
    }

    private static void handleMarker(IMarker marker, IProgressMonitor monitor) throws CoreException {
        if ((Integer)marker.getAttribute("id") == 964) {
            String message = (String)marker.getAttribute("message");
            AutoSrcFolderCreator.handleMessage((IProject)marker.getResource(), message, monitor);
        }
    }

    private static void handleMessage(IProject project, String message, IProgressMonitor monitor) throws CoreException {
        String srcFolderName;
        IFolder srcFolder;
        String expectedErrorMessage = MessageFormat.format(Messages.classpath_unboundSourceFolder, "UNKNOWN", project.getName());
        String expectedErrorMessageFirstPart = expectedErrorMessage.split(":")[0];
        if (message.startsWith(expectedErrorMessageFirstPart) && !(srcFolder = project.getFolder(srcFolderName = AutoSrcFolderCreator.findSrcFolderName(message))).exists()) {
            try {
                project.getFolder(srcFolderName).create(true, true, monitor);
            }
            catch (CoreException coreException) {}
        }
    }

    private static String findSrcFolderName(String message) {
        boolean found = false;
        int index = message.length() - 1;
        while (!found) {
            if (message.charAt(--index) != '\'') continue;
            found = true;
        }
        String srcFolderName = message.substring(index + 1, message.length() - 1);
        return srcFolderName;
    }
}

