/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.graph;

import fr.kairos.timesquare.ccsl.graph.IGraph;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public class DotGraph
implements IGraph {
    private StringBuilder edges = new StringBuilder();
    private Set<String> clocks = new HashSet<String>();

    private void addStyle(String type, StringBuilder sb) {
        switch (type) {
            case "delayed": {
                sb.append("[\"style\"=\"dashed\"]");
                break;
            }
            case "subclock": {
                sb.append("[\"color\"=\"blue\", \"arrowhead\"=\"onormal\"]");
                break;
            }
            case "counter": {
                sb.append("[\"color\"=\"red\", \"dir\"=\"both\", \"arrowtail\"=\"dot\", \"arrowhead\"=\"dot\"]");
            }
        }
    }

    @Override
    public void addEdge(String tail, String head, Object ... param) {
        this.edges.append(tail).append(" -> ").append(head);
        if (param != null && param.length > 0 && param[0] != null) {
            this.addStyle(param[0].toString(), this.edges);
        }
        this.edges.append("\n");
    }

    public void toDotFile(Writer w) {
        PrintWriter pw = new PrintWriter(w);
        pw.println("digraph {");
        for (String c : this.clocks) {
            pw.println("  \"" + c + "\";");
        }
        pw.println(this.edges);
        pw.println("}");
    }

    @Override
    public void addNode(String name) {
        this.clocks.add(name);
    }
}

