/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.kairos.timesquare.grph.viewer;

import fr.inria.kairos.timesquare.grph.viewer.GrphWebEngine;
import java.util.ArrayList;
import javafx.scene.web.WebEngine;

public class GrphView {
    public GrphWebEngine internalView = new GrphWebEngine();
    public WebEngine engine;

    public GrphView() {
        this.engine = this.internalView.webEngine;
    }

    public String getSource(String edge) {
        return (String)this.engine.executeScript("cy.edges('#" + edge + "').source().id()");
    }

    public String getTarget(String edge) {
        return (String)this.engine.executeScript("cy.edges('#" + edge + "').target().id()");
    }

    public void addNode(String id, int index) {
        String command = "cy.add({group: \"nodes\",data:";
        command = String.valueOf(command) + "{id: \"" + id + "\",index: " + index + "}});";
        this.engine.executeScript(command);
    }

    public void addEdge(String id, String label, String source, String target, boolean directed, int index) {
        String command = "cy.add({group: 'edges',data:{";
        command = String.valueOf(command) + "id:'" + id + "',";
        command = String.valueOf(command) + "label:'" + label + "',";
        command = String.valueOf(command) + "source:'" + source + "',";
        command = String.valueOf(command) + "target:'" + target + "',";
        command = String.valueOf(command) + "index:" + index + "}";
        command = String.valueOf(command) + ",classes: 'directed" + directed + "'})";
        this.engine.executeScript(command);
    }

    public int searchIndex(String string) {
        int temp = (Integer)this.engine.executeScript("searcheIndex('" + string + "')");
        return temp;
    }

    public String searchName(int index) {
        String temp = (String)this.engine.executeScript("searcheName(" + index + ")");
        return temp;
    }

    public void layout(String layout) {
        this.engine.executeScript("var layout = cy.layout({name: '" + layout + "'})");
        this.engine.executeScript("layout.run()");
    }

    public int layoutRun() {
        Object temp = this.engine.executeScript("runLayout()");
        System.out.println(temp);
        return (Integer)temp;
    }

    public void setLayout(String layout) {
        this.engine.executeScript("layout = cy.layout({name: '" + layout + "'})");
    }

    public void remove(String name) {
        this.engine.executeScript("cy.remove('#" + name + "')");
    }

    public boolean isNode(String node) {
        return (Boolean)this.engine.executeScript("cy.elements('#" + node + "').isNode()");
    }

    public void removeAll(String clas) {
        this.engine.executeScript("cy.elements().removeClass('" + clas + "')");
    }

    public void clearAll() {
        this.engine.executeScript("cy.elements().remove()");
    }

    public void removeClass(String name, String clas) {
        this.engine.executeScript("cy.elements('#" + name + "').removeClass('" + clas + "')");
    }

    public void selectElements(ArrayList<String> names) {
        String toExec = "";
        for (String n : names) {
            toExec = String.valueOf(toExec) + "cy.getElementById('" + n + "').select()\n";
        }
        this.engine.executeScript(toExec);
    }

    public void unSelectElements(ArrayList<String> names) {
        String toExec = "";
        for (String n : names) {
            toExec = String.valueOf(toExec) + "cy.getElementById('" + n + "').unselect()\n";
        }
        this.engine.executeScript(toExec);
    }

    public void addClass(String element, String clas) {
        this.engine.executeScript("cy.elements('#" + element + "').addClass(\"" + clas + "\");");
    }

    public void unselectAll() {
        this.engine.executeScript("cy.$(':selected').unselect();");
    }
}

