/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.serialization.plugin;

import fr.inria.aoste.timesquare.backend.manager.serialization.OptionsSerializer;
import fr.inria.aoste.timesquare.backend.manager.serialization.SpecialObjectInputStream;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManager;
import fr.inria.aoste.timesquare.backend.manager.visible.PersistentOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

public class PluginOptionsSerializer
extends OptionsSerializer {
    private Map<String, PersistentOptions> _data = new HashMap<String, PersistentOptions>();

    public Map<String, PersistentOptions> getData() {
        return this._data;
    }

    public void addPluginOptions(String pluginName, PersistentOptions persistentOptions) {
        this._data.put(pluginName, persistentOptions);
    }

    @Override
    public boolean doesPluginNeedSerialization(String pluginName) {
        return this._data.containsKey(pluginName);
    }

    @Override
    public String getSerializedOptions(String pluginName) {
        PersistentOptions po = this._data.get(pluginName);
        if (po == null) {
            return "";
        }
        String result = "";
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(po);
                oos.flush();
            }
            finally {
                try {
                    oos.close();
                }
                finally {
                    result = this.transformByteInString(baos.toByteArray());
                    baos.close();
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result;
    }

    @Override
    public void deserializeOptions(String options, BehaviorManager behaviorManager) {
        if (options == null || options.length() == 0 || behaviorManager == null) {
            return;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.transformStringInByte(options));
            SpecialObjectInputStream sois = new SpecialObjectInputStream(bais, behaviorManager.getClass().getClassLoader());
            try {
                PersistentOptions readObject = (PersistentOptions)sois.readObject();
                this.addPluginOptions(behaviorManager.getPluginName(), readObject);
            }
            finally {
                try {
                    sois.close();
                }
                finally {
                    bais.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

