/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.preferences;

import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AcceleoNotificationsPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button forcedDisableNotificationButton;
    private Button errorNotificationEnableButton;
    private Button warningNotificationEnableButton;
    private Button okNotificationEnableButton;
    private Button successNotificationEnableButton;
    private Button infoNotificationEnableButton;
    private Button cancelNotificationEnableButton;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.forcedDisableNotificationButton = new Button(composite, 32);
        this.forcedDisableNotificationButton.setText(AcceleoUIMessages.getString("AcceleoNotificationsPreferences.ForceDisableButton"));
        this.forcedDisableNotificationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AcceleoNotificationsPreferences.this.updateForceDisable();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AcceleoNotificationsPreferences.this.updateForceDisable();
            }
        });
        this.errorNotificationEnableButton = new Button(composite, 32);
        this.errorNotificationEnableButton.setText(AcceleoUIMessages.getString("AcceleoNotificationsPreferences.ErrorNotificationsButton"));
        this.warningNotificationEnableButton = new Button(composite, 32);
        this.warningNotificationEnableButton.setText(AcceleoUIMessages.getString("AcceleoNotificationsPreferences.WarningNotificationsButton"));
        this.okNotificationEnableButton = new Button(composite, 32);
        this.okNotificationEnableButton.setText(AcceleoUIMessages.getString("AcceleoNotificationsPreferences.OKNotificationsButton"));
        this.successNotificationEnableButton = new Button(composite, 32);
        this.successNotificationEnableButton.setText(AcceleoUIMessages.getString("AcceleoNotificationsPreferences.SuccessNotificationsButton"));
        this.infoNotificationEnableButton = new Button(composite, 32);
        this.infoNotificationEnableButton.setText(AcceleoUIMessages.getString("AcceleoNotificationsPreferences.InfoNotificationsButton"));
        this.cancelNotificationEnableButton = new Button(composite, 32);
        this.cancelNotificationEnableButton.setText(AcceleoUIMessages.getString("AcceleoNotificationsPreferences.CancelNotificationsButton"));
        this.errorNotificationEnableButton.setSelection(AcceleoPreferences.areErrorNotificationsEnabled());
        this.warningNotificationEnableButton.setSelection(AcceleoPreferences.areWarningNotificationsEnabled());
        this.okNotificationEnableButton.setSelection(AcceleoPreferences.areOKNotificationsEnabled());
        this.successNotificationEnableButton.setSelection(AcceleoPreferences.areSuccessNotificationsEnabled());
        this.infoNotificationEnableButton.setSelection(AcceleoPreferences.areInfoNotificationsEnabled());
        this.cancelNotificationEnableButton.setSelection(AcceleoPreferences.areCancelNotificationsEnabled());
        this.forcedDisableNotificationButton.setSelection(AcceleoPreferences.areNotificationsForcedDisabled());
        this.updateForceDisable();
        return composite;
    }

    private void updateForceDisable() {
        boolean shouldDisable = !this.forcedDisableNotificationButton.getSelection();
        this.errorNotificationEnableButton.setEnabled(shouldDisable);
        this.warningNotificationEnableButton.setEnabled(shouldDisable);
        this.okNotificationEnableButton.setEnabled(shouldDisable);
        this.successNotificationEnableButton.setEnabled(shouldDisable);
        this.infoNotificationEnableButton.setEnabled(shouldDisable);
        this.cancelNotificationEnableButton.setEnabled(shouldDisable);
    }

    private void updatePreferences() {
        AcceleoPreferences.switchForceDeactivationNotifications((boolean)this.forcedDisableNotificationButton.getSelection());
        AcceleoPreferences.switchErrorNotifications((boolean)this.errorNotificationEnableButton.getSelection());
        AcceleoPreferences.switchWarningNotifications((boolean)this.warningNotificationEnableButton.getSelection());
        AcceleoPreferences.switchOKNotifications((boolean)this.okNotificationEnableButton.getSelection());
        AcceleoPreferences.switchSuccessNotifications((boolean)this.successNotificationEnableButton.getSelection());
        AcceleoPreferences.switchInfoNotifications((boolean)this.infoNotificationEnableButton.getSelection());
        AcceleoPreferences.switchCancelNotifications((boolean)this.cancelNotificationEnableButton.getSelection());
    }

    protected void performApply() {
        this.updatePreferences();
        super.performApply();
    }

    protected void performDefaults() {
        this.forcedDisableNotificationButton.setSelection(false);
        this.updateForceDisable();
        this.errorNotificationEnableButton.setSelection(true);
        this.warningNotificationEnableButton.setSelection(true);
        this.okNotificationEnableButton.setSelection(true);
        this.successNotificationEnableButton.setSelection(true);
        this.infoNotificationEnableButton.setSelection(true);
        this.cancelNotificationEnableButton.setSelection(true);
        super.performDefaults();
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public boolean performOk() {
        this.updatePreferences();
        return super.performOk();
    }
}

