/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.helpers;

import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.BDDHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.relations.AbstractRuntimeRelation;
import fr.inria.aoste.timesquare.ccslkernel.runtime.simulation.CCSLStepExecutionEngine;
import fr.inria.aoste.timesquare.ccslkernel.runtime.simulation.ClockDeathSolver;
import java.util.Collection;
import java.util.Set;
import net.sf.javabdd.BuDDyFactory;

public class SemanticHelper
extends AbstractSemanticHelper {
    private CCSLStepExecutionEngine stepEngine;

    public SemanticHelper(CCSLStepExecutionEngine stepEngine, BDDHelper bddHelper) {
        super(bddHelper);
        this.stepEngine = stepEngine;
    }

    @Override
    public BuDDyFactory.BuDDyBDD getAssertionVariable(AbstractRuntimeRelation relation) {
        return this.getBuddyFactory().ithVar(relation.getAssertionVariable());
    }

    @Override
    public void semanticBDDAnd(BuDDyFactory.BuDDyBDD buDDyBDD) {
        this.getSemanticBdd().andWith(buDDyBDD);
    }

    @Override
    public void registerAssertion(AbstractRuntimeRelation relation) {
        this.stepEngine.addAssertionVariable(relation.getAssertionVariable());
    }

    @Override
    public Set<RuntimeClock> getUsedClocks() {
        return this.stepEngine.getUsedClocks();
    }

    @Override
    public void registerClockUse(RuntimeClock clock) {
        this.getUsedClocks().add(clock);
    }

    private Set<RuntimeClock> getStartQueue() {
        return this.stepEngine.getStartQueue();
    }

    @Override
    public void registerClockToStart(RuntimeClock clock) {
        this.stepEngine.registerClockToStart(clock);
    }

    @Override
    public void unregisterClockToStart(RuntimeClock clock) {
        this.getStartQueue().remove(clock);
    }

    @Override
    public void forceDeath(RuntimeClock clock) {
        this.getClockDeathSolver().registerDeadClock(clock);
    }

    @Override
    public void registerDeathEquality(RuntimeClock clock1, RuntimeClock clock2) {
        this.getClockDeathSolver().registerEquality(clock1, clock2);
    }

    @Override
    public void registerDeathImplication(RuntimeClock clock1, RuntimeClock clock2) {
        this.getClockDeathSolver().registerImplication(clock1, clock2);
    }

    @Override
    public void registerDeathConjunctionImplies(RuntimeClock left1, RuntimeClock left2, RuntimeClock right) {
        this.getClockDeathSolver().registerConjunctionImplication(left1, left2, right);
    }

    private ClockDeathSolver getClockDeathSolver() {
        return this.stepEngine.getDeathSolver();
    }

    private Set<RuntimeClock> getDeadClocks() {
        return this.stepEngine.getDeadClocks();
    }

    public void setDeadClocks(Collection<? extends RuntimeClock> deadClocks) {
        this.getDeadClocks().addAll(deadClocks);
    }

    @Override
    public void registerDeadClock(RuntimeClock clock) {
        this.getDeadClocks().add(clock);
    }

    @Override
    public void unregisterDeadClock(RuntimeClock clock) {
        this.getDeadClocks().remove(clock);
    }

    @Override
    public boolean isSemanticDone(ICCSLConstraint ct) {
        return false;
    }

    @Override
    public void registerSemanticDone(ICCSLConstraint ct) {
    }

    @Override
    public AbstractUpdateHelper getUpdateHelper() {
        return null;
    }

    private BuDDyFactory.BuDDyBDD getSemanticBdd() {
        return this.stepEngine.getSemanticBdd();
    }
}

