/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.expressions;

import fr.inria.aoste.timesquare.ccslkernel.runtime.AbstractConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.SerializedConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.runtime.ValueProvider;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeSequence;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.AbstractRuntimeExpression;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import java.util.ArrayList;

public class RuntimeDefer
extends AbstractRuntimeExpression {
    private RuntimeClock baseClock;
    private RuntimeClock delayClock;
    private RuntimeSequence<? extends Integer> sigma;
    private ValueProvider<RuntimeSequence<? extends Integer>> sigmaProvider;
    private ArrayList<Integer> ds = new ArrayList();

    public RuntimeDefer(RuntimeClock implicitClock, RuntimeClock baseClock, RuntimeClock delayClock, RuntimeSequence<? extends Integer> delayPattern) {
        super(implicitClock);
        this.baseClock = baseClock;
        this.delayClock = delayClock;
        this.sigma = delayPattern;
        this.sigmaProvider = null;
    }

    public RuntimeDefer(RuntimeClock implicitClock, RuntimeClock baseClock, RuntimeClock delayClock, ValueProvider<RuntimeSequence<? extends Integer>> delayPattern) {
        this.baseClock = baseClock;
        this.delayClock = delayClock;
        this.sigma = null;
        this.sigmaProvider = delayPattern;
    }

    @Override
    public void start(AbstractSemanticHelper helper) throws SimulationException {
        if (!this.canCallStart()) {
            return;
        }
        super.start(helper);
        this.ds.clear();
        if (this.sigmaProvider != null) {
            this.sigma = this.sigmaProvider.getValue();
        }
    }

    @Override
    public void semantic(AbstractSemanticHelper helper) throws SimulationException {
        if (!this.canCallSemantic()) {
            return;
        }
        super.semantic(helper);
        if (this.baseClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.baseClock)).semantic(helper);
        }
        if (this.delayClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.delayClock)).semantic(helper);
        }
        if (this.state == AbstractConstraint.State.DEAD) {
            helper.inhibitClock(this.getExpressionClock());
        } else {
            boolean beta = false;
            if (this.ds.isEmpty()) {
                beta = false;
            } else {
                boolean bl = beta = this.getDelay() == 1 || this.getDelay() == 0;
            }
            if (beta) {
                helper.semanticBDDAnd(helper.createEqual(this.getExpressionClock(), this.delayClock));
            } else {
                helper.semanticBDDAnd(helper.createNot(this.getExpressionClock()));
            }
        }
        helper.registerClockUse(new RuntimeClock[]{this.getExpressionClock(), this.baseClock, this.delayClock});
    }

    @Override
    public void deathSemantic(AbstractSemanticHelper helper) throws SimulationException {
        super.deathSemantic(helper);
        if (this.baseClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.baseClock)).deathSemantic(helper);
        }
        if (this.delayClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.delayClock)).deathSemantic(helper);
        }
        helper.registerDeathImplication(this.delayClock, this.getExpressionClock());
    }

    @Override
    public void update(AbstractUpdateHelper helper) throws SimulationException {
        if (!this.canCallUpdate()) {
            return;
        }
        super.update(helper);
        if (this.baseClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.baseClock)).update(helper);
        }
        if (this.delayClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.delayClock)).update(helper);
        }
        if (this.ds.isEmpty() && this.sigma.isEmpty() || this.delayClock.isDead()) {
            this.terminate(helper);
            return;
        }
        if (helper.clockHasFired(this.baseClock)) {
            if (helper.clockHasFired(this.delayClock)) {
                this.nextDelay();
                Integer next = this.sigma.popHead();
                if (next != null) {
                    this.sched(next, 0);
                }
            } else {
                Integer next = this.sigma.popHead();
                if (next != null) {
                    this.sched(next, 0);
                }
            }
        } else if (helper.clockHasFired(this.delayClock)) {
            this.nextDelay();
        }
    }

    private int getDelay() {
        if (this.ds.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        return this.ds.get(0);
    }

    private void nextDelay() {
        if (!this.ds.isEmpty()) {
            int head = this.ds.get(0);
            if (head == 1 || head == 0) {
                this.ds.remove(0);
            } else {
                this.ds.set(0, head - 1);
            }
        }
    }

    private void sched(int next, int start) {
        if (this.ds.size() == start) {
            this.ds.add(start, next);
        } else {
            int head = this.ds.get(start);
            if (next == head) {
                return;
            }
            if (next < head) {
                int rem = head - next;
                this.ds.set(start, next);
                this.ds.add(start + 1, rem);
            } else {
                int rem = next - head;
                this.sched(rem, start + 1);
            }
        }
    }

    @Override
    public SerializedConstraintState dumpState() {
        SerializedConstraintState currentState = super.dumpState();
        currentState.dump(this.ds.size());
        int i = 0;
        while (i < this.ds.size()) {
            currentState.dump(Integer.valueOf(this.ds.get(i)));
            ++i;
        }
        currentState.dump(this.sigma.finiteIndex);
        currentState.dump(this.sigma.infiniteIndex);
        return currentState;
    }

    @Override
    public void restoreState(SerializedConstraintState stateData) {
        super.restoreState(stateData);
        this.ds.clear();
        int size = (Integer)stateData.restore(2);
        int i = 3;
        i = 3;
        while (i < size + 3) {
            this.ds.add(new Integer((Integer)stateData.restore(i)));
            ++i;
        }
        this.sigma.finiteIndex = (Integer)stateData.restore(i++);
        this.sigma.infiniteIndex = (Integer)stateData.restore(i++);
    }
}

