/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.antlr.view;

import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.utils.pluginhelpers.PluginHelpers;
import fr.inria.aoste.timesquare.vcd.model.comment.IConstraintData;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class ConstraintView
extends ViewPart {
    private static ConstraintView courant;
    private static ArrayList<IConstraintData> localConstraint;
    private Composite parents = null;
    private Table table = null;
    private boolean b = true;
    private int size = 0;

    static {
        localConstraint = null;
    }

    public ConstraintView() {
        ConstraintView.setCourant(this);
    }

    private static final synchronized void setCourant(ConstraintView courant) {
        ConstraintView.courant = courant;
    }

    private static final synchronized void unsetAll(ConstraintView _courant) {
        if (courant == _courant) {
            courant = null;
        } else {
            System.err.println("Warning View" + (_courant != null) + " " + (courant != null));
        }
    }

    private static final void setLocalConstraint(ArrayList<IConstraintData> localConstraint) {
        ConstraintView.localConstraint = localConstraint;
    }

    public void createPartControl(Composite parent) {
        try {
            ConstraintView.setCourant(this);
            this.parents = parent;
            this.table = new Table(parent, 67620);
            this.table.setHeaderVisible(true);
            TableColumn column = null;
            column = new TableColumn(this.table, 0x1000000, 0);
            column.setText("");
            column.setMoveable(false);
            column.setWidth(25);
            column.setResizable(false);
            column = new TableColumn(this.table, 16384, 1);
            column.setText("Constraint Name");
            column.setMoveable(false);
            column.setWidth(200);
            this.table.addMouseListener((MouseListener)new MouseListenerCV(this.table));
            this.draw();
            this.contributeToActionBars();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)new SelectAll("Select All"));
        manager.add((IAction)new DeSelectAll("DeSelect All"));
    }

    public void setFocus() {
        if (this.table == null) {
            return;
        }
        int i = 0;
        while (i < this.table.getItemCount()) {
            TableItem tableItem = this.table.getItem(i);
            IConstraintData data = (IConstraintData)tableItem.getData();
            if (data != null && data.getConstraints() != null) {
                tableItem.setChecked(data.getConstraints().getIsConstraintVisible());
            }
            ++i;
        }
    }

    private int draw() {
        block11: {
            block10: {
                block9: {
                    if (this.parents != null) break block9;
                    return -1;
                }
                if (this.table != null) break block10;
                return -1;
            }
            TableItem[] tableItemArray = this.table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem ti = tableItemArray[n2];
                ti.setData(null);
                ++n2;
            }
            this.table.removeAll();
            if (localConstraint != null) break block11;
            return -1;
        }
        try {
            for (IConstraintData var : localConstraint) {
                this.table.getColumn(1).pack();
                TableItem tableItem = new TableItem(this.table, 0x2000000);
                tableItem.setChecked(false);
                if (var.toString() != null) {
                    tableItem.setText(1, var.toString());
                } else {
                    tableItem.setText(1, "...");
                }
                tableItem.setData((Object)var);
            }
            this.table.getColumn(1).pack();
            this.table.redraw();
        }
        catch (Throwable t) {
            ErrorConsole.printError((Throwable)t);
            t.printStackTrace();
        }
        return 0;
    }

    public void dispose() {
        ConstraintView.unsetAll(this);
        super.dispose();
    }

    public static boolean exist() {
        return courant != null;
    }

    public static synchronized ConstraintView getCurrentConstraintView() {
        if (courant == null) {
            try {
                PluginHelpers.getShowView((String)"fr.inria.aoste.timesquare.vcd.antlr.constraintview");
                if (courant == null) {
                    PluginHelpers.getCreateView((String)"fr.inria.aoste.timesquare.vcd.antlr.constraintview");
                }
                if (courant != null) {
                    courant.setFocus();
                }
            }
            catch (Throwable ex) {
                ErrorConsole.printError((Throwable)ex, (String)"Constraint View");
            }
        }
        return courant;
    }

    public static synchronized void refreshCourant() {
        if (courant != null) {
            courant.constraintViewRefresh();
        }
    }

    public Table getTable() {
        return this.table;
    }

    public ArrayList<IConstraintData> getConstraint() {
        return localConstraint;
    }

    public void setConstraint(ArrayList<IConstraintData> constraint) {
        if (constraint == null) {
            this.size = 0;
            ConstraintView.setLocalConstraint(null);
            this.draw();
            return;
        }
        int newSize = constraint.size();
        if (localConstraint != constraint || newSize != this.size || this.b) {
            ConstraintView.setLocalConstraint(constraint);
            int r = this.draw();
            if (r == -1) {
                this.size = 0;
                return;
            }
            this.size = newSize;
        }
    }

    public int constraintViewRefresh() {
        if (localConstraint != null && (this.size != localConstraint.size() || this.b)) {
            this.size = localConstraint.size();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConstraintView.this.draw();
                    }
                    catch (Exception e) {
                        System.err.println(e);
                    }
                }
            });
        }
        return 0;
    }

    public void unsetConstraint(ArrayList<IConstraintData> constraint) {
        if (localConstraint == constraint && constraint != null) {
            if (this.table != null) {
                TableItem[] tableItemArray = this.table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem ti = tableItemArray[n2];
                    ti.setData(null);
                    ++n2;
                }
            }
            this.setConstraint(null);
        }
    }

    public void resetConstraint(ArrayList<IConstraintData> constraint) {
        if (constraint == null) {
            this.size = 0;
            ConstraintView.setLocalConstraint(null);
            this.draw();
            return;
        }
        int newSize = constraint.size();
        ConstraintView.setLocalConstraint(constraint);
        int r = this.draw();
        if (r == -1) {
            ConstraintView.setLocalConstraint(null);
            this.size = 0;
            return;
        }
        this.size = newSize;
    }

    public final class DeSelectAll
    extends Action {
        public DeSelectAll(String text) {
            super(text);
        }

        public void run() {
            int i = 0;
            while (i < ConstraintView.this.table.getItemCount()) {
                TableItem tableItem = ConstraintView.this.table.getItem(i);
                IConstraintData data = (IConstraintData)tableItem.getData();
                if (data != null && data.getConstraints() != null) {
                    if (data.getConstraints().getIsConstraintVisible()) {
                        data.getConstraints().drawTableItemConstraints();
                    }
                    data.getConstraints().setIsConstraintVisible(false);
                }
                ++i;
            }
            ConstraintView.this.setFocus();
        }
    }

    private class MouseListenerCV
    implements MouseListener {
        private Table table;

        public MouseListenerCV(Table table) {
            this.table = table;
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1) {
                IConstraintData data = null;
                TableItem tableItem = this.table.getItem(new Point(e.x, e.y));
                if (tableItem == null) {
                    return;
                }
                data = (IConstraintData)tableItem.getData();
                if (data == null) {
                    ErrorConsole.printlnError((String)"ERROR DATA NULL");
                    return;
                }
                if (data.getConstraints() == null) {
                    ErrorConsole.printlnError((String)"--> IC are  NULL :  ");
                    return;
                }
                if (tableItem.getChecked()) {
                    if (!data.getConstraints().getIsConstraintVisible()) {
                        data.getConstraints().setIsConstraintVisible(true);
                        int ret = data.getConstraints().drawTableItemConstraints();
                        if (ret == -1) {
                            tableItem.setChecked(true);
                            ErrorConsole.printlnError((String)"WARNING : at least one clock is hidden");
                        }
                    }
                } else if (data.getConstraints().getIsConstraintVisible()) {
                    data.getConstraints().setIsConstraintVisible(false);
                    data.getConstraints().drawTableItemConstraints();
                }
            }
        }

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    }

    public final class SelectAll
    extends Action {
        public SelectAll(String text) {
            super(text);
        }

        public void run() {
            int i = 0;
            while (i < ConstraintView.this.table.getItemCount()) {
                TableItem tableItem = ConstraintView.this.table.getItem(i);
                IConstraintData data = (IConstraintData)tableItem.getData();
                if (data != null && data.getConstraints() != null) {
                    if (!data.getConstraints().getIsConstraintVisible()) {
                        data.getConstraints().drawTableItemConstraints();
                    }
                    data.getConstraints().setIsConstraintVisible(true);
                }
                ++i;
            }
            ConstraintView.this.setFocus();
        }
    }
}

