/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.model.visitor;

import fr.inria.aoste.timesquare.vcd.model.IVar;
import fr.inria.aoste.timesquare.vcd.model.ValueChange;
import fr.inria.aoste.timesquare.vcd.model.keyword.SimulationKeyword;
import fr.inria.aoste.timesquare.vcd.model.keyword.VarType;
import fr.inria.aoste.timesquare.vcd.model.visitor.ISimulationCollector;
import fr.inria.aoste.timesquare.vcd.model.visitor.TraceData;
import fr.inria.aoste.timesquare.vcd.view.VcdFactory;
import fr.inria.aoste.timesquare.vcd.view.VcdValueFactory;
import fr.inria.aoste.timesquare.vcd.view.figure.ExtendFigure;
import java.util.ArrayList;
import java.util.HashMap;

public class TraceCollector
implements ISimulationCollector {
    private int _time = -1;
    private boolean _isPartial = false;
    private HashMap<String, TraceData> _traceDataMap = new HashMap();
    private ArrayList<IVar> _selectedClocks = new ArrayList();
    private ArrayList<IVar> _invisibleClocks = new ArrayList();
    private double _zoomValue = 1.0;
    private VcdFactory _vcdFactory = null;

    public TraceCollector(Iterable<IVar> vars, VcdFactory vcdFactory) {
        this(vars, vcdFactory, false);
    }

    public TraceCollector(Iterable<IVar> vars, VcdFactory vcdFactory, boolean allVarsVisible) {
        this._vcdFactory = vcdFactory;
        this._traceDataMap.clear();
        for (IVar var : vars) {
            if (var.isVisibleByDefault() || allVarsVisible) {
                this._selectedClocks.add(var);
                VcdValueFactory _vcdValueFactory = vcdFactory.initVcdValueFactory(var, this._zoomValue);
                ExtendFigure.Level initVarValue = null;
                if (var.getVarCommand().getType() == VarType.tri) {
                    initVarValue = ExtendFigure.Level.z;
                }
                TraceData td = new TraceData(_vcdValueFactory, (Object)initVarValue);
                this._traceDataMap.put(var.getIdentiferCode(), td);
                continue;
            }
            this._invisibleClocks.add(var);
        }
        for (IVar var : this._selectedClocks) {
            this.getAllnames().remove(var);
        }
    }

    public void constructClock(VcdFactory factory, ArrayList<IVar> listvar, double zoomValue) {
        if (this._traceDataMap != null) {
            for (TraceData traceData : this._traceDataMap.values()) {
                traceData._value = null;
                if (traceData._extendFigure != null) {
                    traceData._extendFigure.erase();
                }
                traceData._extendFigure = null;
                traceData._vcdValueFactory = null;
            }
            this._traceDataMap.clear();
        }
        this._selectedClocks.clear();
        this._selectedClocks = listvar;
        for (IVar var : this._selectedClocks) {
            this._traceDataMap.put(var.getIdentiferCode(), new TraceData(factory.initVcdValueFactory(var, 2.0)));
            this.getAllnames().remove(var);
        }
    }

    @Override
    public void visitTimeLine(int time) {
        this._time = time;
        this._vcdFactory.modifyTimeLineSize(time);
    }

    @Override
    public void visitKeyword(SimulationKeyword keyword) {
    }

    @Override
    public void visitValueChange(ValueChange valueChange, int time) {
        TraceData traceData = this._traceDataMap.get(valueChange.getIdentifierCode());
        if (traceData == null) {
            return;
        }
        Object value = valueChange.getValue();
        if (traceData._value != null) {
            traceData._vcdValueFactory.build(traceData._value, time, traceData._previousTime);
        }
        traceData._value = value;
        traceData._previousTime = time;
    }

    @Override
    public void endSimulation() {
        for (TraceData td : this._traceDataMap.values()) {
            if (td._value == null) continue;
            td._vcdValueFactory.buildEnd(td._value, td._previousTime, this._time);
        }
    }

    public ArrayList<IVar> getSelectedClocks() {
        return this._selectedClocks;
    }

    public ArrayList<IVar> getAllnames() {
        return this._invisibleClocks;
    }

    public void setAllClocks(ArrayList<IVar> allClocks) {
        this._invisibleClocks = allClocks;
    }

    public void setZoom(double zoomValue) {
        this._zoomValue = zoomValue;
    }

    public boolean isPartial() {
        return this._isPartial;
    }

    public void setPartial(boolean partial) {
        this._isPartial = partial;
    }

    public VcdValueFactory getDataFactory(String index) {
        TraceData _traceData = this._traceDataMap.get(index);
        if (_traceData == null) {
            return null;
        }
        return _traceData._vcdValueFactory;
    }

    public boolean isContainGhost() {
        ArrayList<IVar> listVar = new ArrayList<IVar>();
        listVar.addAll(this.getSelectedClocks());
        listVar.addAll(this.getAllnames());
        for (IVar var : listVar) {
            if (var.getValueFactory() == null || !var.getValueFactory().haveGhostinclock()) continue;
            return true;
        }
        return false;
    }

    public void ghostMode(boolean _ghostMode) {
        for (IVar vr : this.getSelectedClocks()) {
            if (vr.getValueFactory() == null) continue;
            vr.getValueFactory().setIsGhostVisible(_ghostMode);
        }
    }

    public int clear() {
        for (TraceData td : this._traceDataMap.values()) {
            if (td == null) continue;
            td.clear();
        }
        this._selectedClocks.clear();
        for (IVar iv : this._invisibleClocks) {
            iv.clear();
        }
        this._invisibleClocks.clear();
        this._traceDataMap.clear();
        this._vcdFactory = null;
        return 0;
    }

    @Override
    public void visitEnd(SimulationKeyword keyword) {
    }
}

