/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.model.keyword;

public enum TimeUnit {
    s(0),
    ms(1),
    us(2),
    ns(3),
    ps(4),
    fs(5),
    tick(-1);

    final int n;

    private TimeUnit(int n2) {
        this.n = n2;
    }

    public static String getTime(double d, TimeUnit t) {
        if (t == null || t == tick) {
            return "" + d;
        }
        if (d == 0.0) {
            return "0.0" + t.toString();
        }
        int k = (int)Math.log10(d) / 3;
        int k2 = t.n - k;
        if (k2 < 0) {
            k2 = 0;
        }
        if (k2 > 5) {
            k2 = 5;
        }
        TimeUnit tx = TimeUnit.getTimeUnit(k2);
        double d2 = d * t.getConvertionRatio(tx);
        return (float)d2 + " " + tx.toString();
    }

    public double getConvertionRatio(TimeUnit convert) {
        if (this.n == -1 || convert.n == -1) {
            return 1.0;
        }
        int delta = (convert.n - this.n) * 3;
        return Math.pow(10.0, delta);
    }

    public static TimeUnit getTimeUnit(int x) {
        TimeUnit[] timeUnitArray = TimeUnit.values();
        int n = timeUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeUnit tu = timeUnitArray[n2];
            if (tu.n == x) {
                return tu;
            }
            ++n2;
        }
        return null;
    }
}

