/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.model;

import fr.inria.aoste.timesquare.vcd.preferences.VcdColorPreferences;
import java.util.ArrayList;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class Timeline
extends Polyline {
    private VcdColorPreferences _mca;
    private PointList _pointListRef = new PointList();
    private int _startPointX;
    private int _startPointY;
    private int _endPointX;
    private int _endPointY;
    private static int _unitTimeLength;
    private static int _unitTimeLengthRef;
    private static int _height;
    private static int _halfHeight;
    private static int _tHeight;
    private ArrayList<Label> _labels = new ArrayList();
    private ArrayList<Integer> _labelsPositionXRef = new ArrayList();

    static {
        _height = 20;
        _halfHeight = 12;
        _tHeight = 5;
    }

    public ArrayList<Label> getLabels() {
        return this._labels;
    }

    public Timeline(Point startPoint, int unitTimeLength, VcdColorPreferences mca) {
        this.setOpaque(false);
        this._mca = mca;
        _unitTimeLengthRef = _unitTimeLength = unitTimeLength * 2;
        this._startPointX = startPoint.x;
        this._startPointY = startPoint.y + 10;
        this._endPointX = this._startPointX;
        this._endPointY = this._startPointY;
        PointList pl = new PointList();
        pl.addPoint(this._startPointX, this._startPointY + _height);
        this._pointListRef.addPoint(this._startPointX, this._startPointY + _height);
        this.setPoints(pl);
        this.setForegroundColor(this._mca.colorWhiteRule());
    }

    public void extendTimeLine(String labelText) {
        PointList pl = this.getPoints();
        pl.addPoint(this._endPointX, this._endPointY);
        this._pointListRef.addPoint(this._endPointX, this._endPointY);
        Label label = new Label(labelText);
        label.setBounds(new Rectangle(0, 0, 60, 30));
        Point p = new Point(pl.getLastPoint());
        p.x += 2;
        label.setLocation(p);
        this._labelsPositionXRef.add(p.x);
        label.setForegroundColor(this._mca.colorRedRule());
        label.setLabelAlignment(1);
        this._labels.add(label);
        this.add((IFigure)label);
        int i = 0;
        i = 1;
        while (i < 5) {
            pl.addPoint(this._endPointX + _unitTimeLength * i, this._endPointY);
            pl.addPoint(this._endPointX + _unitTimeLength * i, this._endPointY + _tHeight);
            pl.addPoint(this._endPointX + _unitTimeLength * i, this._endPointY);
            this._pointListRef.addPoint(this._endPointX + _unitTimeLength * i, this._endPointY);
            this._pointListRef.addPoint(this._endPointX + _unitTimeLength * i, this._endPointY + _tHeight);
            this._pointListRef.addPoint(this._endPointX + _unitTimeLength * i, this._endPointY);
            ++i;
        }
        pl.addPoint(this._endPointX + _unitTimeLength * 5, this._endPointY);
        pl.addPoint(this._endPointX + _unitTimeLength * 5, this._endPointY + _halfHeight);
        pl.addPoint(this._endPointX + _unitTimeLength * 5, this._endPointY);
        this._pointListRef.addPoint(this._endPointX + _unitTimeLength * 5, this._endPointY);
        this._pointListRef.addPoint(this._endPointX + _unitTimeLength * 5, this._endPointY + _halfHeight);
        this._pointListRef.addPoint(this._endPointX + _unitTimeLength * 5, this._endPointY);
        i = 6;
        while (i < 10) {
            pl.addPoint(this._endPointX + _unitTimeLength * i, this._endPointY);
            pl.addPoint(this._endPointX + _unitTimeLength * i, this._endPointY + _tHeight);
            pl.addPoint(this._endPointX + _unitTimeLength * i, this._endPointY);
            this._pointListRef.addPoint(this._endPointX + _unitTimeLength * i, this._endPointY);
            this._pointListRef.addPoint(this._endPointX + _unitTimeLength * i, this._endPointY + _tHeight);
            this._pointListRef.addPoint(this._endPointX + _unitTimeLength * i, this._endPointY);
            ++i;
        }
        pl.addPoint(this._endPointX + 10 * _unitTimeLength, this._endPointY);
        pl.addPoint(this._endPointX + 10 * _unitTimeLength, this._endPointY + _height);
        this._pointListRef.addPoint(this._endPointX + 10 * _unitTimeLength, this._endPointY);
        this._pointListRef.addPoint(this._endPointX + 10 * _unitTimeLength, this._endPointY + _height);
        this._endPointX += 10 * _unitTimeLength;
        Panel timelinePanel = (Panel)this.getParent();
        timelinePanel.setPreferredSize(this._endPointX, timelinePanel.getPreferredSize().height);
    }

    public void timeLineEnd() {
        this.getPoints().addPoint(this._endPointX, this._endPointY);
        this._pointListRef.addPoint(this._endPointX, this._endPointY);
    }

    public int getStartPointX() {
        return this._startPointX;
    }

    public void setStartPointX(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("the x starting point must be positive: " + x);
        }
        this._startPointX = x;
    }

    public int getStartPointY() {
        return this._startPointY;
    }

    public void setStartPointY(int y) {
        if (y < 0) {
            throw new IllegalArgumentException("the y starting point must be positive: " + y);
        }
        this._startPointY = y;
    }

    public int getEndPointX() {
        return this._endPointX;
    }

    public void setEndPointX(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("the x starting point must be positive: " + x);
        }
        this._endPointX = x;
    }

    public int getEndPointY() {
        return this._endPointY;
    }

    public void setEndPointY(int y) {
        if (y < 0) {
            throw new IllegalArgumentException("the x starting point must be positive: " + y);
        }
        this._endPointY = y;
    }

    public void setStartPoint(Point sp) {
        this._startPointX = sp.x;
        this._startPointY = sp.y;
    }

    public void setEndPoint(Point sp) {
        this._endPointX = sp.x;
        this._endPointY = sp.y;
    }

    public int getUnitTimeLength() {
        return _unitTimeLength;
    }

    public void setUnitTimeLength(int utl) {
        _unitTimeLength = utl;
    }

    public void timelineZoom(double value) {
        PointList pl = new PointList();
        pl.addAll(this._pointListRef);
        int sizeofpl = pl.size();
        Point p = null;
        int i = 0;
        while (i < sizeofpl) {
            p = pl.getPoint(i);
            p.setX((int)((double)(p.x - this._startPointX) * value + (double)this._startPointX));
            pl.setPoint(p, i);
            ++i;
        }
        int index = 0;
        for (Label label : this._labels) {
            p = label.getLocation();
            int labelPositionX = this._labelsPositionXRef.get(index);
            p.x = (int)((double)(labelPositionX - this._startPointX - 2) * value + (double)this._startPointX + 2.0);
            label.setLocation(p);
            ++index;
        }
        this.removeAllPoints();
        this.setPoints(pl);
        _unitTimeLength = (int)((double)_unitTimeLengthRef * value);
        this._endPointX = pl.getLastPoint().x;
        Panel timelinePanel = (Panel)this.getParent();
        timelinePanel.setPreferredSize(this.getSize().width, timelinePanel.getSize().height);
    }

    public void timeLineZoomIn() {
        PointList pl = new PointList();
        pl.addAll(this.getPoints());
        int sizeofpl = pl.size();
        Point p = null;
        int i = 0;
        while (i < sizeofpl) {
            p = pl.getPoint(i);
            p.setX((p.x - this._startPointX) * 2 + this._startPointX);
            pl.setPoint(p, i);
            ++i;
        }
        for (Label label : this._labels) {
            p = label.getLocation();
            p.x = (p.x - this._startPointX - 2) * 2 + this._startPointX + 2;
            label.setLocation(p);
        }
        this.removeAllPoints();
        this.setPoints(pl);
        _unitTimeLength *= 2;
        this._endPointX = pl.getLastPoint().x;
        Panel timelinePanel = (Panel)this.getParent();
        timelinePanel.setPreferredSize(this.getSize().width, timelinePanel.getSize().height);
    }

    public void timeLineZoomOut() {
        PointList pl = new PointList();
        pl.addAll(this.getPoints());
        int sizeofpl = pl.size();
        Point p = null;
        int i = 0;
        while (i < sizeofpl) {
            p = pl.getPoint(i);
            p.setX((p.x - this._startPointX) / 2 + this._startPointX);
            pl.setPoint(p, i);
            ++i;
        }
        for (Label label : this._labels) {
            p = label.getLocation();
            p.x = (p.x - this._startPointX - 2) / 2 + this._startPointX + 2;
            label.setLocation(p);
        }
        this.removeAllPoints();
        this.setPoints(pl);
        _unitTimeLength /= 2;
        this._endPointX = pl.getLastPoint().x;
        Panel timelinePanel = (Panel)this.getParent();
        timelinePanel.setPreferredSize(this.getSize().width, timelinePanel.getSize().height);
    }
}

