/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.ide.ui.xdsml.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gemoc.xdsmlframework.ide.ui.Activator;
import org.eclipse.gemoc.xdsmlframework.ide.ui.xdsml.wizards.pages.AskLanguageNameWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public abstract class AbstractCreateNewGemocLanguageProject
extends Wizard
implements INewWizard {
    protected WizardNewProjectCreationPage _askProjectNamePage;
    protected AskLanguageNameWizardPage _askLanguageNamePage;
    protected IProject createdProject = null;

    public AbstractCreateNewGemocLanguageProject() {
        this.setWindowTitle("Create Domain Model");
        this._askProjectNamePage = new WizardNewProjectCreationPage("NewGemocLanguageProjectName");
        this._askProjectNamePage.setTitle("Project");
        this._askProjectNamePage.setDescription("Create a new Gemoc Language Project");
        this._askProjectNamePage.setInitialProjectName("org.company.my_language.xdsml");
        this.addPage((IWizardPage)this._askProjectNamePage);
        this._askLanguageNamePage = new AskLanguageNameWizardPage("NewGemocLanguageName");
        this._askLanguageNamePage.setTitle("Language");
        this._askLanguageNamePage.setDescription("Specify the language name");
        this.addPage((IWizardPage)this._askLanguageNamePage);
    }

    public void addPages() {
        super.addPages();
    }

    public boolean needsPreviousAndNextButtons() {
        return true;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this._askLanguageNamePage && this._askLanguageNamePage.isPageComplete();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this._askProjectNamePage) {
            int index = this._askProjectNamePage.getProjectName().indexOf(".xdsml");
            if (index != -1) {
                this._askLanguageNamePage.setLanguageName(this._askProjectNamePage.getProjectName().substring(0, index));
            } else {
                this._askLanguageNamePage.setLanguageName(this._askProjectNamePage.getProjectName());
            }
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        try {
            this.createdProject = this._askProjectNamePage.getProjectHandle();
            final String languageName = this._askLanguageNamePage.getLanguageName();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            final IProjectDescription description = workspace.newProjectDescription(this.createdProject.getName());
            if (!this._askProjectNamePage.getLocationPath().equals((Object)workspace.getRoot().getLocation())) {
                description.setLocation(this._askProjectNamePage.getLocationPath());
            }
            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    AbstractCreateNewGemocLanguageProject.this.createdProject.create(description, monitor);
                    AbstractCreateNewGemocLanguageProject.this.createdProject.open(monitor);
                    AbstractCreateNewGemocLanguageProject.this.initializeProject(AbstractCreateNewGemocLanguageProject.this.createdProject, languageName);
                    AbstractCreateNewGemocLanguageProject.this.createdProject.refreshLocal(2, monitor);
                    AbstractCreateNewGemocLanguageProject.this.createdProject.touch((IProgressMonitor)new NullProgressMonitor());
                }
            };
            ResourcesPlugin.getWorkspace().run(operation, null);
        }
        catch (CoreException exception) {
            Activator.error(exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected abstract void initializeProject(IProject var1, String var2);

    public IProject getCreatedProject() {
        return this.createdProject;
    }
}

