/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.ide.ui.builder;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gemoc.commons.eclipse.jdt.JavaProject;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.eclipse.gemoc.commons.eclipse.pde.ui.PluginConverter;
import org.eclipse.gemoc.xdsmlframework.ide.ui.Activator;
import org.eclipse.gemoc.xdsmlframework.ide.ui.builder.pde.PluginXMLHelper;
import org.osgi.framework.BundleException;

public class GemocLanguageProjectNature
implements IProjectNature {
    public static final String NATURE_ID = "org.eclipse.gemoc.xdsmlframework.ide.ui.GemocLanguageProjectNature";
    private IProject project;

    public void configure() throws CoreException {
        this.requirementConfigure();
        IProjectDescription desc = this.project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.eclipse.gemoc.xdsmlframework.ide.ui.GemocLanguageProjectBuilder")) {
                return;
            }
            ++i;
        }
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.gemoc.xdsmlframework.ide.ui.GemocLanguageProjectBuilder");
        newCommands[newCommands.length - 1] = command;
        desc.setBuildSpec(newCommands);
        this.project.setDescription(desc, null);
    }

    public void deconfigure() throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.eclipse.gemoc.xdsmlframework.ide.ui.GemocLanguageProjectBuilder")) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.project.setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    public void requirementConfigure() throws CoreException {
        try {
            JavaProject.create((IProject)this.project);
            this.addPluginNature(this.project);
            this.updateManifestFile(this.project);
        }
        catch (IOException e) {
            Activator.error("Problem while adding Gemoc Language nature to project. " + e.getMessage(), e);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    private void addPluginNature(IProject project) throws CoreException {
        if (!project.hasNature("org.eclipse.pde.PluginNature")) {
            try {
                PluginXMLHelper.createEmptyTemplateFile(project.getFile("plugin.xml"), false);
                PluginConverter.convert((IProject)project);
            }
            catch (InterruptedException | InvocationTargetException e) {
                Activator.error("cannot add org.eclipse.pde.PluginNature nature to project due to " + e.getMessage(), e);
            }
        }
    }

    private void updateManifestFile(IProject project) {
        try {
            project.refreshLocal(2, null);
            ManifestChanger changer = new ManifestChanger(project);
            changer.addPluginDependency("org.eclipse.gemoc.xdsmlframework.api", "4.0.0", true, true);
            changer.addPluginDependency("org.eclipse.emf.ecore.xmi", "2.8.0", true, true);
            changer.addPluginDependency("org.eclipse.gemoc.executionframework.engine", "4.0.0", true, true);
            changer.commit();
        }
        catch (IOException | CoreException | BundleException e) {
            Activator.error("Failed to update manifest " + e.getMessage(), e);
        }
    }
}

