/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.generic.impl.helpers;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.diffmerge.generic.api.IComparison;
import org.eclipse.emf.diffmerge.generic.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMapping;
import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.IMergePolicy;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.generic.api.scopes.ITreeDataScope;

public class UnidirectionalComparisonCopier<E> {
    protected final Role _sourceRole;
    protected IMapping.Editable<E> _mapping;
    protected ITreeDataScope<E> _sourceScope;
    protected IEditableTreeDataScope<E> _destinationScope;
    protected IDiffPolicy<E> _diffPolicy;
    protected IMergePolicy<E> _mergePolicy;
    protected boolean _copyOutOfScopeValues;

    public UnidirectionalComparisonCopier(Role sourceRole_p) {
        this._sourceRole = sourceRole_p;
        this._mapping = null;
        this._sourceScope = null;
        this._destinationScope = null;
        this._copyOutOfScopeValues = false;
    }

    public E completeMatch(IMatch<E> partialMatch_p, IComparison.Editable<E> comparison_p) {
        this.setComparison(comparison_p);
        assert (partialMatch_p.getUncoveredRole() == this._sourceRole.opposite() && !this.getCompletedMatches().contains(partialMatch_p));
        Object element = partialMatch_p.get(this._sourceRole);
        Object result = this.copy(element);
        assert (result != null);
        this._mapping.mapIncrementally(element, this._sourceRole, result, this._sourceRole.opposite());
        this.getCompletedMatches().add(this._mapping.getMatchFor(element, this._sourceRole));
        return result;
    }

    public void completeReferences(IComparison.Editable<E> comparison_p) {
        this.setComparison(comparison_p);
        this.copyReferences();
    }

    protected E copy(E sourceElement_p) {
        assert (this._mergePolicy != null);
        Object result = this._destinationScope.tNewBareElement(sourceElement_p);
        for (Object attribute : this._sourceScope.mGetAttributes(sourceElement_p)) {
            if (!this.coverAttribute(attribute)) continue;
            this.copyAttribute(attribute, sourceElement_p, result);
        }
        return result;
    }

    protected void copyAttribute(Object attribute_p, E element_p, E copy_p) {
        for (Object value : this._sourceScope.getAttributeValues(element_p, attribute_p)) {
            this._destinationScope.addAttributeValue(copy_p, attribute_p, value);
        }
    }

    protected void copyReferences() {
        for (IMatch<E> updatedMatch : this.getCompletedMatches()) {
            this.copyReferences(updatedMatch);
        }
        if (this._mergePolicy != null) {
            for (IMatch<E> updatedMatch : this.getCompletedMatches()) {
                Object source = updatedMatch.get(this._sourceRole);
                Object target = updatedMatch.get(this._sourceRole.opposite());
                this._mergePolicy.setID(source, this._sourceScope, target, this._destinationScope);
            }
        }
    }

    protected void copyReferences(IMatch<E> match_p) {
        Object source = match_p.get(this._sourceRole);
        Object destination = match_p.get(this._sourceRole.opposite());
        assert (source != null && destination != null);
        for (Object reference : this._sourceScope.mGetReferences(source)) {
            if (this._sourceScope.mIsContainerReference(reference) || !this.coverReference(reference)) continue;
            this.copyReference(reference, source, destination);
        }
    }

    protected void copyReference(Object reference_p, E element_p, E copy_p) {
        List<E> sourceValues = this._sourceScope.getReferenceValues(element_p, reference_p);
        Object opposite = this._sourceScope.mGetOppositeReference(reference_p);
        for (E sourceValue : sourceValues) {
            IMatch valueMatch = this._mapping.getMatchFor(sourceValue, this._sourceRole);
            if (valueMatch != null) {
                Object destinationValue;
                IMatch<E> holderMatch;
                boolean mustCopy;
                boolean bl = mustCopy = this.getCompletedMatches().contains(valueMatch) || opposite == null && !this._sourceScope.mIsContainmentReference(reference_p);
                if (!mustCopy && (holderMatch = this._mapping.getMatchFor(element_p, this._sourceRole)) != null) {
                    boolean bl2 = mustCopy = holderMatch.getReferenceValueDifference(reference_p, sourceValue) == null;
                }
                if (!mustCopy || (destinationValue = valueMatch.get(this._sourceRole.opposite())) == null) continue;
                this._destinationScope.addReferenceValue(copy_p, reference_p, destinationValue);
                continue;
            }
            if ((!this._copyOutOfScopeValues || opposite != null || this._sourceScope.mIsContainmentReference(reference_p) || this._sourceScope.mIsContainerReference(reference_p)) && (this._diffPolicy == null || !this._diffPolicy.coverOutOfScopeValue(sourceValue, reference_p, this._sourceScope))) continue;
            this._destinationScope.addReferenceValue(copy_p, reference_p, sourceValue);
        }
    }

    protected boolean coverAttribute(Object attribute_p) {
        return this._mergePolicy != null && this._mergePolicy.copyAttribute(attribute_p, this._destinationScope);
    }

    protected boolean coverReference(Object reference_p) {
        return this._mergePolicy != null && this._mergePolicy.copyReference(reference_p, this._destinationScope);
    }

    public E get(E element_p) {
        return this.get(element_p, true);
    }

    public E get(E element_p, boolean copyOnly_p) {
        E result = null;
        IMatch match = this._mapping.getMatchFor(element_p, this._sourceRole);
        if (match != null && (!copyOnly_p || this.getCompletedMatches().contains(match))) {
            result = match.get(this._sourceRole.opposite());
        }
        return result;
    }

    protected Collection<IMatch<E>> getCompletedMatches() {
        return this._mapping.getModifiableCompletedMatches(this._sourceRole.opposite());
    }

    protected void setComparison(IComparison.Editable<E> comparison_p) {
        this._mapping = comparison_p.getMapping();
        this._sourceScope = comparison_p.getScope(this._sourceRole);
        this._destinationScope = comparison_p.getScope(this._sourceRole.opposite());
        this._diffPolicy = comparison_p.getLastDiffPolicy();
        this._mergePolicy = comparison_p.getLastMergePolicy();
        if (this._mergePolicy != null) {
            this._copyOutOfScopeValues = this._mergePolicy.copyOutOfScopeCrossReferences(this._sourceScope, this._destinationScope);
        }
    }
}

