/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.gexpressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum GRelationOperator implements Enumerator
{
    LESS(0, "LESS", "<"),
    GREATER(1, "GREATER", ">"),
    LESSEQUAL(2, "LESSEQUAL", "<="),
    GREATEREQUAL(3, "GREATEREQUAL", ">=");

    public static final int LESS_VALUE = 0;
    public static final int GREATER_VALUE = 1;
    public static final int LESSEQUAL_VALUE = 2;
    public static final int GREATEREQUAL_VALUE = 3;
    private static final GRelationOperator[] VALUES_ARRAY;
    public static final List<GRelationOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GRelationOperator[]{LESS, GREATER, LESSEQUAL, GREATEREQUAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GRelationOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GRelationOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GRelationOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GRelationOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GRelationOperator get(int value) {
        switch (value) {
            case 0: {
                return LESS;
            }
            case 1: {
                return GREATER;
            }
            case 2: {
                return LESSEQUAL;
            }
            case 3: {
                return GREATEREQUAL;
            }
        }
        return null;
    }

    private GRelationOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

