/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.modelunfolding;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.BindableEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Binding;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ConditionalExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExprCase;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Expression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExternalExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.KernelExpressionDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.UserExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.util.ClockExpressionAndRelationSwitch;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.NamedElement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class RecursiveDefinitionChecker
extends ClockExpressionAndRelationSwitch<Boolean> {
    private ExpressionDeclaration declaration;
    private Deque<NamedElement> nodePath;
    private boolean recursive;
    private boolean tailRecursive;
    private boolean tailCall;
    private Expression recursiveCall;
    private List<NamedElement> recursionPath = Collections.emptyList();
    private List<BindableEntity> recursionArgs;

    public RecursiveDefinitionChecker(ExpressionDefinition definition) {
        this.declaration = definition.getDeclaration();
        this.nodePath = new ArrayDeque<NamedElement>();
        this.tailCall = true;
        this.recursive = (Boolean)this.doSwitch((EObject)definition);
    }

    public boolean isTailRecursive() {
        return this.tailRecursive;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public Expression getRecursiveCall() {
        return this.recursiveCall;
    }

    public List<NamedElement> getRecursionPath() {
        return this.recursionPath;
    }

    public List<BindableEntity> getRecursionArguments() {
        return this.recursionArgs;
    }

    public Boolean caseUserExpressionDefinition(UserExpressionDefinition object) {
        this.nodePath.push((NamedElement)object);
        boolean res = (Boolean)this.doSwitch((EObject)object.getRootExpression());
        this.nodePath.pop();
        return res;
    }

    private void computeRecursionPath() {
        this.recursionPath = new ArrayList<NamedElement>();
        Iterator<NamedElement> iter = this.nodePath.descendingIterator();
        while (iter.hasNext()) {
            this.recursionPath.add(iter.next());
        }
    }

    private void computeRecursionArguments(Expression object) {
        this.recursionArgs = new ArrayList<BindableEntity>();
        for (Binding binding : object.getBindings()) {
            this.recursionArgs.add(binding.getBindable());
        }
    }

    public Boolean caseExpression(Expression object) {
        boolean res = false;
        if (this.nodePath.contains(object)) {
            return false;
        }
        this.nodePath.push((NamedElement)object);
        if (object.getType() == this.declaration) {
            this.tailRecursive = this.tailCall;
            res = true;
            this.recursiveCall = object;
            this.computeRecursionPath();
            this.computeRecursionArguments(object);
        } else if (object.getType() instanceof KernelExpressionDeclaration && object.getType().getName().compareTo("Concatenation") == 0) {
            for (Binding bd : object.getBindings()) {
                if (bd.getAbstract().getName().compareTo("LeftClock") == 0) {
                    boolean savedTailCall = this.tailCall;
                    this.tailCall = false;
                    res = (Boolean)this.doSwitch((EObject)bd.getBindable());
                    this.tailCall = savedTailCall;
                    continue;
                }
                if (bd.getAbstract().getName().compareTo("RightClock") != 0) continue;
                res = (Boolean)this.doSwitch((EObject)bd.getBindable());
            }
        }
        this.nodePath.pop();
        return res;
    }

    public Boolean caseExternalExpressionDefinition(ExternalExpressionDefinition object) {
        return Boolean.FALSE;
    }

    public Boolean caseConditionalExpressionDefinition(ConditionalExpressionDefinition object) {
        boolean res = false;
        this.nodePath.push((NamedElement)object);
        for (ExprCase choice : object.getExprCases()) {
            boolean bl = res = res || (Boolean)this.doSwitch((EObject)choice.getExpression()) != false;
        }
        this.nodePath.pop();
        return res;
    }

    public Boolean defaultCase(EObject object) {
        return Boolean.FALSE;
    }
}

