/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.modelunfolding;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.NamedElement;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiationPath;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.InstantiationTreeMergeConflict;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InstantiationTree<V>
extends HashMap<NamedElement, InstantiationTree<V>> {
    private static final long serialVersionUID = -8313768353453534851L;
    private V data;
    private InstantiationTree<V> parent;

    public InstantiationTree() {
        this.parent = null;
        this.data = null;
    }

    private InstantiationTree(InstantiationTree<V> parent) {
        this.parent = parent;
        this.data = null;
    }

    public V getData() {
        return this.data;
    }

    public void setData(V data) {
        this.data = data;
    }

    public void storeInstance(InstantiationPath instantiationPath, V instance) {
        this.storeInstanceImpl(instantiationPath, 0, instance);
    }

    private void storeInstanceImpl(InstantiationPath instantiationPath, int index, V instance) {
        if (index == instantiationPath.size()) {
            this.data = instance;
        } else {
            NamedElement key = (NamedElement)instantiationPath.get(index);
            InstantiationTree<V> node = (InstantiationTree<V>)this.get(key);
            if (node == null) {
                node = new InstantiationTree<V>(this);
                this.put(key, node);
            }
            super.storeInstanceImpl(instantiationPath, index + 1, instance);
        }
    }

    public V lookupInstance(InstantiationPath instantiationPath) {
        InstantiationTree<V> node = this.lookupNode(instantiationPath, 0);
        if (node == null) {
            return null;
        }
        return node.data;
    }

    private InstantiationTree<V> lookupNode(InstantiationPath instantiationPath, int index) {
        if (instantiationPath == null || index >= instantiationPath.size()) {
            return this;
        }
        NamedElement key = (NamedElement)instantiationPath.get(index);
        InstantiationTree node = (InstantiationTree)this.get(key);
        if (node == null) {
            return null;
        }
        return node.lookupNode(instantiationPath, index + 1);
    }

    public V lookupInstance(String qualifiedPath, String separator) {
        String[] subs = qualifiedPath.split(separator);
        InstantiationTree<V> node = this.lookupNode(subs, 0);
        if (node == null) {
            return null;
        }
        return node.data;
    }

    private InstantiationTree<V> lookupNode(String[] subs, int index) {
        if (subs == null || index >= subs.length) {
            return this;
        }
        String keyName = subs[index];
        InstantiationTree<V> node = this.findSubNodeByName(keyName);
        if (node == null) {
            return null;
        }
        return super.lookupNode(subs, index + 1);
    }

    private InstantiationTree<V> findSubNodeByName(String name) {
        Set entries = this.entrySet();
        for (Map.Entry entry : entries) {
            if (((NamedElement)entry.getKey()).getName().compareTo(name) != 0) continue;
            return (InstantiationTree)entry.getValue();
        }
        return null;
    }

    public V lookupInstance(String qualifiedPath) {
        return this.lookupInstance(qualifiedPath, "::");
    }

    public V lookupInstance(InstantiationPath path, int depth) {
        InstantiationTree<V> node = this.lookupNode(path, 0, depth);
        if (node == null) {
            return null;
        }
        return node.data;
    }

    private InstantiationTree<V> lookupNode(InstantiationPath path, int index, int depth) {
        if (path == null || index >= path.size() || depth == 0) {
            return this;
        }
        NamedElement key = (NamedElement)path.get(index);
        InstantiationTree node = (InstantiationTree)this.get(key);
        if (node == null) {
            return null;
        }
        return node.lookupNode(path, index + 1, depth - 1);
    }

    public List<V> lookupInstances(InstantiationPath instantiationPath) {
        InstantiationTree<V> node = this.lookupNode(instantiationPath, 0);
        if (node == null) {
            return new ArrayList();
        }
        return super.collectInSubTree();
    }

    private List<V> collectInSubTree() {
        ArrayList<V> res = new ArrayList<V>();
        if (this.data != null) {
            res.add(this.data);
        }
        for (InstantiationTree node : this.values()) {
            res.addAll(node.collectInSubTree());
        }
        return res;
    }

    public List<V> lookupInstances(InstantiationPath instantiationPath, int depth) {
        InstantiationTree<V> node = this.lookupNode(instantiationPath, 0);
        if (node == null) {
            return new ArrayList();
        }
        return super.collectInSubTree(depth);
    }

    private List<V> collectInSubTree(int depth) {
        ArrayList<V> res = new ArrayList<V>();
        if (this.data != null) {
            res.add(this.data);
        }
        if (depth > 0) {
            for (InstantiationTree node : this.values()) {
                res.addAll(node.collectInSubTree(depth - 1));
            }
        }
        return res;
    }

    public List<V> getParentList(V nodeData) {
        ArrayList<V> res = new ArrayList<V>();
        InstantiationTree<V> tree = this.searchNode(nodeData);
        while (tree != null) {
            if (tree.data != null && tree.data != nodeData) {
                res.add(tree.data);
            }
            tree = tree.parent;
        }
        return res;
    }

    private InstantiationTree<V> searchNode(V nodeData) {
        if (this.data != null && this.data == nodeData) {
            return this;
        }
        for (InstantiationTree node : this.values()) {
            InstantiationTree<V> res = node.searchNode(nodeData);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public InstantiationTree<V> mergeWith(InstantiationTree<V> other) throws InstantiationTreeMergeConflict {
        if (other.data != null) {
            if (this.data == null) {
                this.data = other.data;
            } else if (this.data != other.data) {
                throw new InstantiationTreeMergeConflict();
            }
        }
        for (Map.Entry entry : other.entrySet()) {
            NamedElement key = (NamedElement)entry.getKey();
            InstantiationTree subTree = (InstantiationTree)entry.getValue();
            if (this.containsKey(key)) {
                ((InstantiationTree)this.get(key)).mergeWith(subTree);
                continue;
            }
            InstantiationTree<V> newTree = new InstantiationTree<V>(this);
            this.put(key, newTree.mergeWith(subTree));
        }
        return this;
    }
}

