/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ui.hover;

import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecoretools.ale.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.Unit;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.validation.QualifiedNames;
import org.eclipse.emf.ecoretools.ale.ide.project.IAleProject;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;
import org.eclipse.xtext.ui.editor.hover.html.XtextBrowserInformationControlInput;

public class AleHoverProvider
extends DefaultEObjectHoverProvider {
    protected XtextBrowserInformationControlInput getHoverInfo(EObject obj, IRegion region, XtextBrowserInformationControlInput prev) {
        String html;
        if (obj instanceof Keyword && (html = this.getHoverInfoAsHtml(obj)) != null) {
            StringBuffer buffer = new StringBuffer(html);
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)this.getStyleSheet());
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            return new XtextBrowserInformationControlInput(prev, obj, buffer.toString(), this.getLabelProvider());
        }
        return super.getHoverInfo(obj, region, prev);
    }

    protected String getHoverInfoAsHtml(EObject hovered) {
        if (hovered instanceof Keyword) {
            return AleHoverProvider.hoverText((Keyword)hovered);
        }
        if (hovered instanceof ExtendedClass) {
            ExtendedClass extendedClass = (ExtendedClass)hovered;
            IFile aleFile = WorkspaceSynchronizer.getFile((Resource)hovered.eResource());
            IAleEnvironment environment = IAleProject.from((IProject)aleFile.getProject()).getEnvironment();
            return environment.getBehaviors().findClass(extendedClass.getName()).filter(org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass.class::isInstance).map(org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass.class::cast).map(cls -> AleHoverProvider.hoverText(environment, cls)).orElse("unresolved class");
        }
        if (hovered instanceof Unit) {
            Unit unit = (Unit)hovered;
            IFile aleFile = WorkspaceSynchronizer.getFile((Resource)hovered.eResource());
            IAleEnvironment environment = IAleProject.from((IProject)aleFile.getProject()).getEnvironment();
            return AleHoverProvider.hoverText(environment, unit);
        }
        return super.getHoverInfoAsHtml(hovered);
    }

    private static String hoverText(Keyword keyword) {
        if (keyword.getValue().equals("open")) {
            return "Opens a class already defined in an Ecore model to add new attributes or methods";
        }
        if (keyword.getValue().equals("behavior")) {
            return "Defines a new semantic module. <br/><br/>The name that follows is the name of the new EPackage that will be created to contain the dynamic classes defined with the <code>class</code> keyword.";
        }
        return "";
    }

    private static String hoverText(IAleEnvironment env, org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass cls) {
        if (cls.getBaseClass() == null) {
            return "unresolved class '" + cls.getName() + "'<br/>" + "<br/>" + "The following EPackage are currently registered:<br/>" + env.getMetamodels().stream().map(pkg -> "<li>" + pkg.getName() + " (nsPrefix:" + pkg.getNsPrefix() + ", nsURI: " + pkg.getNsURI() + ")</il>").collect(Collectors.joining("", "<ul>", "</ul>"));
        }
        EClass openClass = cls.getBaseClass();
        EPackage pkg2 = openClass.getEPackage();
        return "<b>Opening:</b> " + QualifiedNames.getQualifiedName((EClassifier)openClass) + "<br/>" + "<br/>" + "<b>EPackage:</b> " + pkg2.getName() + " (nsPrefix:" + pkg2.getNsPrefix() + ", nsURI: " + pkg2.getNsURI() + ")";
    }

    private static String hoverText(IAleEnvironment environment, Unit unit) {
        return "Available EPackages:<br/>" + environment.getMetamodels().stream().map(pkg -> "<li>" + pkg.getName() + " (nsPrefix:" + pkg.getNsPrefix() + ", nsURI: " + pkg.getNsURI() + ")</li>").collect(Collectors.joining("", "<ul>", "</ul>"));
    }
}

