/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.xref.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.contribution.xref.core.IXReferenceProvider;
import org.eclipse.contribution.xref.core.XReferencePlugin;
import org.eclipse.contribution.xref.core.XReferenceProviderDefinition;
import org.eclipse.contribution.xref.core.XReferenceProviderManager$AjcClosure1;
import org.eclipse.contribution.xref.ras.NoFFDC;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class XReferenceProviderManager
implements NoFFDC {
    private static XReferenceProviderManager theManager;
    private List<XReferenceProviderDefinition> providerList;
    private static final String PROVIDERS_EXTENSION_POINT = "org.eclipse.contribution.xref.core.providers";
    private boolean isInplace = false;

    private XReferenceProviderManager() {
    }

    public static XReferenceProviderManager getManager() {
        if (theManager == null) {
            theManager = new XReferenceProviderManager();
        }
        return theManager;
    }

    public void setIsInplace(boolean isInplace) {
        this.isInplace = isInplace;
    }

    public boolean getIsInplace() {
        return this.isInplace;
    }

    public List<IXReferenceProvider> getProvidersFor(IAdaptable o) {
        ArrayList<IXReferenceProvider> providers = new ArrayList<IXReferenceProvider>();
        List<XReferenceProviderDefinition> registeredProviders = this.getRegisteredProviders();
        for (XReferenceProviderDefinition element : registeredProviders) {
            if (!this.providesReferencesFor(o, element)) continue;
            providers.add(element.getProvider());
        }
        return providers;
    }

    public List<XReferenceProviderDefinition> getRegisteredProviders() {
        if (this.providerList == null) {
            this.providerList = new ArrayList<XReferenceProviderDefinition>();
            IExtensionPoint exP = Platform.getExtensionRegistry().getExtensionPoint(PROVIDERS_EXTENSION_POINT);
            IExtension[] exs = exP.getExtensions();
            int i = 0;
            while (i < exs.length) {
                IConfigurationElement[] ces;
                IConfigurationElement[] iConfigurationElementArray = ces = exs[i].getConfigurationElements();
                int n = ces.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement ce = iConfigurationElementArray[n2];
                    try {
                        XReferenceProviderDefinition def = new XReferenceProviderDefinition(ce);
                        this.providerList.add(def);
                    }
                    catch (CoreException e) {
                        Status status = new Status(2, "org.eclipse.contribution.xref.core", 1, "Could not load provider " + ce.getAttribute("id"), (Throwable)e);
                        CoreException toLog = new CoreException((IStatus)status);
                        XReferencePlugin.log(toLog);
                    }
                    ++n2;
                }
                ++i;
            }
        }
        return this.providerList;
    }

    private boolean providesReferencesFor(Object o, XReferenceProviderDefinition element) {
        if (!element.isEnabled()) {
            return false;
        }
        IXReferenceProvider provider = element.getProvider();
        if (provider != null) {
            IXReferenceProvider iXReferenceProvider = provider;
            Object[] objectArray = new Object[]{this, iXReferenceProvider};
            Class[] servedClasses = (Class[])IXReferenceProvider.SafeExecution.aspectOf().ajc$around$org_eclipse_contribution_xref_core_IXReferenceProvider$SafeExecution$1$b538bdbd(new XReferenceProviderManager$AjcClosure1(objectArray));
            if (servedClasses != null) {
                int i = 0;
                while (i < servedClasses.length) {
                    if (servedClasses[i].isInstance(o)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    static final /* synthetic */ Class[] getClasses_aroundBody0(XReferenceProviderManager xReferenceProviderManager, IXReferenceProvider iXReferenceProvider) {
        return iXReferenceProvider.getClasses();
    }
}

