/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver.expression;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.BooleanElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.PrimitiveElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.BooleanExpression;
import fr.inria.aoste.timesquare.ccslkernel.runtime.AbstractConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.SerializedConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.EvaluationTypeError;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.solver.ClassicalExpressionEvaluator;
import fr.inria.aoste.timesquare.ccslkernel.solver.ConditionalCase;
import fr.inria.aoste.timesquare.ccslkernel.solver.ISolverConcrete;
import fr.inria.aoste.timesquare.ccslkernel.solver.ImplicitClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.SolverElement;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.SolverClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.expression.RecursiveTailCallJump;
import fr.inria.aoste.timesquare.ccslkernel.solver.expression.SolverExpression;
import java.util.ArrayList;
import java.util.List;

public class ConditionalExpression
extends SolverExpression {
    private List<ISolverConcrete> concretes = new ArrayList<ISolverConcrete>();
    private List<ImplicitClock> implicitClocks = new ArrayList<ImplicitClock>();
    private List<ConditionalCase> cases = new ArrayList<ConditionalCase>();
    private ImplicitClock defaultRootClock;
    private List<ISolverConcrete> defaultCase = new ArrayList<ISolverConcrete>();
    private List<ImplicitClock> defaultCaseClocks = new ArrayList<ImplicitClock>();
    private ConditionalCase selectedCase;
    private ConditionalCase previousCase;
    private boolean goDefault = true;

    public List<ISolverConcrete> getConcretes() {
        return this.concretes;
    }

    public List<ImplicitClock> getImplicitClocks() {
        return this.implicitClocks;
    }

    public List<ConditionalCase> getCases() {
        return this.cases;
    }

    public ImplicitClock getDefaultRootClock() {
        return this.defaultRootClock;
    }

    public void setDefaultRootClock(ImplicitClock defaultRootClock) {
        this.defaultRootClock = defaultRootClock;
    }

    public List<ISolverConcrete> getDefaultCase() {
        return this.defaultCase;
    }

    public List<ImplicitClock> getDefaultCaseClocks() {
        return this.defaultCaseClocks;
    }

    @Override
    public void start(AbstractSemanticHelper helper) throws SimulationException {
        if (traceStart) {
            System.out.println("Entry: ConditionalExpression.start(" + this.toString() + ")");
        }
        if (!this.canCallStart()) {
            return;
        }
        super.start(helper);
        this.goDefault = true;
        this.selectedCase = null;
        for (ConditionalCase relationCase : this.getCases()) {
            BooleanExpression condition = relationCase.getCondition();
            ClassicalExpressionEvaluator eval = new ClassicalExpressionEvaluator(this.getAbstractMapping());
            SolverElement test = eval.evaluate((PrimitiveElement)condition);
            if (!(test.getModelElement() instanceof BooleanElement)) {
                throw new EvaluationTypeError("ConditionalExpression.start(): BooleanElement expected");
            }
            if (!((BooleanElement)test.getModelElement()).getValue().booleanValue()) continue;
            this.selectedCase = relationCase;
            this.goDefault = false;
            break;
        }
        for (ISolverConcrete concrete : this.selectedCase.getConcretes()) {
            if (concrete instanceof RecursiveTailCallJump) continue;
            if (concrete instanceof SolverExpression) {
                ((SolverExpression)concrete).getImplicitClock().start(helper);
                continue;
            }
            concrete.start(helper);
        }
        for (ISolverConcrete concrete : this.concretes) {
            if (concrete instanceof RecursiveTailCallJump) continue;
            if (concrete instanceof SolverExpression) {
                ((SolverExpression)concrete).getImplicitClock().start(helper);
                continue;
            }
            concrete.start(helper);
        }
        if (this.getImplicitClock().isDead()) {
            for (ISolverConcrete concrete : this.concretes) {
                if (!(concrete instanceof RecursiveTailCallJump)) continue;
                ((RecursiveTailCallJump)concrete).reset(helper);
            }
        }
        this.previousCase = this.selectedCase;
        if (traceStart) {
            System.out.println("Exit: ConditionalExpression.start(" + this.toString() + ")");
        }
    }

    @Override
    public void semantic(AbstractSemanticHelper semanticHelper) throws SimulationException {
        if (!this.canCallSemantic()) {
            return;
        }
        super.semantic(semanticHelper);
        if (traceSemantic) {
            System.out.println("Entry: ConditionalExpression.semantic(" + this.toString() + ")");
        }
        if (!this.isActiveState() && this.state != AbstractConstraint.State.DEAD) {
            if (traceSemantic) {
                System.out.println("Exit: ConditionalExpression.semantic(" + this.toString() + ") neither active nor dead");
            }
            return;
        }
        if (this.state == AbstractConstraint.State.DEAD) {
            semanticHelper.semanticBDDAnd(semanticHelper.createNot((RuntimeClock)this.getImplicitClock()));
            semanticHelper.registerClockUse((RuntimeClock)this.getImplicitClock());
        }
        this.goDefault = true;
        this.selectedCase = null;
        for (ConditionalCase relationCase : this.getCases()) {
            BooleanExpression condition = relationCase.getCondition();
            ClassicalExpressionEvaluator eval = new ClassicalExpressionEvaluator(this.getAbstractMapping());
            SolverElement test = eval.evaluate((PrimitiveElement)condition);
            if (!(test.getModelElement() instanceof BooleanElement)) {
                throw new EvaluationTypeError("ConditionalExpression.semantic(): BooleanElement expected");
            }
            if (!((BooleanElement)test.getModelElement()).getValue().booleanValue()) continue;
            this.selectedCase = relationCase;
            this.goDefault = false;
            break;
        }
        if (this.selectedCase != null) {
            for (ConditionalCase relationCase : this.getCases()) {
                if (relationCase == this.selectedCase) {
                    if (this.previousCase != this.selectedCase) {
                        for (ISolverConcrete conc : relationCase.getConcretes()) {
                            if (conc instanceof SolverExpression) {
                                ((SolverExpression)conc).getImplicitClock().start(semanticHelper);
                                continue;
                            }
                            conc.start(semanticHelper);
                        }
                    }
                    for (ISolverConcrete conc : relationCase.getConcretes()) {
                        conc.semantic(semanticHelper);
                    }
                    semanticHelper.semanticBDDAnd(semanticHelper.createEqual((RuntimeClock)this.getImplicitClock(), (RuntimeClock)this.selectedCase.getRootClock()));
                    semanticHelper.registerClockUse((RuntimeClock[])new SolverClock[]{this.getImplicitClock(), this.selectedCase.getRootClock()});
                    continue;
                }
                for (ISolverConcrete conc : relationCase.getConcretes()) {
                    conc.terminate(semanticHelper.getUpdateHelper());
                }
            }
            this.previousCase = this.selectedCase;
        } else if (this.goDefault) {
            for (ISolverConcrete conc : this.getDefaultCase()) {
                if (conc instanceof SolverExpression) {
                    ((SolverExpression)conc).getImplicitClock().start(semanticHelper);
                } else {
                    conc.start(semanticHelper);
                }
                conc.semantic(semanticHelper);
            }
            semanticHelper.semanticBDDAnd(semanticHelper.createEqual((RuntimeClock)this.getImplicitClock(), (RuntimeClock)this.defaultRootClock));
            semanticHelper.registerClockUse((RuntimeClock[])new SolverClock[]{this.getImplicitClock(), this.getDefaultRootClock()});
        }
        semanticHelper.registerClockUse((RuntimeClock)this.getImplicitClock());
        if (traceSemantic) {
            System.out.println("Exit: ConditionalExpression.semantic(" + this.toString() + ")");
        }
    }

    @Override
    public void deathSemantic(AbstractSemanticHelper semanticHelper) throws SimulationException {
        if (!this.isActiveState() && this.state != AbstractConstraint.State.DEAD) {
            return;
        }
        if (this.state == AbstractConstraint.State.DEAD) {
            semanticHelper.forceDeath((RuntimeClock)this.getImplicitClock());
        }
        if (this.selectedCase != null) {
            for (ISolverConcrete conc : this.selectedCase.getConcretes()) {
                conc.deathSemantic(semanticHelper);
            }
            semanticHelper.registerDeathEquality((RuntimeClock)this.getImplicitClock(), (RuntimeClock)this.selectedCase.getRootClock());
        } else if (this.goDefault) {
            for (ISolverConcrete conc : this.getDefaultCase()) {
                conc.deathSemantic(semanticHelper);
            }
            semanticHelper.registerDeathEquality((RuntimeClock)this.getImplicitClock(), (RuntimeClock)this.getDefaultRootClock());
        }
    }

    @Override
    public void update(AbstractUpdateHelper helper) throws SimulationException {
        if (traceUpdate) {
            System.out.println("Entry: ConditionalExpression.update(" + this.toString() + ")");
        }
        if (!this.canCallUpdate()) {
            return;
        }
        super.update(helper);
        if (!this.isActiveState()) {
            if (traceUpdate) {
                System.out.println("Exit: ConditionalExpression.update(" + this.toString() + ") not active");
            }
            return;
        }
        if (this.selectedCase == null) {
            if (this.goDefault) {
                for (ISolverConcrete conc : this.getDefaultCase()) {
                    conc.update(helper);
                }
                if (this.getDefaultRootClock().isDead()) {
                    this.terminate(helper);
                }
            }
        } else {
            for (ISolverConcrete conc : this.selectedCase.getConcretes()) {
                conc.update(helper);
            }
            if (this.selectedCase.getRootClock().isDead()) {
                this.terminate(helper);
            }
        }
        if (traceUpdate) {
            System.out.println("Exit: ConditionalExpression.update(" + this.toString() + ")");
        }
    }

    @Override
    public void terminate(AbstractUpdateHelper helper) throws SimulationException {
        super.terminate(helper);
        for (ConditionalCase relationCase : this.getCases()) {
            for (ISolverConcrete conc : relationCase.getConcretes()) {
                conc.terminate(helper);
            }
        }
        for (ISolverConcrete conc : this.getDefaultCase()) {
            conc.terminate(helper);
        }
    }

    public String toString() {
        String res = "[" + this.getImplicitClock().getName() + "]" + (this.isActiveState() ? "*" : "");
        res = String.valueOf(res) + "Conditional(";
        for (ConditionalCase alternative : this.getCases()) {
            if (alternative == this.selectedCase) {
                res = String.valueOf(res) + "^";
            }
            if (alternative.getCondition() != null) {
                res = String.valueOf(res) + "if ";
                res = String.valueOf(res) + alternative.getCondition().eClass().getName() + " then ";
            } else {
                res = String.valueOf(res) + " else ";
            }
            res = String.valueOf(res) + alternative.getConcretes().get(0);
            res = String.valueOf(res) + ";";
        }
        res = String.valueOf(res) + ")";
        if (this.state == AbstractConstraint.State.DEAD) {
            res = String.valueOf(res) + "/D";
        }
        return res;
    }

    @Override
    public SerializedConstraintState dumpState() {
        SerializedConstraintState currentState = super.dumpState();
        int selectedCaseIndex = this.cases.indexOf(this.selectedCase);
        currentState.dump((Object)selectedCaseIndex);
        return currentState;
    }

    @Override
    public void restoreState(SerializedConstraintState newState) {
        super.restoreState(newState);
        this.selectedCase = this.cases.get((Integer)newState.restore(2));
    }
}

