/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.engine;

import com.google.inject.Injector;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.Clock;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.Reference;
import fr.inria.aoste.trace.TraceFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons.MoccmlExecutionPlatform;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons.MoccmlModelExecutionContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.concurrentmse.FeedbackMSE;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse.ASynchroneExecution;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse.DefaultMSEStateController;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse.OperationExecution;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse.SynchroneExecution;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.engine.AbstractSolverCodeExecutorConcurrentEngine;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.engine.JavaVariable;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IMoccmlRunConfiguration;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dsa.executors.CodeExecutionException;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dse.IMoccmlFutureAction;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dse.IMoccmlMSEStateController;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.moc.ICCSLSolver;
import org.eclipse.gemoc.execution.moccml.testscenariolang.model.TestScenarioLang.EObjectRef;
import org.eclipse.gemoc.execution.moccml.testscenariolang.model.TestScenarioLang.IntegerLiteral;
import org.eclipse.gemoc.execution.moccml.testscenariolang.model.TestScenarioLang.MseStatement;
import org.eclipse.gemoc.execution.moccml.testscenariolang.model.TestScenarioLang.ObjectVariable;
import org.eclipse.gemoc.execution.moccml.testscenariolang.model.TestScenarioLang.RewritingRuleCallStatement;
import org.eclipse.gemoc.execution.moccml.testscenariolang.model.TestScenarioLang.Scenario;
import org.eclipse.gemoc.execution.moccml.testscenariolang.model.TestScenarioLang.Statement;
import org.eclipse.gemoc.execution.moccml.testscenariolang.model.TestScenarioLang.Variable;
import org.eclipse.gemoc.execution.moccml.testscenariolang.xtext.ui.internal.TestScenarioLangActivator;
import org.eclipse.gemoc.executionframework.engine.Activator;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.ActionModel;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.ModelSpecificEvent;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.When;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericSmallStep;
import org.eclipse.gemoc.trace.commons.model.trace.MSE;
import org.eclipse.gemoc.trace.commons.model.trace.SmallStep;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionContext;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.resource.XtextResourceSetProvider;

public class MoccmlExecutionEngine
extends AbstractSolverCodeExecutorConcurrentEngine<MoccmlModelExecutionContext, IMoccmlRunConfiguration, ICCSLSolver> {
    private ArrayList<IMoccmlFutureAction> _futureActions = new ArrayList();
    private Object _futureActionsLock = new Object();
    private IMoccmlMSEStateController _mseStateController;
    private Scenario moccmlScenario = null;
    private EList<Statement> scenarioStatementSequence;
    private int indexInScenarioStatementSequence;
    private HashSet<Clock> clockUsedInScenario;

    public MoccmlExecutionEngine(MoccmlModelExecutionContext concurrentexecutionContext, ICCSLSolver s) throws CoreException {
        this.setSolver(s);
        this.initialize((IExecutionContext)concurrentexecutionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFutureAction(IMoccmlFutureAction action) {
        Object object = this._futureActionsLock;
        synchronized (object) {
            this._futureActions.add(action);
        }
    }

    public String engineKindName() {
        return "GEMOC Moccml Engine";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAssociatedActions(MSE mse) {
        Object object = this._futureActionsLock;
        synchronized (object) {
            ArrayList<IMoccmlFutureAction> actionsToRemove = new ArrayList<IMoccmlFutureAction>();
            for (IMoccmlFutureAction action : this._futureActions) {
                if (((ModelSpecificEvent)this._mseStateController.getFeedBackModelResource().getEObject(action.getTriggeringMSEURI())).getName().compareTo(mse.getName()) != 0) continue;
                actionsToRemove.add(action);
                action.perform(this._mseStateController);
            }
            this._futureActions.removeAll(actionsToRemove);
        }
    }

    protected void executeSmallStep(SmallStep<?> smallStep) throws CodeExecutionException {
        this.executeAssociatedActions(smallStep.getMseoccurrence().getMse());
        MSE mse = smallStep.getMseoccurrence().getMse();
        if (mse.getAction() != null) {
            ArrayList<When> whenStatements = new ArrayList<When>();
            if (mse instanceof FeedbackMSE) {
                ActionModel feedbackModel = ((MoccmlModelExecutionContext)this._executionContext).getFeedbackModel();
                for (When w : feedbackModel.getWhenStatements()) {
                    if (w.getSource() != ((FeedbackMSE)mse).getFeedbackModelSpecificEvent()) continue;
                    whenStatements.add(w);
                }
            }
            OperationExecution execution = null;
            Consumer<Step<?>> beforeStep = s -> this.beforeExecutionStep((Step)s);
            Consumer<List<Object>> afterStep = o -> this.afterExecutionStep((List)o);
            execution = whenStatements.size() == 0 ? new SynchroneExecution(smallStep, this, beforeStep, afterStep) : new ASynchroneExecution(smallStep, whenStatements, this._mseStateController, this, beforeStep, afterStep);
            ((OperationExecution)execution).run();
        }
    }

    protected void performExecutionStep() {
        this.switchDeciderIfNecessary();
        this._possibleLogicalSteps = this.computePossibleLogicalSteps();
        if (this._possibleLogicalSteps.size() == 0) {
            Activator.getDefault().debug("No more LogicalStep to run");
        } else {
            if (this.moccmlScenario != null) {
                this.applyScenarioEffect();
            }
            try {
                Step selectedLogicalStep = this.selectAndExecuteLogicalStep();
                if (selectedLogicalStep != null) {
                    this.doAfterLogicalStepExecution(selectedLogicalStep);
                    this.engineStatus.incrementNbLogicalStepRun();
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    private void applyScenarioEffect() {
        Statement currentScenarioStatement = (Statement)this.scenarioStatementSequence.get(this.indexInScenarioStatementSequence);
        this.dealWithRwRCallStatement(currentScenarioStatement);
        if (currentScenarioStatement instanceof MseStatement) {
            EventOccurrence occ;
            HashSet<Clock> clockToForceAbsent = new HashSet<Clock>(this.clockUsedInScenario);
            EList statementClocks = ((MseStatement)currentScenarioStatement).getClocks();
            for (Clock toRemove : statementClocks) {
                clockToForceAbsent.remove(toRemove);
            }
            for (Clock c : clockToForceAbsent) {
                occ = this.getEventOccurrenceFromClock(c);
                ((ICCSLSolver)this._solver).forbidEventOccurrence(occ);
            }
            if (statementClocks.size() > 1) {
                Clock oneClock = (Clock)statementClocks.get(0);
                EventOccurrence oneClockOcc = this.getEventOccurrenceFromClock(oneClock);
                int i = 1;
                while (i < statementClocks.size()) {
                    EventOccurrence anotherClockOcc = this.getEventOccurrenceFromClock((Clock)statementClocks.get(i));
                    ((ICCSLSolver)this._solver).addClockCoincidence(oneClockOcc, anotherClockOcc);
                    ++i;
                }
            }
            this._possibleLogicalSteps = this.computePossibleLogicalSteps();
            if (!((ICCSLSolver)this._solver).hasSolution()) {
                Activator.getDefault().error("The scenario violates the semantics at step " + this.indexInScenarioStatementSequence + ". One of these clock cannot be absent: " + clockToForceAbsent);
            }
            for (Clock toForce : statementClocks) {
                occ = this.getEventOccurrenceFromClock(toForce);
                ((ICCSLSolver)this._solver).forceEventOccurrence(occ);
            }
            if (!((ICCSLSolver)this._solver).hasSolution()) {
                ((ICCSLSolver)this._solver).revertForceClockEffect();
                for (Clock c : clockToForceAbsent) {
                    occ = this.getEventOccurrenceFromClock(c);
                    ((ICCSLSolver)this._solver).forbidEventOccurrence(occ);
                }
            }
            this._possibleLogicalSteps = this.computePossibleLogicalSteps();
            this.notifyProposedLogicalStepsChanged();
        }
    }

    private EventOccurrence getEventOccurrenceFromClock(Clock c) {
        EventOccurrence occ = TraceFactory.eINSTANCE.createEventOccurrence();
        ModelElementReference mer = TraceFactory.eINSTANCE.createModelElementReference();
        mer.getElementRef().add((Object)c.eContainer().eContainer());
        mer.getElementRef().add((Object)c.eContainer());
        mer.getElementRef().add((Object)c);
        occ.setReferedElement((Reference)mer);
        return occ;
    }

    public void recomputePossibleLogicalSteps() {
        ((ICCSLSolver)this.getSolver()).revertForceClockEffect();
        this.updatePossibleLogicalSteps();
        this.notifyProposedLogicalStepsChanged();
    }

    @Override
    protected void beforeUpdatePossibleLogicalSteps() {
        for (IMoccmlMSEStateController c : ((MoccmlExecutionPlatform)((MoccmlModelExecutionContext)this.getExecutionContext()).getExecutionPlatform()).getMSEStateControllers()) {
            c.applyMSEFutureStates(this.getSolver());
        }
    }

    protected void performSpecificInitialize(MoccmlModelExecutionContext executionContext) {
        MoccmlModelExecutionContext concurrentExecutionContext = (MoccmlModelExecutionContext)this.getExecutionContext();
        ((ICCSLSolver)this.getSolver()).setExecutableModelResource(concurrentExecutionContext.getResourceModel());
        this._mseStateController = new DefaultMSEStateController();
        ((MoccmlExecutionPlatform)concurrentExecutionContext.getExecutionPlatform()).getMSEStateControllers().add(this._mseStateController);
        this.executeInitializeModelMethod(executionContext);
        executionContext.setUpMSEModel();
        Resource resFeedbackModel = executionContext.setUpFeedbackModel();
        this._mseStateController.setFeedBackModelResource(resFeedbackModel);
        if (executionContext.hasARegisteredScenario) {
            this.moccmlScenario = this.loadTestScenarioLangification(concurrentExecutionContext.getMoccmlscenarioModelPath());
            this.scenarioStatementSequence = this.moccmlScenario.getStatementSequence();
            this.indexInScenarioStatementSequence = 0;
            this.clockUsedInScenario = new HashSet();
            for (Statement s2 : this.moccmlScenario.getStatementSequence().stream().filter(s -> s instanceof MseStatement).collect(Collectors.toList())) {
                this.clockUsedInScenario.addAll((Collection<Clock>)((MseStatement)s2).getClocks());
            }
        }
    }

    private Scenario loadTestScenarioLangification(String filename) {
        if (filename == null || filename.isEmpty()) {
            return null;
        }
        String language = "org.eclipse.gemoc.execution.moccml.testscenariolang.xtext.TestScenarioLang";
        Injector injector = TestScenarioLangActivator.getInstance().getInjector(language);
        XtextResourceSetProvider provider = (XtextResourceSetProvider)injector.getInstance(XtextResourceSetProvider.class);
        XtextResourceSet resourceSet = (XtextResourceSet)provider.get(this.findContainingProject(filename));
        resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        URI uri = URI.createPlatformResourceURI((String)filename, (boolean)true);
        XtextResource resource = (XtextResource)resourceSet.getResource(uri, true);
        EList errors = resource.getErrors();
        if (!errors.isEmpty()) {
            System.err.println("the moccml scenrio file contains errors: " + errors);
            return null;
        }
        return (Scenario)resource.getContents().get(0);
    }

    private IProject findContainingProject(String filename) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IPath path = root.getLocation();
        path = path.append((IPath)new Path(filename));
        IFile file = (IFile)root.findMember(filename);
        return file != null ? file.getProject() : null;
    }

    protected void doAfterLogicalStepExecution(Step<?> logicalStep) {
        ((ICCSLSolver)this.getSolver()).applyLogicalStep(logicalStep);
        List assertions = ((ICCSLSolver)this.getSolver()).getAssertionViolations();
        if (assertions.size() > 0) {
            System.err.println("###############################################\n  WARNING ! Assertion violation");
            Activator.getDefault().error("###############################################\n  WARNING ! Assertion violation");
        }
        for (String ass : assertions) {
            System.err.println("#    " + ass);
            Activator.getDefault().error("#    " + ass);
        }
        if (assertions.size() > 0) {
            System.err.println("###############################################");
            Activator.getDefault().error("###############################################");
        }
        if (this.moccmlScenario != null) {
            this.manageScenario(logicalStep);
        }
    }

    private void manageScenario(Step<?> logicalStep) {
        Statement currentScenarioStatement = (Statement)this.scenarioStatementSequence.get(this.indexInScenarioStatementSequence);
        if (currentScenarioStatement instanceof MseStatement) {
            ArrayList<Clock> clocksThatTicked = new ArrayList<Clock>();
            this.retrieveAllClocksFromStep(logicalStep, clocksThatTicked);
            if (((MseStatement)currentScenarioStatement).getClocks().stream().allMatch(c -> clocksThatTicked.stream().anyMatch(c2 -> c2.getName().compareTo(c.getName()) == 0))) {
                ++this.indexInScenarioStatementSequence;
                currentScenarioStatement = (Statement)this.scenarioStatementSequence.get(this.indexInScenarioStatementSequence);
                this.dealWithRwRCallStatement(currentScenarioStatement);
            }
        }
    }

    private void dealWithRwRCallStatement(Statement currentScenarioStatement) {
        while (!(currentScenarioStatement instanceof MseStatement)) {
            RewritingRuleCallStatement rwrcallStatement = (RewritingRuleCallStatement)currentScenarioStatement;
            ObjectVariable ov = rwrcallStatement.getObjectVariable();
            JavaVariable javaVar = new JavaVariable(ov.getName(), ov.getType().getType().getQualifiedName());
            Object obj = javaVar.getObject();
            JvmOperation jvmOp = rwrcallStatement.getMethod();
            EList params = rwrcallStatement.getParameters();
            Object[] realParams = new Object[params.size()];
            Class[] realParamTypes = new Class[params.size()];
            int i = 0;
            while (i < params.size()) {
                Variable v = (Variable)params.get(i);
                if (v instanceof EObjectRef) {
                    realParams[i] = ((EObjectRef)v).getObject();
                    realParamTypes[i] = EObject.class;
                }
                if (v instanceof IntegerLiteral) {
                    realParams[i] = new Integer(((IntegerLiteral)v).getValue());
                    realParamTypes[i] = Integer.class;
                }
                ++i;
            }
            try {
                Method m = obj.getClass().getDeclaredMethod(jvmOp.getSimpleName(), realParamTypes);
                Object res = m.invoke(obj, realParams);
                System.out.println(res);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
            ++this.indexInScenarioStatementSequence;
            currentScenarioStatement = (Statement)this.scenarioStatementSequence.get(this.indexInScenarioStatementSequence);
        }
    }

    private void retrieveAllClocksFromStep(Step<?> logicalStep, ArrayList<Clock> clocksThatTicked) {
        TreeIterator it = logicalStep.eAllContents();
        while (it.hasNext()) {
            EObject se;
            MSE mse;
            EObject eo = (EObject)it.next();
            if (!(eo instanceof GenericSmallStep) || !((mse = ((GenericSmallStep)eo).getMseoccurrence().getMse()) instanceof FeedbackMSE) || !((se = ((FeedbackMSE)mse).getFeedbackModelSpecificEvent().getSolverEvent()) instanceof Clock)) continue;
            clocksThatTicked.add((Clock)se);
        }
    }

    public Pair<Map<String, Boolean>, ArrayList<IMoccmlFutureAction>> saveState() {
        return Pair.of(new HashMap<String, Boolean>(((DefaultMSEStateController)((MoccmlExecutionPlatform)((MoccmlModelExecutionContext)this.getExecutionContext()).getExecutionPlatform()).getMSEStateControllers().iterator().next())._mseNextStates), new ArrayList<IMoccmlFutureAction>(this._futureActions));
    }

    public void restoreState(Pair<Map<String, Boolean>, ArrayList<IMoccmlFutureAction>> controllerStates) {
        ((DefaultMSEStateController)this._mseStateController)._mseNextStates = new HashMap<String, Boolean>((Map)controllerStates.getLeft());
        this._futureActions = new ArrayList((Collection)controllerStates.getRight());
    }
}

