/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.melange.ui.wizards;

import fr.inria.diverse.melange.ui.MelangeUiModule;
import fr.inria.diverse.melange.ui.internal.MelangeActivator;
import fr.inria.diverse.melange.ui.wizards.MelangeFilesTemplates;
import fr.inria.diverse.melange.ui.wizards.pages.NewMelangeProjectWizardFields;
import fr.inria.diverse.melange.ui.wizards.pages.NewMelangeProjectWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gemoc.commons.eclipse.core.resources.IFileUtils;
import org.eclipse.gemoc.commons.eclipse.core.resources.IFolderUtils;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.AbstractNewProjectWizardWithTemplates;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.BaseProjectWizardFields;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.IProjectContentWizard;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.ProjectTemplateApplicationOperation;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewMelangeProjectWizard
extends AbstractNewProjectWizardWithTemplates
implements INewWizard {
    protected NewMelangeProjectWizardFields context = new NewMelangeProjectWizardFields();
    protected NewMelangeProjectWizardPage projectPage;

    public void addPages() {
        this.projectPage = new NewMelangeProjectWizardPage(this.context);
        this.addPage((IWizardPage)this.projectPage);
        this.addPage((IWizardPage)this.getTemplateListSelectionPage(this.context));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            final IProjectDescription description = workspace.newProjectDescription(this.context.projectName);
            if (!this.context.projectLocation.equals(workspace.getRoot().getLocation().toOSString())) {
                description.setLocation((IPath)new Path(this.context.projectLocation));
            }
            final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.context.projectName);
            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    project.create(description, monitor);
                    project.open(monitor);
                    NewMelangeProjectWizard.this.addNaturesToProject(project);
                    NewMelangeProjectWizard.this.configureProject(project, monitor);
                    project.refreshLocal(2, monitor);
                    IProjectContentWizard contentWizard = NewMelangeProjectWizard.this.templateSelectionPage.getSelectedWizard();
                    try {
                        NewMelangeProjectWizard.this.getContainer().run(false, true, (IRunnableWithProgress)new ProjectTemplateApplicationOperation((BaseProjectWizardFields)NewMelangeProjectWizard.this.context, project, contentWizard));
                    }
                    catch (InvocationTargetException e) {
                        MelangeUiModule.logErrorMessage(e.getMessage(), e);
                    }
                    catch (InterruptedException e) {
                        MelangeUiModule.logErrorMessage(e.getMessage(), e);
                    }
                    project.refreshLocal(2, monitor);
                }
            };
            ResourcesPlugin.getWorkspace().run(operation, null);
        }
        catch (Exception exception) {
            MelangeUiModule.logErrorMessage(exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    public boolean isHelpAvailable() {
        return true;
    }

    public void addNaturesToProject(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            if (!description.hasNature("org.eclipse.jdt.core.javanature")) {
                NewMelangeProjectWizard.addNature(description, "org.eclipse.jdt.core.javanature");
            }
            if (!description.hasNature("org.eclipse.xtext.ui.shared.xtextNature")) {
                NewMelangeProjectWizard.addNature(description, "org.eclipse.xtext.ui.shared.xtextNature");
            }
            if (!description.hasNature("org.eclipse.pde.PluginNature")) {
                NewMelangeProjectWizard.addNature(description, "org.eclipse.pde.PluginNature");
            }
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            MelangeUiModule.logErrorMessage(e.getMessage(), e);
        }
    }

    public void configureProject(IProject project, IProgressMonitor monitor) {
        try {
            IProjectDescription description = project.getDescription();
            NewMelangeProjectWizard.addNature(description, "org.eclipse.jdt.core.javanature");
            NewMelangeProjectWizard.addNature(description, "org.eclipse.xtext.ui.shared.xtextNature");
            this.createSettingsResourcePrefs(project, monitor);
            IFolderUtils.createFolder((String)"src-gen", (IProject)project, (IProgressMonitor)monitor);
            NewMelangeProjectWizard.addNature(description, "org.eclipse.pde.PluginNature");
            this.createEmptyManifestFile(project, monitor);
            this.updateManifestFile(project, monitor);
            this.createPlugInFile(project, monitor);
            this.createBuildProperties(project, monitor);
            this.setClasspath(project, monitor);
            project.setDescription(description, monitor);
        }
        catch (Exception e) {
            MelangeUiModule.logErrorMessage(e.getMessage(), e);
        }
    }

    private void updateManifestFile(IProject project, IProgressMonitor monitor) {
        try {
            ManifestChanger manifestChanger = new ManifestChanger(project.getFile("META-INF/MANIFEST.MF"));
            manifestChanger.addPluginDependency("org.eclipse.xtend.lib", "2.7.0", false, true);
            manifestChanger.addPluginDependency("org.eclipse.xtext.xbase.lib", "2.7.0", false, true);
            manifestChanger.addPluginDependency("com.google.guava", "0.0.0", false, true);
            manifestChanger.addPluginDependency("org.eclipse.emf.ecore.xmi", "2.8.0", true, true);
            manifestChanger.addPluginDependency("org.eclipse.emf.ecore", "2.8.0", true, true);
            manifestChanger.addPluginDependency("org.eclipse.emf.common", "2.8.0", true, true);
            manifestChanger.addPluginDependency("fr.inria.diverse.melange", "0.1.0", true, true);
            manifestChanger.addPluginDependency("fr.inria.diverse.melange.lib", "0.1.0", true, true);
            manifestChanger.addPluginDependency("fr.inria.diverse.melange.resource", "0.1.0", true, true);
            manifestChanger.addPluginDependency("fr.inria.diverse.melange.adapters", "0.1.0", true, true);
            manifestChanger.addPluginDependency("fr.inria.diverse.k3.al.annotationprocessor.plugin");
            manifestChanger.addAttributes("Bundle-ActivationPolicy", "lazy");
            manifestChanger.commit();
            this.createPlugInFile(project, monitor);
            this.createBuildProperties(project, monitor);
        }
        catch (Exception e) {
            MelangeUiModule.logErrorMessage(e.getMessage(), e);
        }
    }

    public static void addNature(IProjectDescription description, String nature) {
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = nature;
        description.setNatureIds(newNatures);
    }

    private void createEmptyManifestFile(IProject project, IProgressMonitor monitor) throws Exception {
        IFolder metaInf = project.getFolder("META-INF");
        metaInf.create(false, true, monitor);
        String path = "META-INF/MANIFEST.MF";
        IProject currentContainer = project;
        IFile file = currentContainer.getFile((IPath)new Path(path));
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("Manifest-Version: 1.0" + lineSeparator);
        buffer.append("Bundle-ManifestVersion: 2" + lineSeparator);
        buffer.append("Bundle-Name: " + project.getName() + lineSeparator);
        buffer.append("Bundle-SymbolicName: " + project.getName() + "; singleton:=true" + lineSeparator);
        buffer.append("Bundle-Version: 1.0.0" + lineSeparator);
        buffer.append("Bundle-ClassPath: ." + lineSeparator);
        buffer.append("Bundle-RequiredExecutionEnvironment: JavaSE-1.7" + lineSeparator);
        IFileUtils.writeInFile((IFile)file, (String)buffer.toString(), (IProgressMonitor)monitor);
    }

    private void createBuildProperties(IProject project, IProgressMonitor monitor) throws Exception {
        String path = "build.properties";
        IProject currentContainer = project;
        IFile file = currentContainer.getFile((IPath)new Path(path));
        String contents = MelangeFilesTemplates.getBuildProperties();
        IFileUtils.writeInFile((IFile)file, (String)contents, (IProgressMonitor)monitor);
    }

    private void createSettingsResourcePrefs(IProject project, IProgressMonitor monitor) throws Exception {
        IFolder settings = project.getFolder(".settings");
        if (!settings.exists()) {
            settings.create(false, true, monitor);
        }
        String path = ".settings/org.eclipse.core.resources.prefs";
        IProject currentContainer = project;
        IFile file = currentContainer.getFile((IPath)new Path(path));
        String contents = MelangeFilesTemplates.getEclipseResourcePrefs();
        IFileUtils.writeInFile((IFile)file, (String)contents, (IProgressMonitor)monitor);
    }

    private void createPlugInFile(IProject project, IProgressMonitor monitor) throws Exception {
        String path = "/plugin.xml";
        IProject currentContainer = project;
        IFile file = currentContainer.getFile((IPath)new Path(path));
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?eclipse version=\"3.4\"?>\n<plugin>\n</plugin>";
        IFileUtils.writeInFile((IFile)file, (String)contents, (IProgressMonitor)monitor);
    }

    public NewMelangeProjectWizardFields getContext() {
        return this.context;
    }

    public void addNatureToProject(IProject project, Boolean[] tabNature) {
        try {
            IProjectDescription description = project.getDescription();
            if (!tabNature[0].booleanValue() && !description.hasNature("fr.inria.diverse.k3.ui.k3Nature")) {
                NewMelangeProjectWizard.addNature(description, "fr.inria.diverse.k3.ui.k3Nature");
            }
            if (!tabNature[1].booleanValue() && !description.hasNature("org.eclipse.jdt.core.javanature")) {
                NewMelangeProjectWizard.addNature(description, "org.eclipse.jdt.core.javanature");
            }
            if (!tabNature[2].booleanValue() && !description.hasNature("org.eclipse.xtext.ui.shared.xtextNature")) {
                NewMelangeProjectWizard.addNature(description, "org.eclipse.xtext.ui.shared.xtextNature");
            }
            if (!tabNature[3].booleanValue() && !description.hasNature("org.eclipse.pde.PluginNature")) {
                NewMelangeProjectWizard.addNature(description, "org.eclipse.pde.PluginNature");
            }
            if (!tabNature[4].booleanValue() && !description.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                NewMelangeProjectWizard.addNature(description, "org.eclipse.m2e.core.maven2Nature");
            }
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            MelangeUiModule.logErrorMessage(e.getMessage(), e);
        }
    }

    public void setClasspath(IProject project, IProgressMonitor monitor) {
        try {
            IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
            IFolder sourceFolder = project.getFolder("src");
            try {
                sourceFolder.create(true, true, monitor);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ArrayList<IClasspathEntry> newClassPathArrayList = new ArrayList<IClasspathEntry>();
            IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)sourceFolder);
            newClassPathArrayList.add(JavaCore.newSourceEntry((IPath)root.getPath()));
            newClassPathArrayList.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER")));
            newClassPathArrayList.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins")));
            newClassPathArrayList.add(JavaCore.newSourceEntry((IPath)javaProject.getPackageFragmentRoot((IResource)project.getFolder("src-gen")).getPath()));
            IClasspathEntry[] newClassPath = new IClasspathEntry[newClassPathArrayList.size()];
            javaProject.setRawClasspath(newClassPathArrayList.toArray(newClassPath), monitor);
        }
        catch (Exception e) {
            MelangeUiModule.logErrorMessage(e.getMessage(), e);
        }
    }

    public NewMelangeProjectWizardPage getPageProject() {
        return this.projectPage;
    }

    public String getTargetPluginId() {
        return MelangeActivator.getInstance().getBundle().getSymbolicName();
    }
}

