/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.trace.util;

import fr.inria.aoste.trace.DiscretizedClockStep;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.FiredStateKind;
import fr.inria.aoste.trace.InterDiscretizedSteps;
import fr.inria.aoste.trace.LogicalStep;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.NamedReference;
import fr.inria.aoste.trace.PhysicalBase;
import fr.inria.aoste.trace.PhysicalSteps;
import fr.inria.aoste.trace.Reference;
import fr.inria.aoste.trace.TraceFactory;
import org.eclipse.emf.ecore.EObject;

public class HelperFactory {
    public static ModelElementReference createModelElementReference(EObject eo) {
        ModelElementReference modelElementReference = TraceFactory.eINSTANCE.createModelElementReference();
        modelElementReference.getElementRef().add((Object)eo);
        return modelElementReference;
    }

    public static NamedReference createNamedReference(String s) {
        NamedReference namedReference = TraceFactory.eINSTANCE.createNamedReference();
        namedReference.setValue(s);
        return namedReference;
    }

    public static PhysicalBase createPhysicalBase(EObject eo) {
        PhysicalBase physicalBase = TraceFactory.eINSTANCE.createPhysicalBase();
        physicalBase.setRelatedDenseClock((Reference)HelperFactory.createModelElementReference(eo));
        return physicalBase;
    }

    public static DiscretizedClockStep createDiscretizedClockStep(LogicalStep step) {
        DiscretizedClockStep discretizedClockStep = TraceFactory.eINSTANCE.createDiscretizedClockStep();
        discretizedClockStep.setCorrespondingLogicalStep(step);
        return discretizedClockStep;
    }

    public static InterDiscretizedSteps createInterDiscretizedSteps(LogicalStep step) {
        InterDiscretizedSteps interDiscretizedSteps = TraceFactory.eINSTANCE.createInterDiscretizedSteps();
        interDiscretizedSteps.getCorrespondingLogicalSteps().add((Object)step);
        return interDiscretizedSteps;
    }

    public static EventOccurrence getEventOccurence(LogicalStep ls, PhysicalBase pb) {
        Reference o = (Reference)((ModelElementReference)pb.getRelatedDenseClock()).getElementRef().get(0);
        if (o == null) {
            return null;
        }
        for (EventOccurrence e : ls.getEventOccurrences()) {
            Reference r = e.getReferedElement();
            if (r != o) continue;
            return e;
        }
        return null;
    }

    public static EventOccurrence getEventOccurence(LogicalStep ls, Reference o) {
        if (o == null) {
            return null;
        }
        for (EventOccurrence e : ls.getEventOccurrences()) {
            Reference r = e.getReferedElement();
            if (r != o) continue;
            return e;
        }
        return null;
    }

    public static int getMaxInterval(PhysicalBase ph) {
        int n = 0;
        for (PhysicalSteps ps : ph.getPhysicalSteps()) {
            int m;
            if (!(ps instanceof InterDiscretizedSteps) || (m = ((InterDiscretizedSteps)ps).getCorrespondingLogicalSteps().size()) <= n) continue;
            n = m;
        }
        return n;
    }

    public static boolean isFixed(PhysicalBase pb, LogicalStep step) {
        EventOccurrence e = HelperFactory.getEventOccurence(step, pb);
        return e != null && e.getFState() == FiredStateKind.TICK;
    }

    public static EObject getFirstReference(ModelElementReference rf) {
        if (rf == null) {
            return null;
        }
        return (EObject)rf.getElementRef().get(0);
    }

    public static EObject getLastReference(ModelElementReference rf) {
        if (rf == null) {
            return null;
        }
        return (EObject)rf.getElementRef().get(rf.getElementRef().size() - 1);
    }
}

