/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class UpdateManagerHelperDeprecated {
    private static final String FEATURES = "features";
    private static final String FEATURE_XML = "feature.xml";

    @Deprecated
    public static void createPlatformConfiguration(File configLocation, IPluginModelBase[] models, IPluginModelBase brandingPlugin) throws CoreException {
        try {
            if (!configLocation.exists()) {
                return;
            }
            File platform_xml = new File(configLocation, "org.eclipse.update/platform.xml");
            platform_xml.getParentFile().mkdirs();
            ArrayList<LocalSite> sites = new ArrayList<LocalSite>();
            IPluginModelBase[] iPluginModelBaseArray = models;
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase model = iPluginModelBaseArray[n2];
                IPath path = new Path(model.getInstallLocation()).removeLastSegments(2);
                UpdateManagerHelperDeprecated.addToSite(path, model, sites);
                ++n2;
            }
            if (brandingPlugin != null) {
                IPath path = new Path(brandingPlugin.getInstallLocation()).removeLastSegments(2);
                UpdateManagerHelperDeprecated.addToSite(path, brandingPlugin, sites);
            }
            Throwable throwable = null;
            Object var6_11 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(platform_xml), StandardCharsets.UTF_8));){
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                writer.write("<config date=\"" + new Date().getTime() + "\" transient=\"true\" version=\"3.0\">\n");
                for (LocalSite site : sites) {
                    site.write(writer);
                    UpdateManagerHelperDeprecated.writeFeatures(writer, site.fPath.toFile());
                }
                writer.write("</config>");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null || message.length() == 0) {
                message = PDECoreMessages.TargetPlatform_exceptionThrown;
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 4, message, (Throwable)e));
        }
    }

    private static void addToSite(IPath path, IPluginModelBase model, ArrayList<LocalSite> sites) {
        if (path.getDevice() != null) {
            path = path.setDevice(path.getDevice().toUpperCase(Locale.ENGLISH));
        }
        int i = 0;
        while (i < sites.size()) {
            LocalSite localSite = sites.get(i);
            if (localSite.getPath().equals((Object)path)) {
                localSite.add(model);
                return;
            }
            ++i;
        }
        LocalSite localSite = new LocalSite(path);
        localSite.add(model);
        sites.add(localSite);
    }

    private static void writeFeatures(Writer writer, File location) {
        File featuresDir = new File(location, FEATURES);
        if (featuresDir.exists()) {
            File[] dirs;
            File[] fileArray = dirs = featuresDir.listFiles(f -> f.isDirectory() && new File(f, FEATURE_XML).exists());
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                File dir = fileArray[n2];
                File featureXML = new File(dir, FEATURE_XML);
                try {
                    FeatureEntry feature = new FeatureEntry(featureXML);
                    UpdateManagerHelperDeprecated.writeFeatureEntry(writer, feature);
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
    }

    private static void writeFeatureEntry(Writer writer, FeatureEntry feature) throws IOException {
        writer.write("<feature id=\"");
        writer.write(feature.id);
        if (feature.brandingPlugin != null) {
            writer.write("\" plugin-identifier=\"");
            writer.write(feature.brandingPlugin);
        }
        writer.write("\" url=\"");
        writer.write(feature.url);
        writer.write("\" version=\"");
        writer.write(feature.version);
        writer.write("\">\n</feature>\n");
    }

    static class FeatureEntry {
        static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        final String id;
        final String version;
        final String url;
        final String brandingPlugin;

        FeatureEntry(File xml) throws SAXException, IOException, ParserConfigurationException {
            Document document = factory.newDocumentBuilder().parse(xml);
            NamedNodeMap attributes = document.getFirstChild().getAttributes();
            String name = xml.getParentFile().getName();
            this.url = "features/" + name + "/";
            this.id = this.get("id", attributes);
            this.version = this.get("version", attributes);
            this.brandingPlugin = this.get("plugin", attributes);
        }

        String get(String name, NamedNodeMap attribues) {
            Node node = attribues.getNamedItem(name);
            return node == null ? null : node.getTextContent();
        }
    }

    @Deprecated
    private static class LocalSite {
        private final ArrayList<IPluginModelBase> fPlugins;
        private IPath fPath;

        LocalSite(IPath path) {
            this.fPath = path.getDevice() != null ? path.setDevice(path.getDevice().toUpperCase(Locale.ENGLISH)) : path;
            this.fPlugins = new ArrayList();
        }

        IPath getPath() {
            return this.fPath;
        }

        URL getURL() throws MalformedURLException {
            return new URL("file:" + this.fPath.removeTrailingSeparator());
        }

        void add(IPluginModelBase model) {
            this.fPlugins.add(model);
        }

        private static String relative(IPluginModelBase model) {
            Path location = new Path(model.getInstallLocation());
            if (location.segmentCount() > 2) {
                location = location.removeFirstSegments(location.segmentCount() - 2);
            }
            return location.setDevice(null).makeRelative().toString();
        }

        void write(Writer writer) throws IOException {
            writer.write("<site enabled=\"true\" list=\"");
            boolean comma = false;
            for (IPluginModelBase model : this.fPlugins) {
                if (comma) {
                    writer.write(44);
                }
                comma = true;
                writer.write(LocalSite.relative(model));
            }
            writer.write("\" policy=\"USER-INCLUDE\" updateable=\"true\" url=\"");
            writer.write(new File(this.getURL().getFile()).toURL().toString());
            writer.write("/\">\n");
            writer.write("</site>\n");
        }
    }
}

