/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.migration.description;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.sirius.business.api.migration.ResourceVersionMismatchDiagnostic;
import org.eclipse.sirius.business.internal.migration.IMigrationHandler;
import org.eclipse.sirius.business.internal.migration.description.VSMExtendedMetaData;
import org.eclipse.sirius.business.internal.migration.description.VSMMigrationService;
import org.eclipse.sirius.business.internal.migration.description.VSMResourceHandler;
import org.eclipse.sirius.business.internal.migration.description.VSMResourceXMILoad;
import org.eclipse.sirius.business.internal.migration.description.VSMVersionSAXParser;
import org.eclipse.sirius.business.internal.migration.description.VSMXMIHelper;
import org.eclipse.sirius.ext.base.Option;
import org.osgi.framework.Version;

public class ViewpointMigrationHandler
implements IMigrationHandler {
    @Override
    public void addMigrationOptionIfNeeded(URI newResourceUri, Map<Object, Object> loadOptions, Map<Object, Object> saveOptions) {
        boolean migrationIsNeeded = true;
        VSMVersionSAXParser parser = new VSMVersionSAXParser(newResourceUri);
        String loadedVersion = parser.getVersion((IProgressMonitor)new NullProgressMonitor());
        if (loadedVersion != null) {
            migrationIsNeeded = VSMMigrationService.getInstance().isMigrationNeeded(Version.parseVersion((String)loadedVersion));
        }
        if (migrationIsNeeded) {
            ViewpointMigrationHandler.addMigrationOptions(loadedVersion, loadOptions, saveOptions);
        }
    }

    @Override
    public XMLHelper createXMLHelper(XMLResource descriptionResource) {
        return new VSMXMIHelper(descriptionResource);
    }

    @Override
    public Option<String> getOptionalRewrittenFragment(String uriFragment) {
        return VSMMigrationService.getInstance().getNewFragment(uriFragment);
    }

    @Override
    public XMLLoad createXMLLoad(Map<?, ?> options, XMLResource descriptionResource) {
        if (options != null && options.containsKey("RESOURCE_MIGRATION_LOADEDVERSION")) {
            String loadedVersion = null;
            Object mapVersion = options.get("RESOURCE_MIGRATION_LOADEDVERSION");
            if (mapVersion instanceof String) {
                loadedVersion = (String)mapVersion;
            }
            return new VSMResourceXMILoad(loadedVersion, this.createXMLHelper(descriptionResource));
        }
        return null;
    }

    @Override
    public Resource.Diagnostic handleMigrationOptions(URI uri, Map<Object, Object> defaultLoadOptions, Map<Object, Object> defaultSaveOptions) {
        ResourceVersionMismatchDiagnostic migrationMismatchDiagnostic = null;
        VSMVersionSAXParser parser = new VSMVersionSAXParser(uri);
        String loadedVersion = parser.getVersion((IProgressMonitor)new NullProgressMonitor());
        boolean migrationIsNeeded = true;
        if (loadedVersion != null) {
            boolean attemptToLoadMoreRecentVSM;
            Version parsedLoadedVersion = Version.parseVersion((String)loadedVersion);
            Version lastMigrationVersion = VSMMigrationService.getInstance().getLastMigrationVersion();
            boolean bl = attemptToLoadMoreRecentVSM = lastMigrationVersion.compareTo(parsedLoadedVersion) < 0;
            if (attemptToLoadMoreRecentVSM) {
                migrationMismatchDiagnostic = new ResourceVersionMismatchDiagnostic(uri, parsedLoadedVersion, lastMigrationVersion);
            }
            migrationIsNeeded = VSMMigrationService.getInstance().isMigrationNeeded(parsedLoadedVersion);
        }
        Object versionOption = defaultLoadOptions.get("RESOURCE_MIGRATION_LOADEDVERSION");
        if (!migrationIsNeeded && versionOption != null) {
            this.removeMigrationMechanism(defaultLoadOptions, defaultSaveOptions);
        } else if (migrationIsNeeded && (versionOption == null || !versionOption.equals(loadedVersion))) {
            ViewpointMigrationHandler.addMigrationOptions(loadedVersion, defaultLoadOptions, defaultSaveOptions);
        }
        return migrationMismatchDiagnostic;
    }

    private void removeMigrationMechanism(Map<Object, Object> defaultLoadOptions, Map<Object, Object> defaultSaveOptions) {
        defaultLoadOptions.remove("EXTENDED_META_DATA");
        defaultLoadOptions.remove("RESOURCE_HANDLER");
        defaultLoadOptions.remove("RESOURCE_MIGRATION_LOADEDVERSION");
        defaultSaveOptions.remove("EXTENDED_META_DATA");
        defaultSaveOptions.remove("RESOURCE_HANDLER");
    }

    public static void addMigrationOptions(String loadedVersion, Map<Object, Object> loadOptions, Map<Object, Object> saveOptions) {
        VSMExtendedMetaData extendedMetaData = new VSMExtendedMetaData(loadedVersion);
        VSMResourceHandler resourceHandler = new VSMResourceHandler(loadedVersion);
        loadOptions.put("EXTENDED_META_DATA", (Object)extendedMetaData);
        loadOptions.put("RESOURCE_HANDLER", (Object)resourceHandler);
        loadOptions.put("RESOURCE_MIGRATION_LOADEDVERSION", loadedVersion);
        saveOptions.put("EXTENDED_META_DATA", (Object)extendedMetaData);
        saveOptions.put("RESOURCE_HANDLER", (Object)resourceHandler);
    }
}

