/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.quickfix;

import java.text.MessageFormat;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.part.ValidateAction;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.validation.ValidationFix;
import org.eclipse.sirius.viewpoint.description.validation.ViewValidationRule;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class ValidationFixResolution
implements IMarkerResolution {
    private ValidationFix fix;

    public ValidationFixResolution(ValidationFix fix) {
        this.fix = fix;
    }

    public String getLabel() {
        return this.fix.getName();
    }

    public void run(IMarker marker) {
        IResource airdFile = marker.getResource();
        if (airdFile instanceof IFile) {
            try {
                this.tryToOpenEditorAndApplyFix(airdFile, marker);
            }
            catch (PartInitException e) {
                SiriusPlugin.getDefault().error(MessageFormat.format(Messages.ValidationFixResolution_editorOpeningError, airdFile), (Throwable)e);
            }
        }
    }

    private void tryToOpenEditorAndApplyFix(IResource airdFile, IMarker marker) throws PartInitException {
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IMarker)marker);
        if (editor != null) {
            EObject fixTarget;
            View markedView;
            Session currentSession = null;
            IEditorInput editorInput = editor.getEditorInput();
            if (editorInput instanceof SessionEditorInput) {
                Session editorInputSession = ((SessionEditorInput)editorInput).getSession();
                if (editorInputSession != null && editorInputSession.isOpen()) {
                    currentSession = editorInputSession;
                } else {
                    URI markedResource = URI.createPlatformResourceURI((String)airdFile.getFullPath().toString(), (boolean)true);
                    Session existingSession = SessionManager.INSTANCE.getExistingSession(markedResource);
                    if (existingSession == null || !existingSession.isOpen()) {
                        return;
                    }
                    currentSession = existingSession;
                }
            }
            if ((markedView = this.getMarkedView(currentSession, marker)) != null && (fixTarget = this.getFixTarget(markedView)) != null) {
                Diagram diagram = markedView.getDiagram();
                this.executeFix(editor, (DDiagram)diagram.getElement(), fixTarget, currentSession.getTransactionalEditingDomain());
                this.revalidate(editor, (View)diagram);
            }
        }
    }

    private View getMarkedView(Session session, IMarker marker) {
        String elementID = marker.getAttribute("elementId", null);
        String diagramDescriptorURI = marker.getAttribute("DIAGRAM_DESCRIPTOR_URI", null);
        if (diagramDescriptorURI == null || elementID == null) {
            return null;
        }
        ResourceSet set = session.getTransactionalEditingDomain().getResourceSet();
        if (set != null) {
            EObject markerTarget;
            EObject markedDiagramDescriptor = set.getEObject(URI.createURI((String)diagramDescriptorURI), true);
            EObject markedDiagram = Optional.ofNullable(markedDiagramDescriptor).filter(DRepresentationDescriptor.class::isInstance).map(d -> ((DRepresentationDescriptor)d).getRepresentation()).orElse(null);
            EObject eObject = markerTarget = markedDiagram instanceof DDiagram ? markedDiagram.eResource().getEObject(elementID) : null;
            if (markerTarget instanceof View) {
                return (View)markerTarget;
            }
        }
        return null;
    }

    private void revalidate(IEditorPart editor, View view) {
        if (org.eclipse.sirius.viewpoint.provider.Messages.SessionEditorInput_defaultEditorName.equals(editor.getTitle()) || !(editor instanceof DialectEditor)) {
            ValidateAction.runNonUIValidation(view);
        } else {
            ((DialectEditor)editor).validateRepresentation();
        }
    }

    private EObject getFixTarget(View markedView) {
        EObject fixTarget = markedView.getElement();
        if (fixTarget instanceof DSemanticDecorator && !this.isViewValidationRule()) {
            fixTarget = ((DSemanticDecorator)fixTarget).getTarget();
        }
        return fixTarget;
    }

    private boolean isViewValidationRule() {
        return this.fix.eContainer() instanceof ViewValidationRule;
    }

    private void executeFix(IEditorPart editor, DDiagram diagram, EObject fixTarget, TransactionalEditingDomain domain) {
        IDiagramCommandFactory commandFactory = this.getDiagramCommandFactory(editor, domain);
        if (commandFactory != null && fixTarget != null) {
            Command fixCommand = commandFactory.buildQuickFixOperation(this.fix, fixTarget, diagram);
            EObject semanticTarget = this.getSemanticTarget(fixTarget);
            Session session = SessionManager.INSTANCE.getSession(semanticTarget);
            if (session != null) {
                session.getRefreshEditorsListener().setForceRefresh(true);
            }
            domain.getCommandStack().execute(fixCommand);
        }
    }

    private EObject getSemanticTarget(EObject fixTarget) {
        EObject semanticTarget = fixTarget;
        if (semanticTarget instanceof DSemanticDecorator) {
            semanticTarget = ((DSemanticDecorator)semanticTarget).getTarget();
        }
        return semanticTarget;
    }

    private IDiagramCommandFactory getDiagramCommandFactory(IEditorPart editor, TransactionalEditingDomain domain) {
        Object adapter = editor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider diagramCmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        return diagramCmdFactoryProvider.getCommandFactory(domain);
    }
}

