/**
 * ---------------------------------------------------------------------------------------------
 * Copyright (c) 2020 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * --------------------------------------------------------------------------------------------
 */
package org.eclipse.gemoc.protocols.eaop.api.data;

import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@SuppressWarnings("all")
public class EngineStartedEventArguments {
  /**
   * The name of the started engine
   */
  private ExecutionEngineDto engine;
  
  /**
   * The name of the started engine
   */
  @Pure
  public ExecutionEngineDto getEngine() {
    return this.engine;
  }
  
  /**
   * The name of the started engine
   */
  public void setEngine(final ExecutionEngineDto engine) {
    this.engine = engine;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("engine", this.engine);
    return b.toString();
  }
  
  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    EngineStartedEventArguments other = (EngineStartedEventArguments) obj;
    if (this.engine == null) {
      if (other.engine != null)
        return false;
    } else if (!this.engine.equals(other.engine))
      return false;
    return true;
  }
  
  @Override
  @Pure
  public int hashCode() {
    return 31 * 1 + ((this.engine== null) ? 0 : this.engine.hashCode());
  }
}
