/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.instantrelation.generator;

import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.CCSLConstraintRef;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.CCSLRelationModelFactory;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.OccurrenceRelationModel;
import fr.inria.aoste.timesquare.instantrelation.exceptions.ResolveClockConstraintException;
import fr.inria.aoste.timesquare.instantrelation.extensionpoint.LookForExtensions;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.AbstractCreator;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.CreatorCoincidence;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.CreatorCoincidenceInfSup;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.CreatorPacket;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.CreatorPacketGlissant;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.CreatorPacketSustain;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.CreatorPrecedesBy;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.CreatorPrecedesByOffset;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.CreatorPrecedesInf;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.CreatorPrecedesOffset;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.CreatorPrecedesSup;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.CreatorPrecedesTrigger;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.CreatorPrecedesTriggerOneShot;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.activation.ActivationCreator;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.activation.LifeActivationCreator;
import fr.inria.aoste.timesquare.instantrelation.listener.IRelationModelListener;
import fr.inria.aoste.timesquare.instantrelation.listener.RelationModelListener;
import fr.inria.aoste.timesquare.utils.pluginhelpers.PluginHelpers;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.LogicalStep;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.Reference;
import fr.inria.aoste.trace.Trace;
import fr.inria.aoste.trace.relation.IDescription;
import fr.inria.aoste.trace.relation.IOutputTraceList;
import fr.inria.aoste.trace.relation.IRelation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class InstantRelationModelGenerator
implements IRelation {
    protected OccurrenceRelationModel ccslRelation;
    protected IPath local;
    protected String namefile;
    public final IRelationModelListener irml = new RelationModelListener();
    protected Resource resource = null;
    protected List<ModelElementReference> listClock;
    protected List<ModelElementReference> listRelation;
    protected ArrayList<AbstractCreator> lab = new ArrayList();

    public InstantRelationModelGenerator() {
        CCSLRelationModelFactory modelFactory = CCSLRelationModelFactory.eINSTANCE;
        this.ccslRelation = modelFactory.createOccurrenceRelationModel();
    }

    public void setIOutputTraceList(IOutputTraceList outputlist) {
        this.irml.setIOutputTraceList(outputlist);
    }

    public InstantRelationModelGenerator(IOutputTraceList outputlist) {
        this();
        this.setIOutputTraceList(outputlist);
    }

    public EList<CCSLConstraintRef> getClockConstraintList() {
        return this.ccslRelation.getRefsToCCSLConstraints();
    }

    public void getModelRoot(EObject eObject) {
        this.irml.clear();
        LookForExtensions.getDefault().getICCSLModel(eObject, this);
    }

    public void addClockConstraint(LogicalStep stepTrace) {
        if (stepTrace.getEventOccurrences().isEmpty()) {
            return;
        }
        Reference ref = ((EventOccurrence)stepTrace.getEventOccurrences().get(0)).getReferedElement();
        EObject eo1 = null;
        if (ref instanceof ModelElementReference) {
            eo1 = ((EObject)((ModelElementReference)ref).getElementRef().get(0)).eContainer();
        }
        this.getModelRoot(eo1);
        this.disp();
    }

    public void extract(EObject eo1) {
        LookForExtensions.getDefault().getICCSLModel(eo1, this);
        this.disp();
    }

    public ArrayList<IDescription> getDescription() {
        ArrayList<IDescription> desc = new ArrayList<IDescription>(this.lab.size());
        for (AbstractCreator a : this.lab) {
            desc.add(a.getDescription());
        }
        return desc;
    }

    public void disp() {
        for (AbstractCreator clockConstraint : this.lab) {
            System.out.println(clockConstraint.getDescription().toString());
        }
    }

    public ArrayList<LogicalStep> loadTrace(IPath path) {
        ArrayList<LogicalStep> steps = new ArrayList<LogicalStep>();
        Trace trace = null;
        URI uri = URI.createFileURI((String)path.toString());
        Resource resource = new ResourceSetImpl().getResource(uri, true);
        resource.getResourceSet().getResources();
        Object o = resource.getContents().get(0);
        if (!(o instanceof Trace)) {
            return null;
        }
        trace = (Trace)o;
        EcoreUtil.resolveAll((EObject)trace);
        steps.addAll((Collection<LogicalStep>)trace.getLogicalSteps());
        return steps;
    }

    public ModelElementReference searchClock(EObject eo) {
        return this.searchClock(new EObject[]{eo});
    }

    public ModelElementReference searchClock(EObject[] eObjects) {
        block0: for (ModelElementReference mer : this.listClock) {
            if (mer.getElementRef().size() != eObjects.length) continue;
            EObject[] eObjectArray = eObjects;
            int n = eObjects.length;
            int n2 = 0;
            while (n2 < n) {
                EObject eo = eObjectArray[n2];
                if (mer.getElementRef().indexOf((Object)eo) == -1) continue block0;
                ++n2;
            }
            return mer;
        }
        return null;
    }

    public ModelElementReference searchConstraint(EObject eo) {
        return this.searchConstraint(new EObject[]{eo});
    }

    public ModelElementReference searchConstraint(EObject[] eObjects) {
        block0: for (ModelElementReference mer : this.listRelation) {
            if (mer.getElementRef().size() != eObjects.length) continue;
            EObject[] eObjectArray = eObjects;
            int n = eObjects.length;
            int n2 = 0;
            while (n2 < n) {
                EObject eo = eObjectArray[n2];
                if (mer.getElementRef().indexOf((Object)eo) == -1) continue block0;
                ++n2;
            }
            return mer;
        }
        return null;
    }

    public List<ModelElementReference> getListClock() {
        return this.listClock;
    }

    public List<ModelElementReference> getListRelation() {
        return this.listRelation;
    }

    public void setListClock(List<ModelElementReference> listClock) {
        this.listClock = listClock;
    }

    public void setListRelation(List<ModelElementReference> listrelation) {
        this.listRelation = listrelation;
    }

    public void resolve(LogicalStep stepTrace) {
        ArrayList<ResolveClockConstraintException> list = new ArrayList<ResolveClockConstraintException>();
        try {
            this.irml.clear();
            for (AbstractCreator clockConstraint : this.lab) {
                try {
                    clockConstraint.resolve(stepTrace);
                }
                catch (ResolveClockConstraintException e) {
                    list.add(e);
                }
            }
            this.irml.postNewRelation();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveRelationModel() {
        if (this.ccslRelation == null) {
            return;
        }
        String nametrace = this.local.append(String.valueOf(this.namefile) + ".ccslrelationmodel").toString();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        XMIResourceFactoryImpl xmiresource = new XMIResourceFactoryImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", xmiresource);
        URI fileURI = URI.createFileURI((String)nametrace);
        this.resource = resourceSet.createResource(fileURI);
        this.resource.getContents().add((Object)this.ccslRelation);
        try {
            this.resource.save(PluginHelpers.getEcoreSaveOption());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveRelationModel(ResourceSet rs) {
        if (this.ccslRelation == null) {
            return;
        }
        String nametrace = this.local.append(String.valueOf(this.namefile) + ".ccslrelationmodel").toString();
        XMIResourceFactoryImpl xmiresource = new XMIResourceFactoryImpl();
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", xmiresource);
        URI fileURI = URI.createPlatformResourceURI((String)nametrace, (boolean)false);
        this.resource = rs.createResource(fileURI);
        this.resource.getContents().add((Object)this.ccslRelation);
        try {
            this.resource.save(PluginHelpers.getEcoreSaveOption());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveRelationModel(IPath folderin, String namefilein) {
        this.local = folderin;
        this.namefile = namefilein;
        this.saveRelationModel();
        this.irml.reInit();
    }

    public void saveRelationModel(ResourceSet rs, IPath folderin, String namefilein) {
        this.local = folderin;
        this.namefile = namefilein;
        this.saveRelationModel(rs);
        this.irml.reInit();
    }

    public void unload() {
        try {
            if (this.resource != null) {
                this.resource.unload();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void aNewClockConstraint(CCSLConstraintRef clockConstraint) {
        this.getClockConstraintList().add((Object)clockConstraint);
        this.irml.aNewClockConstraint(clockConstraint);
    }

    public AbstractCreator add(AbstractCreator ab) {
        if (ab != null) {
            if (ab.addChecking()) {
                this.lab.add(ab);
                ab.setIrml(this.irml);
            } else {
                try {
                    System.err.println("Ignore : " + ab.getClass().getSimpleName() + " :" + ab.getDescription() + " ");
                }
                catch (Throwable e) {
                    System.err.println("Ignore : " + ab.getClass().getSimpleName());
                }
            }
        }
        return ab;
    }

    public AbstractCreator add(AbstractCreator ab, ActivationCreator activationCreator) {
        if (ab != null) {
            if (ab.addChecking()) {
                if (activationCreator != null) {
                    ab.setActivationCreator(activationCreator);
                }
                this.lab.add(ab);
                ab.setIrml(this.irml);
            } else {
                try {
                    System.err.println("Ignore : " + ab.getClass().getSimpleName() + " :" + ab.getDescription() + " ");
                }
                catch (Throwable e) {
                    System.err.println("Ignore : " + ab.getClass().getSimpleName());
                }
            }
        }
        return ab;
    }

    public CCSLConstraintRef addAndCreateAlternates(ModelElementReference a, ModelElementReference b, int a1, int b1, boolean left, boolean rigth) {
        CCSLConstraintRef cref = CCSLRelationModelFactory.eINSTANCE.createCCSLConstraintRef();
        cref.getCcslElements().add((Object)a);
        cref.getCcslElements().add((Object)b);
        this.getClockConstraintList().add((Object)cref);
        this.irml.aNewClockConstraint(cref);
        this.add(new CreatorPrecedesBy(cref, a, b, left, a1, b1));
        if (a1 == 1 && b1 == 1) {
            this.add(new CreatorPrecedesOffset(cref, b, a, rigth, 0, 1));
        } else {
            this.add(new CreatorPrecedesByOffset(cref, b, a, rigth, b1, 0, a1, a1));
        }
        this.add(new CreatorPacket(cref, a, a1));
        this.add(new CreatorPacket(cref, b, b1));
        return cref;
    }

    public CCSLConstraintRef addAndCreatePrecedes(ModelElementReference a, ModelElementReference b, int a1, int b1, boolean strict) {
        CCSLConstraintRef cref = CCSLRelationModelFactory.eINSTANCE.createCCSLConstraintRef();
        cref.getCcslElements().add((Object)a);
        cref.getCcslElements().add((Object)b);
        this.getClockConstraintList().add((Object)cref);
        this.irml.aNewClockConstraint(cref);
        this.add(new CreatorPrecedesBy(cref, a, b, strict, a1, b1));
        this.add(new CreatorPacket(cref, a, a1));
        this.add(new CreatorPacket(cref, b, b1));
        return cref;
    }

    public CCSLConstraintRef addAndCreateSync(ModelElementReference a, ModelElementReference b, int a1, int b1, boolean left, boolean rigth) {
        CCSLConstraintRef cref = CCSLRelationModelFactory.eINSTANCE.createCCSLConstraintRef();
        cref.getCcslElements().add((Object)a);
        cref.getCcslElements().add((Object)b);
        this.getClockConstraintList().add((Object)cref);
        this.irml.aNewClockConstraint(cref);
        if (a1 == 1 && b1 == 1) {
            this.add(new CreatorPrecedesOffset(cref, a, b, left, 0, 1));
            this.add(new CreatorPrecedesOffset(cref, b, a, rigth, 0, 1));
        } else {
            this.add(new CreatorPrecedesByOffset(cref, a, b, left, a1, 0, b1, b1));
            this.add(new CreatorPrecedesByOffset(cref, b, a, rigth, b1, 0, a1, a1));
        }
        this.add(new CreatorPacket(cref, a, a1));
        this.add(new CreatorPacket(cref, b, b1));
        return cref;
    }

    public CCSLConstraintRef addAndCreateEqual(ModelElementReference a, ModelElementReference b) {
        CCSLConstraintRef cref = CCSLRelationModelFactory.eINSTANCE.createCCSLConstraintRef();
        cref.getCcslElements().add((Object)a);
        cref.getCcslElements().add((Object)b);
        CreatorCoincidence clockRelationEqual = new CreatorCoincidence(cref, a, b);
        this.getClockConstraintList().add((Object)cref);
        this.irml.aNewClockConstraint(cref);
        this.add(clockRelationEqual);
        return cref;
    }

    public CCSLConstraintRef addAndCreateConcatenation(ModelElementReference res, ModelElementReference c1, ModelElementReference c2) {
        CCSLConstraintRef cref = CCSLRelationModelFactory.eINSTANCE.createCCSLConstraintRef();
        cref.getCcslElements().add((Object)res);
        cref.getCcslElements().add((Object)c1);
        cref.getCcslElements().add((Object)c2);
        CreatorCoincidence instantRelationEqual = new CreatorCoincidence(cref, res, c1);
        CreatorCoincidence instantRelationEqual2 = new CreatorCoincidence(cref, res, c2);
        this.getClockConstraintList().add((Object)cref);
        this.irml.aNewClockConstraint(cref);
        this.add(instantRelationEqual, new LifeActivationCreator(res));
        this.add(instantRelationEqual2, new LifeActivationCreator(res));
        return cref;
    }

    public CCSLConstraintRef addAndCreateUpTo(ModelElementReference res, ModelElementReference c1, ModelElementReference c2) {
        CCSLConstraintRef cref = CCSLRelationModelFactory.eINSTANCE.createCCSLConstraintRef();
        cref.getCcslElements().add((Object)res);
        cref.getCcslElements().add((Object)c1);
        cref.getCcslElements().add((Object)c2);
        CreatorCoincidence instantRelationEqual = new CreatorCoincidence(cref, res, c1);
        CreatorPrecedesTrigger instantRelationPrecedes = new CreatorPrecedesTrigger(cref, res, c2, true, true);
        CreatorPrecedesTriggerOneShot instantRelationPrecedes2 = new CreatorPrecedesTriggerOneShot(cref, c2, c1, false, false);
        this.getClockConstraintList().add((Object)cref);
        this.irml.aNewClockConstraint(cref);
        this.add(instantRelationEqual, new LifeActivationCreator(res));
        this.add(instantRelationPrecedes2, new LifeActivationCreator(res));
        this.add(instantRelationPrecedes, new LifeActivationCreator(res));
        return cref;
    }

    public CCSLConstraintRef addandCreateInf(ModelElementReference r, ModelElementReference[] lst) {
        ModelElementReference a;
        CCSLConstraintRef cref = CCSLRelationModelFactory.eINSTANCE.createCCSLConstraintRef();
        cref.getCcslElements().add((Object)r);
        ModelElementReference[] modelElementReferenceArray = lst;
        int n = lst.length;
        int n2 = 0;
        while (n2 < n) {
            a = modelElementReferenceArray[n2];
            cref.getCcslElements().add((Object)a);
            ++n2;
        }
        this.irml.aNewClockConstraint(cref);
        this.getClockConstraintList().add((Object)cref);
        modelElementReferenceArray = lst;
        n = lst.length;
        n2 = 0;
        while (n2 < n) {
            a = modelElementReferenceArray[n2];
            this.add(new CreatorCoincidenceInfSup(cref, r, a), new LifeActivationCreator(r));
            this.add(new CreatorPrecedesInf(cref, r, a), new LifeActivationCreator(r));
            ++n2;
        }
        return cref;
    }

    public CCSLConstraintRef addandCreateSup(ModelElementReference r, ModelElementReference[] lst) {
        ModelElementReference a;
        CCSLConstraintRef cref = CCSLRelationModelFactory.eINSTANCE.createCCSLConstraintRef();
        cref.getCcslElements().add((Object)r);
        ModelElementReference[] modelElementReferenceArray = lst;
        int n = lst.length;
        int n2 = 0;
        while (n2 < n) {
            a = modelElementReferenceArray[n2];
            cref.getCcslElements().add((Object)a);
            ++n2;
        }
        this.irml.aNewClockConstraint(cref);
        this.getClockConstraintList().add((Object)cref);
        modelElementReferenceArray = lst;
        n = lst.length;
        n2 = 0;
        while (n2 < n) {
            a = modelElementReferenceArray[n2];
            this.add(new CreatorCoincidenceInfSup(cref, r, a), new LifeActivationCreator(r));
            this.add(new CreatorPrecedesSup(cref, a, r), new LifeActivationCreator(r));
            ++n2;
        }
        return cref;
    }

    public CCSLConstraintRef addandCreateInterOrUnion(ModelElementReference r, ModelElementReference a, ModelElementReference b) {
        CCSLConstraintRef cref = CCSLRelationModelFactory.eINSTANCE.createCCSLConstraintRef();
        cref.getCcslElements().add((Object)r);
        cref.getCcslElements().add((Object)a);
        cref.getCcslElements().add((Object)b);
        this.irml.aNewClockConstraint(cref);
        this.getClockConstraintList().add((Object)cref);
        this.add(new CreatorCoincidence(cref, r, a), new LifeActivationCreator(r));
        this.add(new CreatorCoincidence(cref, r, b), new LifeActivationCreator(r));
        return cref;
    }

    public CCSLConstraintRef addandCreateDelayedFor(ModelElementReference r, ModelElementReference a, ModelElementReference b, int n) {
        CCSLConstraintRef cref = CCSLRelationModelFactory.eINSTANCE.createCCSLConstraintRef();
        cref.getCcslElements().add((Object)r);
        cref.getCcslElements().add((Object)a);
        cref.getCcslElements().add((Object)b);
        this.irml.aNewClockConstraint(cref);
        this.getClockConstraintList().add((Object)cref);
        this.add(new CreatorCoincidence(cref, r, b), new LifeActivationCreator(r));
        if (n != -1) {
            this.add(new CreatorPacketGlissant(cref, b, n, a), new LifeActivationCreator(r));
        }
        if (a != b) {
            this.add(new CreatorPrecedesTrigger(cref, a, b, true, true), new LifeActivationCreator(r));
            this.add(new CreatorPrecedesTrigger(cref, b, a, true, true), new LifeActivationCreator(r));
        }
        return cref;
    }

    public CCSLConstraintRef addandCreateSampledOn(ModelElementReference sup, ModelElementReference superc, ModelElementReference trigger, boolean strictly) {
        CCSLConstraintRef cref = CCSLRelationModelFactory.eINSTANCE.createCCSLConstraintRef();
        cref.getCcslElements().add((Object)sup);
        cref.getCcslElements().add((Object)superc);
        cref.getCcslElements().add((Object)trigger);
        this.irml.aNewClockConstraint(cref);
        this.getClockConstraintList().add((Object)cref);
        this.add(new CreatorCoincidence(cref, superc, sup), new LifeActivationCreator(sup));
        this.add(new CreatorPrecedesTrigger(cref, trigger, superc, strictly, true), new LifeActivationCreator(sup));
        this.add(new CreatorPrecedesTrigger(cref, superc, trigger, !strictly, true), new LifeActivationCreator(sup, false));
        return cref;
    }

    public CCSLConstraintRef addandCreateSustain(ModelElementReference res, ModelElementReference sustain, ModelElementReference upto) {
        CCSLConstraintRef cref = CCSLRelationModelFactory.eINSTANCE.createCCSLConstraintRef();
        cref.getCcslElements().add((Object)res);
        cref.getCcslElements().add((Object)sustain);
        cref.getCcslElements().add((Object)upto);
        this.irml.aNewClockConstraint(cref);
        this.getClockConstraintList().add((Object)cref);
        this.add(new CreatorCoincidence(cref, res, sustain), new LifeActivationCreator(res));
        this.add(new CreatorPrecedesTrigger(cref, res, upto, true, true), new LifeActivationCreator(res));
        this.add(new CreatorPacketSustain(cref, res, sustain, upto), new LifeActivationCreator(res));
        return cref;
    }
}

