/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.profiles.core.internal.management;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.shared.utils.StringUtils;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.NoSuchComponentException;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.profiles.core.internal.IProfileManager;
import org.eclipse.m2e.profiles.core.internal.MavenProfilesCoreActivator;
import org.eclipse.m2e.profiles.core.internal.ProfileData;
import org.eclipse.m2e.profiles.core.internal.ProfileState;
import org.eclipse.osgi.util.NLS;

public class ProfileManager
implements IProfileManager {
    @Override
    public void updateActiveProfiles(IMavenProjectFacade mavenProjectFacade, List<String> profiles, boolean isOffline, boolean isForceUpdate, IProgressMonitor monitor) throws CoreException {
        if (mavenProjectFacade == null) {
            return;
        }
        IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
        IProject project = mavenProjectFacade.getProject();
        ResolverConfiguration configuration = configurationManager.getResolverConfiguration(project);
        String profilesAsString = String.join((CharSequence)", ", profiles);
        if (profilesAsString.equals(configuration.getSelectedProfiles())) {
            return;
        }
        configuration.setSelectedProfiles(profilesAsString);
        boolean isSet = configurationManager.setResolverConfiguration(project, configuration);
        if (isSet) {
            MavenUpdateRequest request = new MavenUpdateRequest(project, isOffline, isForceUpdate);
            configurationManager.updateProjectConfiguration(request, monitor);
        }
    }

    @Override
    public Map<org.apache.maven.model.Profile, Boolean> getAvailableSettingsProfiles() throws CoreException {
        LinkedHashMap<org.apache.maven.model.Profile, Boolean> settingsProfiles = new LinkedHashMap<org.apache.maven.model.Profile, Boolean>();
        Settings settings = MavenPlugin.getMaven().getSettings();
        List activeProfiles = settings.getActiveProfiles();
        for (Profile sp : settings.getProfiles()) {
            org.apache.maven.model.Profile p = SettingsUtils.convertFromSettingsProfile((Profile)sp);
            boolean isAutomaticallyActivated = this.isActive(sp, activeProfiles);
            settingsProfiles.put(p, isAutomaticallyActivated);
        }
        return Collections.unmodifiableMap(settingsProfiles);
    }

    private boolean isActive(Profile p, List<String> activeProfiles) {
        if (p.getActivation() != null && p.getActivation().isActiveByDefault()) {
            return true;
        }
        return activeProfiles.stream().anyMatch(ap -> ap.equals(p.getId()));
    }

    @Override
    public List<ProfileData> getProfileDatas(IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        if (facade == null) {
            return Collections.emptyList();
        }
        ResolverConfiguration resolverConfiguration = MavenPlugin.getProjectConfigurationManager().getResolverConfiguration(facade.getProject());
        List<String> configuredProfiles = this.toList(resolverConfiguration.getSelectedProfiles());
        MavenProject mavenProject = facade.getMavenProject(monitor);
        ArrayList<Model> modelHierarchy = new ArrayList<Model>();
        this.getModelHierarchy(modelHierarchy, mavenProject.getModel(), monitor);
        List<org.apache.maven.model.Profile> availableProfiles = this.collectAvailableProfiles(modelHierarchy, monitor);
        Map<org.apache.maven.model.Profile, Boolean> availableSettingsProfiles = this.getAvailableSettingsProfiles();
        availableProfiles.addAll(availableSettingsProfiles.keySet());
        ArrayList<ProfileData> statuses = new ArrayList<ProfileData>();
        Map allActiveProfiles = mavenProject.getInjectedProfileIds();
        for (org.apache.maven.model.Profile p : availableProfiles) {
            String pId = p.getId();
            ProfileData status = new ProfileData(pId);
            boolean isDisabled = configuredProfiles.contains("!" + pId);
            if (this.isActive(pId, allActiveProfiles)) {
                status.setActivationState(ProfileState.Active);
            } else if (isDisabled) {
                status.setActivationState(ProfileState.Disabled);
            }
            boolean isUserSelected = isDisabled || configuredProfiles.contains(pId);
            status.setUserSelected(isUserSelected);
            Boolean isAutoActiveSettingProfile = availableSettingsProfiles.get(p);
            boolean isAutoActive = isAutoActiveSettingProfile != null && isAutoActiveSettingProfile != false || status.getActivationState().isActive() && !isUserSelected;
            status.setAutoActive(isAutoActive);
            status.setSource(this.findSource(p, modelHierarchy));
            statuses.add(status);
        }
        return Collections.unmodifiableList(statuses);
    }

    private boolean isActive(String profileId, Map<String, List<String>> profilesMap) {
        for (Map.Entry<String, List<String>> entry : profilesMap.entrySet()) {
            for (String pId : entry.getValue()) {
                if (!pId.equals(profileId)) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> toList(String profilesAsText) {
        ArrayList<String> profiles = new ArrayList<String>();
        if (profilesAsText != null && profilesAsText.trim().length() > 0) {
            profiles.addAll(Arrays.asList(profilesAsText.split("[,\\s\\|]")));
        }
        return profiles;
    }

    private String findSource(org.apache.maven.model.Profile profile, List<Model> modelHierarchy) {
        if (profile != null) {
            if ("settings.xml".equals(profile.getSource())) {
                return profile.getSource();
            }
            for (Model m : modelHierarchy) {
                for (org.apache.maven.model.Profile p : m.getProfiles()) {
                    if (!p.equals(profile)) continue;
                    return m.getArtifactId();
                }
            }
        }
        return "undefined";
    }

    protected List<org.apache.maven.model.Profile> collectAvailableProfiles(List<Model> models, IProgressMonitor monitor) {
        ArrayList<org.apache.maven.model.Profile> profiles = new ArrayList<org.apache.maven.model.Profile>();
        for (Model m : models) {
            profiles.addAll(m.getProfiles());
        }
        return profiles;
    }

    protected List<Model> getModelHierarchy(List<Model> models, Model projectModel, IProgressMonitor monitor) throws CoreException {
        Model parentModel;
        if (projectModel == null) {
            return null;
        }
        models.add(projectModel);
        Parent p = projectModel.getParent();
        if (p != null && (parentModel = this.buildParentModel(projectModel, monitor)) != null) {
            this.getModelHierarchy(models, parentModel, monitor);
        }
        return models;
    }

    private Model buildParentModel(Model projectModel, IProgressMonitor monitor) throws CoreException {
        Model parentModel = this.buildParentModelViaRelativePath(projectModel);
        if (parentModel != null) {
            return parentModel;
        }
        IMaven maven = MavenPlugin.getMaven();
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        repositories.addAll(this.getProjectRepositories(projectModel));
        repositories.addAll(maven.getArtifactRepositories());
        Parent p = projectModel.getParent();
        return this.resolvePomModel(p.getGroupId(), p.getArtifactId(), p.getVersion(), repositories, monitor);
    }

    private Model buildParentModelViaRelativePath(Model model) {
        if (model.getPomFile() == null) {
            return null;
        }
        String relativePath = StringUtils.isEmpty((String)model.getParent().getRelativePath()) ? ".." + File.separator + "pom.xml" : model.getParent().getRelativePath();
        String relativeFileSystemPathToParentPom = ".." + File.separator + relativePath;
        String pomFileSystemPath = model.getPomFile().getPath();
        try {
            File parentPomFile = Paths.get(pomFileSystemPath, relativeFileSystemPathToParentPom).toFile().getCanonicalFile();
            if (parentPomFile.exists()) {
                MavenXpp3Reader mavenreader = new MavenXpp3Reader();
                FileReader reader = new FileReader(parentPomFile);
                Model parentModel = mavenreader.read((Reader)reader);
                parentModel.setPomFile(parentPomFile);
                return parentModel;
            }
        }
        catch (Exception e) {
            MavenProfilesCoreActivator.getDefault().getLog().error("Error building Maven model for parent POM file with relative path [" + relativeFileSystemPathToParentPom + "] from child POM path [" + pomFileSystemPath + "]", (Throwable)e);
        }
        return null;
    }

    private List<ArtifactRepository> getProjectRepositories(Model projectModel) {
        ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
        List modelRepos = projectModel.getRepositories();
        if (modelRepos != null && !modelRepos.isEmpty()) {
            RepositorySystem repositorySystem = this.getRepositorySystem();
            for (Repository modelRepo : modelRepos) {
                try {
                    ArtifactRepository ar = repositorySystem.buildArtifactRepository(modelRepo);
                    if (ar == null) continue;
                    repos.add(ar);
                }
                catch (InvalidRepositoryException e) {
                    MavenProfilesCoreActivator.log(e);
                }
            }
        }
        return repos;
    }

    private RepositorySystem getRepositorySystem() {
        try {
            return (RepositorySystem)MavenPluginActivator.getDefault().getMaven().lookup(RepositorySystem.class);
        }
        catch (CoreException e) {
            if (e.getStatus().getException() instanceof ComponentLookupException) {
                throw new NoSuchComponentException((ComponentLookupException)e.getStatus().getException());
            }
            MavenProfilesCoreActivator.log(e.getStatus().getException());
            throw new NoSuchComponentException(null);
        }
    }

    private Model resolvePomModel(String groupId, String artifactId, String version, List<ArtifactRepository> repositories, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(NLS.bind((String)"Resolving {0}:{1}:{2}", (Object[])new Object[]{groupId, artifactId, version}));
        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getMavenProject(groupId, artifactId, version);
        IMaven maven = MavenPlugin.getMaven();
        if (facade != null) {
            return facade.getMavenProject(monitor).getModel();
        }
        Artifact artifact = maven.resolve(groupId, artifactId, version, "pom", null, repositories, monitor);
        File file = artifact.getFile();
        if (file == null) {
            return null;
        }
        return maven.readModel(file);
    }
}

