/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.standalone;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.standalone.HelpCommand;
import org.eclipse.ocl.examples.standalone.StandaloneApplication;
import org.eclipse.ocl.examples.standalone.StandaloneCommand;
import org.eclipse.ocl.examples.standalone.validity.ValidateCommand;

public class StandaloneCommandAnalyzer {
    private static final Logger logger = Logger.getLogger(StandaloneCommandAnalyzer.class);
    private final @NonNull Map<String, StandaloneCommand> commands = new HashMap<String, StandaloneCommand>();

    public StandaloneCommandAnalyzer(@NonNull StandaloneApplication standaloneApplication) {
        this.addCommand(new HelpCommand(standaloneApplication));
        this.addCommand(new ValidateCommand(standaloneApplication));
    }

    protected void addCommand(@NonNull StandaloneCommand command) {
        this.commands.put(command.getName(), command);
    }

    public @NonNull Collection<StandaloneCommand> getCommands() {
        return this.commands.values();
    }

    public @Nullable StandaloneCommand parse(@NonNull String @NonNull [] args) {
        if (args.length <= 0) {
            logger.error((Object)"Missing command keyword");
            return null;
        }
        StandaloneCommand command = this.commands.get(args[0]);
        if (command == null) {
            logger.error((Object)("Unknown command keyword '" + args[0] + "'"));
            return null;
        }
        return command;
    }
}

