/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.linkedediting;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.operations.linkedediting.LSPLinkedEditingBase;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Range;
import org.eclipse.swt.custom.StyledText;

public class LSPLinkedEditingReconcilingStrategy
extends LSPLinkedEditingBase
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
IDocumentListener {
    public static final String LINKEDEDITING_ANNOTATION_TYPE = "org.eclipse.lsp4e.linkedediting";
    private ISourceViewer sourceViewer;
    private IDocument fDocument;
    private EditorSelectionChangedListener editorSelectionChangedListener;
    private Job highlightJob;
    private Annotation[] fLinkedEditingAnnotations = null;

    public void install(ITextViewer viewer) {
        if (!(viewer instanceof ISourceViewer)) {
            return;
        }
        super.install();
        this.sourceViewer = (ISourceViewer)viewer;
        this.editorSelectionChangedListener = new EditorSelectionChangedListener();
        this.editorSelectionChangedListener.install(this.sourceViewer.getSelectionProvider());
    }

    @Override
    public void uninstall() {
        if (this.sourceViewer != null) {
            this.editorSelectionChangedListener.uninstall(this.sourceViewer.getSelectionProvider());
        }
        super.uninstall();
    }

    @Override
    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        super.preferenceChange(event);
        if (event.getKey().equals("org.eclipse.ui.genericeditor.linkedediting")) {
            if (this.fEnabled) {
                this.initialReconcile();
            } else {
                this.removeLinkedEditingAnnotations();
            }
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void initialReconcile() {
        if (this.sourceViewer != null) {
            ISelectionProvider selectionProvider = this.sourceViewer.getSelectionProvider();
            StyledText textWidget = this.sourceViewer.getTextWidget();
            if (textWidget != null && selectionProvider != null) {
                textWidget.getDisplay().asyncExec(() -> {
                    if (!textWidget.isDisposed()) {
                        this.updateLinkedEditingHighlights(selectionProvider.getSelection());
                    }
                });
            }
        }
    }

    public void setDocument(IDocument document) {
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener((IDocumentListener)this);
            this.fLinkedEditingRanges = null;
        }
        this.fDocument = document;
        if (this.fDocument != null) {
            this.fDocument.addDocumentListener((IDocumentListener)this);
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
    }

    public void reconcile(IRegion partition) {
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.updateLinkedEditingHighlights(event.getOffset());
    }

    private void updateLinkedEditingHighlights(ISelection selection) {
        if (selection instanceof ITextSelection) {
            this.updateLinkedEditingHighlights(((ITextSelection)selection).getOffset());
        }
    }

    private void updateLinkedEditingHighlights(int offset) {
        if (this.sourceViewer != null && this.fDocument != null && this.fEnabled) {
            this.collectLinkedEditingRanges(this.fDocument, offset).thenAcceptAsync(theVoid -> this.updateLinkedEditingHighlights());
        }
    }

    private void updateLinkedEditingHighlights() {
        if (this.highlightJob != null) {
            this.highlightJob.cancel();
        }
        this.highlightJob = Job.createSystem((String)"LSP4E Linked Editing Highlight", monitor -> this.updateLinkedEditingAnnotations(this.sourceViewer.getAnnotationModel(), monitor));
        this.highlightJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLinkedEditingAnnotations(IAnnotationModel annotationModel, IProgressMonitor monitor) {
        if (monitor.isCanceled() || annotationModel == null) {
            return;
        }
        LinkedEditingRanges ranges = this.fLinkedEditingRanges;
        HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>(ranges == null ? 0 : ranges.getRanges().size());
        if (ranges != null) {
            for (Range r : ranges.getRanges()) {
                try {
                    int start = LSPEclipseUtils.toOffset(r.getStart(), this.fDocument);
                    int end = LSPEclipseUtils.toOffset(r.getEnd(), this.fDocument);
                    annotationMap.put(new Annotation(LINKEDEDITING_ANNOTATION_TYPE, false, null), new Position(start, end - start));
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fLinkedEditingAnnotations, annotationMap);
            } else {
                this.removeLinkedEditingAnnotations();
                for (Map.Entry mapEntry : annotationMap.entrySet()) {
                    annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                }
            }
            this.fLinkedEditingAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.size()]);
        }
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLinkedEditingAnnotations() {
        IAnnotationModel annotationModel = this.sourceViewer.getAnnotationModel();
        if (annotationModel == null || this.fLinkedEditingAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fLinkedEditingAnnotations, null);
            } else {
                Annotation[] annotationArray = this.fLinkedEditingAnnotations;
                int n = this.fLinkedEditingAnnotations.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation fOccurrenceAnnotation = annotationArray[n2];
                    annotationModel.removeAnnotation(fOccurrenceAnnotation);
                    ++n2;
                }
            }
            this.fLinkedEditingAnnotations = null;
        }
    }

    class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        EditorSelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            LSPLinkedEditingReconcilingStrategy.this.updateLinkedEditingHighlights(event.getSelection());
        }
    }
}

