/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.eventscheduling.trace;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.Activator;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.engine.AbstractSolverCodeExecutorConcurrentEngine;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.engine.MoccmlExecutionEngine;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.eventscheduling.trace.ModelExecutionTracingException;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.dsa.helper.IK3ModelStateHelper;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.rtd.modelstate.k3ModelState.K3ModelState;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.AbstractConcurrentExecutionEngine;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.AbstractConcurrentModelExecutionContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dse.IMoccmlFutureAction;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.moc.ICCSLSolver;
import org.eclipse.gemoc.executionframework.engine.core.CommandExecution;
import org.eclipse.gemoc.executionframework.reflectivetrace.gemoc_execution_trace.Branch;
import org.eclipse.gemoc.executionframework.reflectivetrace.gemoc_execution_trace.Choice;
import org.eclipse.gemoc.executionframework.reflectivetrace.gemoc_execution_trace.ContextState;
import org.eclipse.gemoc.executionframework.reflectivetrace.gemoc_execution_trace.ExecutionTraceModel;
import org.eclipse.gemoc.executionframework.reflectivetrace.gemoc_execution_trace.Gemoc_execution_traceFactory;
import org.eclipse.gemoc.executionframework.reflectivetrace.gemoc_execution_trace.ModelState;
import org.eclipse.gemoc.executionframework.reflectivetrace.gemoc_execution_trace.SolverState;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericParallelStep;
import org.eclipse.gemoc.trace.commons.model.trace.ParallelStep;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.gemoc.api.IMultiDimensionalTraceAddon;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionContext;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.gemoc.xdsmlframework.api.extensions.engine_addon.EngineAddonSpecificationExtensionPoint;

public class EventSchedulingModelExecutionTracingAddon
implements IEngineAddon {
    private IExecutionContext<?, ?, ?> _executionContext;
    private AbstractConcurrentExecutionEngine<?, ?> _executionEngine;
    private ExecutionTraceModel _executionTraceModel;
    private Choice _lastChoice;
    private Branch _currentBranch;
    private ModelState currentState = null;
    byte[] _lastRestoredSolverState;
    private EContentAdapter adapter;
    private boolean shouldSave = true;
    private boolean _backToPastHappened = false;
    private boolean _cannotSaveTrace = false;
    protected int stepNumber = 0;
    private boolean _limitedMode = false;
    private String tmpRestoreFilePath;
    private File outputRestoreTmp = null;
    private FileOutputStream outputRestoreTmpStream = null;
    private PrintWriter outputRestoreTmpWriter = null;
    private IK3ModelStateHelper modelStateHelper = null;
    private String tmpAddFilePath;
    private File outputAddTmp;
    private FileOutputStream outputAddTmpStream;
    private PrintWriter outputAddTmpWriter;

    private void modifyTrace(final Runnable r) {
        RecordingCommand command = new RecordingCommand(this.getEditingDomain(), "update trace model"){

            protected void doExecute() {
                r.run();
            }
        };
        CommandExecution.execute((TransactionalEditingDomain)this.getEditingDomain(), (RecordingCommand)command);
    }

    public void disableTraceSaving() {
        this.shouldSave = false;
    }

    private TransactionalEditingDomain getEditingDomain() {
        return TransactionUtil.getEditingDomain((Resource)this._executionContext.getResourceModel());
    }

    public void branch(Choice choice) throws ModelExecutionTracingException {
        if (!this._limitedMode) {
            this.internalBranch(choice);
            this._backToPastHappened = true;
            this._executionEngine.getLogicalStepDecider().preempt();
        }
    }

    private void internalBranch(final Choice choice) {
        int index = this._executionTraceModel.getChoices().indexOf((Object)choice);
        if (index != -1 && index != this._executionTraceModel.getChoices().size()) {
            RecordingCommand command = new RecordingCommand(this.getEditingDomain(), "Back to " + index){

                protected void doExecute() {
                    Branch previousBranch = choice.getPreviousChoice().getBranch();
                    Branch newBranch = Gemoc_execution_traceFactory.eINSTANCE.createBranch();
                    int previousChoiceIndex = previousBranch.getChoices().indexOf((Object)choice.getPreviousChoice());
                    int index = previousBranch.getStartIndex() + previousChoiceIndex + 1;
                    newBranch.setStartIndex(index);
                    EventSchedulingModelExecutionTracingAddon.this._currentBranch = newBranch;
                    EventSchedulingModelExecutionTracingAddon.this._executionTraceModel.getBranches().add((Object)newBranch);
                    if (EventSchedulingModelExecutionTracingAddon.this._executionTraceModel.getChoices().size() > 0) {
                        EventSchedulingModelExecutionTracingAddon.this._lastChoice = choice.getPreviousChoice();
                        if (EventSchedulingModelExecutionTracingAddon.this._lastChoice != null) {
                            EventSchedulingModelExecutionTracingAddon.this._lastChoice.setSelectedNextChoice(null);
                        }
                    }
                    try {
                        EventSchedulingModelExecutionTracingAddon.this.restoreModelState(choice);
                        EventSchedulingModelExecutionTracingAddon.this.restoreSolverState(choice);
                    }
                    catch (Exception e) {
                        Activator.getDefault().error("Error while creating branch", e);
                    }
                }
            };
            CommandExecution.execute((TransactionalEditingDomain)this.getEditingDomain(), (RecordingCommand)command);
        }
    }

    private void restoreModelState(Choice choice) {
        ModelState state = choice.getContextState().getModelState();
        this.restoreModelState(state, true);
    }

    private FileOutputStream getFileOutputStream(File f) {
        FileOutputStream res = null;
        try {
            res = new FileOutputStream(f);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return res;
    }

    public void engineAboutToStop(IExecutionEngine<?> engine) {
        this.tmpRestoreFilePath = System.getProperty("tmpRestoreFileProperty");
        this.outputRestoreTmp = this.tmpRestoreFilePath != null && this.tmpRestoreFilePath.length() > 0 ? new File(this.tmpRestoreFilePath) : null;
        this.outputRestoreTmpStream = this.outputRestoreTmp != null ? this.getFileOutputStream(this.outputRestoreTmp) : null;
        PrintWriter printWriter = this.outputRestoreTmpWriter = this.outputRestoreTmpStream != null ? new PrintWriter(this.outputRestoreTmpStream, true) : null;
        if (this.outputRestoreTmpWriter != null) {
            int i = 0;
            while (i < this._executionTraceModel.getReachedStates().size()) {
                this.jump((ModelState)this._executionTraceModel.getReachedStates().get(i));
                ++i;
            }
            try {
                this.outputRestoreTmpStream.close();
                this.outputAddTmpStream.close();
                this.outputRestoreTmpWriter.close();
                this.outputAddTmpWriter.close();
                this.outputRestoreTmpStream = null;
                this.outputAddTmpStream = null;
                this.outputRestoreTmpWriter = null;
                this.outputAddTmpWriter = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void jump(final ModelState state) {
        this.modifyTrace(new Runnable(){

            @Override
            public void run() {
                long t1 = System.nanoTime();
                EventSchedulingModelExecutionTracingAddon.this.restoreModelState(state, false);
                long t2 = System.nanoTime();
                System.out.println("MEASURED TIME: " + (t2 - t1));
                if (EventSchedulingModelExecutionTracingAddon.this.outputRestoreTmpWriter != null) {
                    EventSchedulingModelExecutionTracingAddon.this.outputRestoreTmpWriter.println(t2 - t1);
                }
            }
        });
    }

    private void restoreModelState(ModelState state, boolean restoreAspects) {
        this.modelStateHelper.restoreModelState((K3ModelState)state.getModel());
    }

    private void restoreSolverState(Choice choice) {
        if (this._executionEngine instanceof AbstractSolverCodeExecutorConcurrentEngine) {
            MoccmlExecutionEngine engine_cast = (MoccmlExecutionEngine)this._executionEngine;
            ICCSLSolver solver = (ICCSLSolver)engine_cast.getSolver();
            org.eclipse.gemoc.executionframework.engine.Activator.getDefault().debug("restoring solver state: " + choice.getContextState().getSolverState().getSerializableModel());
            byte[] moccmlEngineState = choice.getContextState().getSolverState().getSerializableModel();
            ByteArrayInputStream out = new ByteArrayInputStream(moccmlEngineState);
            Object thePair = null;
            try {
                ObjectInputStream objOut = new ObjectInputStream(out);
                thePair = objOut.readObject();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            engine_cast.restoreState((Pair<Map<String, Boolean>, ArrayList<IMoccmlFutureAction>>)((Pair)((Pair)thePair).getLeft()));
            solver.setState((byte[])((Pair)thePair).getRight());
        }
    }

    public boolean hasRewindHappened(boolean resetFlag) {
        boolean result = this._backToPastHappened;
        if (resetFlag) {
            this._backToPastHappened = false;
        }
        return result;
    }

    private void addModelStateIfChanged() {
        Resource traceResource = this._executionTraceModel.eResource();
        if (traceResource.getContents().size() > 0) {
            ExecutionTraceModel traceModel = (ExecutionTraceModel)traceResource.getContents().get(0);
            org.eclipse.gemoc.executionframework.engine.Activator.getDefault().debug(String.format("[trace-%10s] new model state %3d detected", this.getCurrentEngineShortName(), traceModel.getReachedStates().size()));
            String fullLanguageName = this._executionContext.getLanguageDefinitionExtension().getName();
            int lastDot = fullLanguageName.lastIndexOf(".");
            if (lastDot == -1) {
                lastDot = 0;
            }
            String languageName = fullLanguageName.substring(lastDot + 1);
            String languageToUpperFirst = String.valueOf(languageName.substring(0, 1).toUpperCase()) + languageName.substring(1);
            if (this.modelStateHelper == null) {
                try {
                    this.modelStateHelper = (IK3ModelStateHelper)this._executionContext.getDslBundle().loadClass(String.valueOf(languageToUpperFirst.toLowerCase()) + ".xdsml.api.impl." + languageToUpperFirst + "ModelStateHelper").getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            EObject model = (EObject)this._executionContext.getResourceModel().getContents().get(0);
            K3ModelState result = this.modelStateHelper.getK3ModelState(model);
            result.eAdapters().clear();
            ModelState modelState = null;
            modelState = Gemoc_execution_traceFactory.eINSTANCE.createModelState();
            traceModel.getReachedStates().add((Object)modelState);
            modelState.setModel((EObject)result);
            this.currentState = modelState;
            traceResource.getContents().add((Object)result);
        }
    }

    private void storeCurrentContextState() {
        ExecutionTraceModel traceModel;
        EList choices;
        Resource traceResource = this._executionTraceModel.eResource();
        if (traceResource.getContents().size() > 0 && (choices = (traceModel = (ExecutionTraceModel)traceResource.getContents().get(0)).getChoices()).size() > 0) {
            this.addModelStateIfChanged();
            ContextState contextState = Gemoc_execution_traceFactory.eINSTANCE.createContextState();
            ModelState modelState = this.currentState;
            contextState.setModelState(modelState);
            if (this._executionEngine instanceof MoccmlExecutionEngine) {
                MoccmlExecutionEngine engine_cast = (MoccmlExecutionEngine)this._executionEngine;
                Pair<Map<String, Boolean>, ArrayList<IMoccmlFutureAction>> engineState = engine_cast.saveState();
                ICCSLSolver solver_cast = (ICCSLSolver)engine_cast.getSolver();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] serializableEngineState = null;
                try {
                    ObjectOutputStream objOut = new ObjectOutputStream(out);
                    objOut.writeObject(Pair.of(engineState, (Object)solver_cast.getState()));
                    serializableEngineState = out.toByteArray();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                SolverState solverState = Gemoc_execution_traceFactory.eINSTANCE.createSolverState();
                solverState.setSerializableModel(serializableEngineState);
                contextState.setSolverState(solverState);
            }
            ((Choice)choices.get(choices.size() - 1)).setContextState(contextState);
            contextState.setChoice((Choice)choices.get(choices.size() - 1));
        }
    }

    private void saveTraceModel() {
        Resource traceResource = this._executionTraceModel.eResource();
        if (traceResource.getContents().size() > 0 && !this._cannotSaveTrace && this.shouldSave) {
            try {
                org.eclipse.gemoc.executionframework.engine.Activator.getDefault().debug(String.format("[trace-%10s] %d states saved to %s", this.getCurrentEngineShortName(), this._executionTraceModel.getReachedStates().size(), this._executionTraceModel.eResource().getURI()));
                traceResource.save(null);
            }
            catch (IOException e) {
                Activator.getDefault().error("Error while saving trace to disk", e);
            }
        }
    }

    public Branch getCurrentBranch() {
        return this._currentBranch;
    }

    public Choice getCurrentChoice() {
        return this._lastChoice;
    }

    private void setUp(IExecutionEngine<?> engine) {
        if (this._executionContext == null) {
            if (!(engine.getExecutionContext() instanceof AbstractConcurrentModelExecutionContext)) {
                System.err.println("use of MultibranchTracingAddon with non concurrent engine, will work in a limited mode");
                org.eclipse.gemoc.executionframework.engine.Activator.getDefault().warn("Use of MultibranchTracingAddon with non concurrent engine. The trace will work in a limited mode");
                this._limitedMode = true;
            }
            if (!(engine instanceof AbstractConcurrentExecutionEngine)) {
                throw new RuntimeException("The event scheduling tracing addon cannot work with a non-concurrent engine.");
            }
            this._executionEngine = (AbstractConcurrentExecutionEngine)engine;
            if (this._executionTraceModel == null) {
                this._executionTraceModel = Gemoc_execution_traceFactory.eINSTANCE.createExecutionTraceModel();
                this._currentBranch = Gemoc_execution_traceFactory.eINSTANCE.createBranch();
                this._currentBranch.setStartIndex(0);
                this._executionTraceModel.getBranches().add((Object)this._currentBranch);
                this.setModelExecutionContext(engine.getExecutionContext());
            }
            this.adapter = new EContentAdapter(){

                public void notifyChanged(Notification notification) {
                    super.notifyChanged(notification);
                }
            };
            this._executionContext.getResourceModel().eAdapters().add((Object)this.adapter);
        }
    }

    private void setModelExecutionContext(IExecutionContext<?, ?, ?> executionContext) {
        this._executionContext = executionContext;
        ResourceSet rs = this._executionContext.getResourceModel().getResourceSet();
        URI traceModelURI = URI.createPlatformResourceURI((String)(String.valueOf(this._executionContext.getWorkspace().getExecutionPath().toString()) + "/execution.trace"), (boolean)false);
        final Resource modelResource = rs.createResource(traceModelURI);
        RecordingCommand command = new RecordingCommand(this.getEditingDomain(), "set model execution context"){

            protected void doExecute() {
                modelResource.getContents().add((Object)EventSchedulingModelExecutionTracingAddon.this._executionTraceModel);
            }
        };
        CommandExecution.execute((TransactionalEditingDomain)this.getEditingDomain(), (RecordingCommand)command);
    }

    private Choice createChoice() {
        Choice choice = Gemoc_execution_traceFactory.eINSTANCE.createChoice();
        return choice;
    }

    private void updateTraceModelBeforeDeciding(final Collection<Step<?>> possibleLogicalSteps) {
        RecordingCommand command = new RecordingCommand(this.getEditingDomain(), "update trace model"){

            protected void doExecute() {
                Choice choice = EventSchedulingModelExecutionTracingAddon.this.createChoice();
                EventSchedulingModelExecutionTracingAddon.this._executionTraceModel.getChoices().add((Object)choice);
                EventSchedulingModelExecutionTracingAddon.this._currentBranch.getChoices().add((Object)choice);
                if (EventSchedulingModelExecutionTracingAddon.this._lastChoice != null) {
                    EventSchedulingModelExecutionTracingAddon.this._lastChoice.getNextChoices().add((Object)choice);
                    EventSchedulingModelExecutionTracingAddon.this._lastChoice.setSelectedNextChoice(choice);
                }
                choice.getPossibleLogicalSteps().addAll(possibleLogicalSteps);
                EventSchedulingModelExecutionTracingAddon.this._lastChoice = choice;
                long t1 = System.nanoTime();
                EventSchedulingModelExecutionTracingAddon.this.storeCurrentContextState();
                long t2 = System.nanoTime();
                if (EventSchedulingModelExecutionTracingAddon.this.outputAddTmpWriter != null) {
                    EventSchedulingModelExecutionTracingAddon.this.outputAddTmpWriter.println(t2 - t1);
                }
            }
        };
        CommandExecution.execute((TransactionalEditingDomain)this.getEditingDomain(), (RecordingCommand)command);
    }

    private void updateTraceModelAfterExecution(final Step<?> selectedLogicalStep) {
        RecordingCommand command = new RecordingCommand(this.getEditingDomain(), "update trace model after deciding"){

            protected void doExecute() {
                if (!EventSchedulingModelExecutionTracingAddon.this._limitedMode) {
                    if (EventSchedulingModelExecutionTracingAddon.this._lastChoice != null) {
                        if (EventSchedulingModelExecutionTracingAddon.this._lastChoice.getPossibleLogicalSteps().size() == 0) {
                            return;
                        }
                        if (EventSchedulingModelExecutionTracingAddon.this._lastChoice.getPossibleLogicalSteps().contains((Object)selectedLogicalStep.eContainer())) {
                            EventSchedulingModelExecutionTracingAddon.this._lastChoice.setChosenLogicalStep((Step)((GenericParallelStep)selectedLogicalStep.eContainer()));
                        }
                    }
                } else {
                    Choice choiceFullyExecuted = EventSchedulingModelExecutionTracingAddon.this.findPreviousChoiceWithLogicalStep(EventSchedulingModelExecutionTracingAddon.this._lastChoice, selectedLogicalStep);
                    if (choiceFullyExecuted != null) {
                        choiceFullyExecuted.setChosenLogicalStep(selectedLogicalStep);
                    }
                }
            }
        };
        CommandExecution.execute((TransactionalEditingDomain)this.getEditingDomain(), (RecordingCommand)command);
    }

    private Choice findPreviousChoiceWithLogicalStep(Choice startingChoice, Step<?> selectedLogicalStep) {
        if (startingChoice.getPossibleLogicalSteps().contains(selectedLogicalStep)) {
            return startingChoice;
        }
        if (startingChoice.getPreviousChoice() != null) {
            return this.findPreviousChoiceWithLogicalStep(startingChoice.getPreviousChoice(), selectedLogicalStep);
        }
        return null;
    }

    public ExecutionTraceModel getExecutionTrace() {
        return this._executionTraceModel;
    }

    public void aboutToSelectStep(IExecutionEngine<?> engine, Collection<Step<?>> logicalSteps) {
        this.setUp(engine);
        this.updateTraceModelBeforeDeciding(logicalSteps);
    }

    public void aboutToExecuteStep(IExecutionEngine<?> executionEngine, Step<?> logicalStepToApply) {
        if (this._limitedMode) {
            this.setUp(executionEngine);
            ArrayList beforeDecing = new ArrayList();
            if (logicalStepToApply.getMseoccurrence().getMse().eContainer() == null) {
                System.out.println("MSE CONTAINER NULL");
            }
            beforeDecing.add(logicalStepToApply);
            this.updateTraceModelBeforeDeciding(beforeDecing);
        }
    }

    public void stepExecuted(IExecutionEngine<?> engine, Step<?> logicalStepExecuted) {
        this.setUp(engine);
        this.updateTraceModelAfterExecution(logicalStepExecuted);
        RecordingCommand command = new RecordingCommand(this.getEditingDomain(), "Save trace model"){

            protected void doExecute() {
                EventSchedulingModelExecutionTracingAddon.this._executionTraceModel.getChoices().forEach(c -> {
                    ContextState s = c.getContextState();
                    if (s.eContainer() == null) {
                        c.setContextState(s);
                    }
                });
                EventSchedulingModelExecutionTracingAddon.this.saveTraceModel();
            }
        };
        CommandExecution.execute((TransactionalEditingDomain)this.getEditingDomain(), (RecordingCommand)command);
    }

    public void engineAboutToDispose(IExecutionEngine<?> engine) {
    }

    public void reintegrateBranch(final Choice choice) {
        if (!this._limitedMode) {
            RecordingCommand command = new RecordingCommand(this.getEditingDomain(), "Reintegrate branch"){

                protected void doExecute() {
                    EventSchedulingModelExecutionTracingAddon.this._currentBranch = choice.getBranch();
                    EventSchedulingModelExecutionTracingAddon.this._lastChoice = choice.getPreviousChoice();
                    choice.setPreviousChoice(null);
                    EventSchedulingModelExecutionTracingAddon.this._lastChoice.setSelectedNextChoice(null);
                    EventSchedulingModelExecutionTracingAddon.this._currentBranch.getChoices().remove((Object)choice);
                    try {
                        EventSchedulingModelExecutionTracingAddon.this.restoreModelState(choice);
                        EventSchedulingModelExecutionTracingAddon.this.restoreSolverState(choice);
                        EventSchedulingModelExecutionTracingAddon.this._executionEngine.getLogicalStepDecider().preempt();
                    }
                    catch (Exception e) {
                        Activator.getDefault().error("Error while reintegrating branch", e);
                    }
                }
            };
            CommandExecution.execute((TransactionalEditingDomain)this.getEditingDomain(), (RecordingCommand)command);
        }
    }

    public void engineStopped(IExecutionEngine<?> engine) {
        this.modifyTrace(new Runnable(){

            @Override
            public void run() {
                EventSchedulingModelExecutionTracingAddon.this._executionContext.getResourceModel().eAdapters().remove((Object)EventSchedulingModelExecutionTracingAddon.this.adapter);
            }
        });
        RecordingCommand command = new RecordingCommand(this.getEditingDomain(), "Save trace model"){

            protected void doExecute() {
                EventSchedulingModelExecutionTracingAddon.this._executionTraceModel.getChoices().forEach(c -> c.getPossibleLogicalSteps().forEach(s -> ((ParallelStep)s).getSubSteps().forEach(ss -> ((Step)ss).getMseoccurrence().setMse(null))));
                EventSchedulingModelExecutionTracingAddon.this._executionTraceModel.getChoices().forEach(c -> {
                    ContextState s = c.getContextState();
                    if (s.eContainer() == null) {
                        c.setContextState(s);
                    }
                });
                EventSchedulingModelExecutionTracingAddon.this.saveTraceModel();
            }
        };
        CommandExecution.execute((TransactionalEditingDomain)this.getEditingDomain(), (RecordingCommand)command);
    }

    public void engineAboutToStart(IExecutionEngine<?> engine) {
        this.setUp(engine);
        this.tmpAddFilePath = System.getProperty("tmpAddFileProperty");
        this.outputAddTmp = this.tmpAddFilePath != null && this.tmpAddFilePath.length() > 0 ? new File(this.tmpAddFilePath) : null;
        this.outputAddTmpStream = this.outputAddTmp != null ? this.getFileOutputStream(this.outputAddTmp) : null;
        this.outputAddTmpWriter = this.outputAddTmpStream != null ? new PrintWriter(this.outputAddTmpStream, true) : null;
    }

    public List<String> validate(List<IEngineAddon> otherAddons) {
        ArrayList<String> errors = new ArrayList<String>();
        boolean found = false;
        String addonName = "";
        for (IEngineAddon iEngineAddon : otherAddons) {
            if (!(iEngineAddon instanceof IMultiDimensionalTraceAddon)) continue;
            found = true;
            addonName = EngineAddonSpecificationExtensionPoint.getName((IEngineAddon)iEngineAddon);
            break;
        }
        if (found) {
            String thisName = EngineAddonSpecificationExtensionPoint.getName((IEngineAddon)this);
            errors.add(String.valueOf(thisName) + " can't run with " + addonName);
        }
        return errors;
    }

    public String getCurrentEngineShortName() {
        return this._executionContext.getRunConfiguration().getExecutedModelURI().lastSegment();
    }
}

