/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.k3.ui.wizards.pages;

import fr.inria.diverse.k3.ui.tools.ErrorMessage;
import fr.inria.diverse.k3.ui.wizards.pages.NewK3ProjectWizardFields;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewK3ProjectWizardPage
extends WizardPage {
    protected NewK3ProjectWizardFields context;
    protected static final List<String> FILE_EXTENSIONS = Arrays.asList("ecore");
    protected ErrorMessage[] errorMessage;
    protected boolean enableNext = true;
    protected Composite container;
    protected Label lblProjectName;
    protected Text txtProjectName;
    protected Text txtProjectLocation;
    protected Button btnBrowseLocation;
    protected Button btnCheckLocation;
    protected Button btnCheckEMF;
    protected Button btnCheckKMF;
    protected Button btnRadioStandAlone;
    protected Button btnRadioPlugIn;
    protected Button btnRadioMaven;
    protected Group grpGeneral;
    protected Group grpKindOfProject;
    protected Group grpModelingOptions;
    protected Group grpTemplateOptions;

    public NewK3ProjectWizardPage(NewK3ProjectWizardFields context) {
        super("wizardPage");
        this.context = context;
        this.setTitle("New Kermeta 3 project");
        this.setDescription("This wizard creates a new kermeta 3 project");
        this.errorMessage = new ErrorMessage[2];
        this.errorMessage[0] = new ErrorMessage("A project with this name already exists.", false);
        this.errorMessage[1] = new ErrorMessage("Please select an ecore file.", false);
    }

    public NewK3ProjectWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle("New Kermeta 3 project");
        this.setDescription("This wizard creates a new kermeta 3 project");
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.grpGeneral = new Group(this.container, 0);
        this.grpGeneral.setText("General");
        this.grpGeneral.setLayout((Layout)new GridLayout(4, false));
        this.lblProjectName = new Label((Composite)this.grpGeneral, 0);
        this.lblProjectName.setText("project name ");
        new Label((Composite)this.grpGeneral, 0);
        new Label((Composite)this.grpGeneral, 0);
        new Label((Composite)this.grpGeneral, 0);
        this.txtProjectName = new Text((Composite)this.grpGeneral, 2048);
        this.txtProjectName.setText(this.context.projectName);
        GridData projectNameGrid = new GridData(4, 0x1000000, true, false, 3, 1);
        projectNameGrid.widthHint = 500;
        this.txtProjectName.setLayoutData((Object)projectNameGrid);
        new Label((Composite)this.grpGeneral, 0);
        this.txtProjectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (NewK3ProjectWizardPage.this.existNameProject()) {
                    NewK3ProjectWizardPage.this.activErrorMessage(0, true);
                    NewK3ProjectWizardPage.this.setPageComplete(false);
                } else {
                    NewK3ProjectWizardPage.this.activErrorMessage(0, false);
                    NewK3ProjectWizardPage.this.setPageComplete(true);
                }
                NewK3ProjectWizardPage.this.updateNameProject(NewK3ProjectWizardPage.this.txtProjectName.getText());
            }
        });
        this.btnCheckLocation = new Button((Composite)this.grpGeneral, 32);
        this.btnCheckLocation.setText("use default location");
        this.btnCheckLocation.setSelection(true);
        new Label((Composite)this.grpGeneral, 0);
        new Label((Composite)this.grpGeneral, 0);
        new Label((Composite)this.grpGeneral, 0);
        this.btnCheckLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewK3ProjectWizardPage.this.btnCheckLocation.getSelection()) {
                    NewK3ProjectWizardPage.this.txtProjectLocation.setEnabled(false);
                    NewK3ProjectWizardPage.this.btnBrowseLocation.setEnabled(false);
                } else {
                    NewK3ProjectWizardPage.this.txtProjectLocation.setEnabled(true);
                    NewK3ProjectWizardPage.this.btnBrowseLocation.setEnabled(true);
                }
            }
        });
        this.txtProjectLocation = new Text((Composite)this.grpGeneral, 2048);
        this.txtProjectLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.txtProjectLocation.setText(this.context.projectLocation);
        this.btnBrowseLocation = new Button((Composite)this.grpGeneral, 0);
        this.btnBrowseLocation.setText("Browse...");
        this.btnBrowseLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewK3ProjectWizardPage.this.txtProjectLocation.setText(NewK3ProjectWizardPage.this.locationDialog());
            }
        });
        this.grpKindOfProject = new Group(this.container, 0);
        this.grpKindOfProject.setText("Dependency management / Project kind");
        this.grpKindOfProject.setLayout((Layout)new FillLayout(256));
        this.btnRadioPlugIn = new Button((Composite)this.grpKindOfProject, 16);
        this.btnRadioPlugIn.setText("Plug-in");
        this.btnRadioPlugIn.setToolTipText("Eclipse plugin project, external dependencies will be specified using manifest.mf.");
        this.btnRadioPlugIn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewK3ProjectWizardPage.this.updateKindsOfProject(NewK3ProjectWizardFields.KindsOfProject.PLUGIN);
            }
        });
        this.btnRadioStandAlone = new Button((Composite)this.grpKindOfProject, 16);
        this.btnRadioStandAlone.setText("Stand alone");
        this.btnRadioStandAlone.setToolTipText("Standard java project. Dependencies jars will be copied and embedded.");
        this.btnRadioStandAlone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewK3ProjectWizardPage.this.updateKindsOfProject(NewK3ProjectWizardFields.KindsOfProject.STANDALONE);
            }
        });
        this.btnRadioMaven = new Button((Composite)this.grpKindOfProject, 16);
        this.btnRadioMaven.setText("Maven");
        this.btnRadioMaven.setToolTipText("Standard java maven project, external dependencies will be specified using pom.xml.");
        this.btnRadioMaven.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewK3ProjectWizardPage.this.updateKindsOfProject(NewK3ProjectWizardFields.KindsOfProject.MAVEN);
            }
        });
        this.grpModelingOptions = new Group(this.container, 0);
        this.grpModelingOptions.setText("Modeling options");
        this.grpModelingOptions.setLayout((Layout)new GridLayout(4, false));
        this.btnCheckEMF = new Button((Composite)this.grpModelingOptions, 32);
        this.btnCheckEMF.setText("Use EMF");
        this.btnCheckEMF.setSelection(this.context.useEMF);
        this.btnCheckEMF.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewK3ProjectWizardPage.this.updateUseEMF(NewK3ProjectWizardPage.this.btnCheckEMF.getSelection());
            }
        });
        this.btnCheckKMF = new Button((Composite)this.grpModelingOptions, 32);
        this.btnCheckKMF.setText("Use KMF");
        this.btnCheckKMF.setEnabled(false);
        this.btnCheckKMF.setSelection(this.context.useKMF);
        this.btnCheckKMF.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewK3ProjectWizardPage.this.updateUseKMF(NewK3ProjectWizardPage.this.btnCheckKMF.getSelection());
            }
        });
        new Label((Composite)this.grpModelingOptions, 0);
        new Label((Composite)this.grpModelingOptions, 0);
        this.txtProjectLocation.setEnabled(false);
        this.btnBrowseLocation.setEnabled(false);
        this.btnRadioPlugIn.setSelection(true);
        if (this.existNameProject()) {
            this.activErrorMessage(0, true);
            this.setPageComplete(false);
        } else {
            this.activErrorMessage(0, false);
            this.setPageComplete(true);
        }
        this.setControl((Control)this.container);
        this.setPageComplete(true);
    }

    protected String locationDialog() {
        DirectoryDialog dirDialog = new DirectoryDialog(new Shell());
        dirDialog.setText("Select location directory");
        this.context.projectLocation = dirDialog.open();
        return this.context.projectLocation;
    }

    protected void activErrorMessage(int index, boolean bActiv) {
        this.errorMessage[index].setActive(bActiv);
        this.setMessageError();
    }

    protected boolean existNameProject() {
        boolean bFinder = false;
        int i = 0;
        while (!bFinder && i < ResourcesPlugin.getWorkspace().getRoot().getProjects().length) {
            if (ResourcesPlugin.getWorkspace().getRoot().getProjects()[i].getName().contentEquals(this.txtProjectName.getText())) {
                bFinder = true;
            }
            ++i;
        }
        return bFinder;
    }

    protected void setMessageError() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.errorMessage.length) {
            if (this.errorMessage[i].isActive()) {
                result.append(String.valueOf(this.errorMessage[i].getMessageError()) + "\n");
            }
            ++i;
        }
        if (result.length() > 0) {
            this.setErrorMessage(result.toString());
        } else {
            this.setErrorMessage(null);
        }
    }

    protected void updateUseEMF(boolean bState) {
        this.context.useEMF = bState;
        this.btnCheckEMF.setSelection(bState);
    }

    protected void updateUseKMF(boolean bState) {
        this.context.useKMF = bState;
        this.btnCheckKMF.setSelection(bState);
    }

    protected void updateNameProject(String nameProject) {
        this.context.projectName = nameProject;
    }

    protected void updateKindsOfProject(NewK3ProjectWizardFields.KindsOfProject kindsOfProject) {
        this.context.kindsOfProject = kindsOfProject;
    }

    public boolean canFlipToNextPage() {
        return this.enableNext;
    }

    public void setProjectName(String nameProject) {
        this.txtProjectName.setText(nameProject);
        this.context.projectName = nameProject;
    }

    public void setProjectKind(NewK3ProjectWizardFields.KindsOfProject kindsOfProject) {
        switch (kindsOfProject) {
            case STANDALONE: {
                this.btnRadioStandAlone.setSelection(true);
                this.btnRadioPlugIn.setSelection(false);
                this.btnRadioMaven.setSelection(false);
                break;
            }
            case PLUGIN: {
                this.btnRadioStandAlone.setSelection(false);
                this.btnRadioPlugIn.setSelection(true);
                this.btnRadioMaven.setSelection(false);
                break;
            }
            default: {
                this.btnRadioStandAlone.setSelection(false);
                this.btnRadioPlugIn.setSelection(false);
                this.btnRadioMaven.setSelection(true);
            }
        }
        this.updateKindsOfProject(kindsOfProject);
    }
}

