/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.search.IHelpSearchIndex;
import org.eclipse.help.search.ISearchDocument;
import org.eclipse.help.search.SearchParticipant;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroContainer;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.IntroGroup;
import org.eclipse.ui.internal.intro.impl.model.IntroLink;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroPageTitle;
import org.eclipse.ui.internal.intro.impl.model.IntroText;
import org.eclipse.ui.internal.intro.impl.model.loader.ExtensionPointManager;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.osgi.framework.Bundle;

public class IntroSearchParticipant
extends SearchParticipant {
    private IntroModelRoot model;

    public Set<String> getContributingPlugins() {
        IConfigurationElement element;
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.intro.config");
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (element.getName().equals("config")) {
                set.add(element.getContributor().getName());
            }
            ++i;
        }
        elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.intro.configExtension");
        i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (element.getName().equals("configExtension")) {
                set.add(element.getContributor().getName());
            }
            ++i;
        }
        return set;
    }

    public Set<String> getAllDocuments(String locale) {
        String iid;
        HashSet<String> set = new HashSet<String>();
        IProduct product = Platform.getProduct();
        if (product == null) {
            return set;
        }
        String productId = product.getId();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.intro");
        String targetIntroId = null;
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals("introProductBinding")) {
                String pid = element.getAttribute("productId");
                iid = element.getAttribute("introId");
                if (productId.equals(pid)) {
                    targetIntroId = iid;
                    break;
                }
            }
            ++i;
        }
        if (targetIntroId == null) {
            return set;
        }
        elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.intro.config");
        IConfigurationElement config = null;
        int i2 = 0;
        while (i2 < elements.length) {
            IConfigurationElement element = elements[i2];
            if (element.getName().equals("config") && targetIntroId.equals(iid = element.getAttribute("introId"))) {
                config = element;
                break;
            }
            ++i2;
        }
        if (config == null) {
            return set;
        }
        String configId = config.getAttribute("id");
        ExtensionPointManager extensionPointManager = IntroPlugin.getDefault().getExtensionPointManager();
        this.model = extensionPointManager.getModel(configId);
        if (this.model != null && this.model.hasValidConfig()) {
            this.loadFromModel(this.model, set, locale);
        }
        return set;
    }

    private void loadFromModel(IntroModelRoot model, Set<String> set, String locale) {
        IntroPage[] pages = model.getPages();
        int i = 0;
        while (i < pages.length) {
            IntroPage page = pages[i];
            if (page.isDynamic()) {
                Bundle bundle = page.getBundle();
                String bundleId = bundle.getSymbolicName();
                String content = page.getRawContent();
                String pageId = page.getId();
                String href = content != null ? IntroSearchParticipant.resolveVariables((String)bundleId, (String)content, (String)locale) : pageId;
                set.add("/" + bundleId + "/" + href + "?id=" + pageId);
            }
            ++i;
        }
    }

    public IStatus addDocument(IHelpSearchIndex index, String pluginId, String name, URL url, String id, ISearchDocument doc) {
        if (this.model == null) {
            return Status.CANCEL_STATUS;
        }
        IntroPage page = this.getPage(id);
        if (page == null) {
            return Status.CANCEL_STATUS;
        }
        return this.addPage(index, pluginId, name, url, page, doc);
    }

    private IntroPage getPage(String id) {
        IntroPage[] pages = this.model.getPages();
        int i = 0;
        while (i < pages.length) {
            if (pages[i].getId().equals(id)) {
                return pages[i];
            }
            ++i;
        }
        return null;
    }

    private IStatus addPage(IHelpSearchIndex index, String pluginId, String name, URL url, IntroPage page, ISearchDocument doc) {
        AbstractIntroElement[] children = page.getChildren();
        if (children.length > 0) {
            StringBuilder buf = new StringBuilder();
            TitleAndSummary titleSummary = new TitleAndSummary();
            this.addChildren(children, buf, doc, titleSummary);
            String contents = buf.toString();
            if (titleSummary.title != null) {
                this.addTitle(titleSummary.title, doc);
            }
            if (titleSummary.summary != null) {
                doc.setSummary(titleSummary.summary);
            }
            doc.addContents(contents);
            return Status.OK_STATUS;
        }
        return index.addSearchableDocument(pluginId, name, url, page.getId(), doc);
    }

    private void addChildren(AbstractIntroElement[] children, StringBuilder buf, ISearchDocument doc, TitleAndSummary titleSummary) {
        int i = 0;
        while (i < children.length) {
            AbstractIntroContainer container;
            String text;
            AbstractIntroElement child = children[i];
            if (child instanceof IntroLink) {
                text = ((IntroLink)child).getLabel();
                this.appendNewText(buf, text);
            } else if (child instanceof IntroGroup) {
                text = ((IntroGroup)child).getLabel();
                this.appendNewText(buf, text);
            } else if (child instanceof IntroText) {
                IntroText childIntroText = (IntroText)child;
                this.appendNewText(buf, childIntroText.getText());
                String childId = childIntroText.getId();
                String title = null;
                if ("page-title".equals(childId)) {
                    title = childIntroText.getText();
                } else if (child instanceof IntroPageTitle) {
                    title = ((IntroPageTitle)child).getTitle();
                }
                if (title != null) {
                    titleSummary.title = title;
                }
                if ("page-description".equals(childId)) {
                    titleSummary.summary = childIntroText.getText();
                }
            }
            if (child instanceof AbstractIntroContainer && !"navigation-links".equals((container = (AbstractIntroContainer)child).getId())) {
                AbstractIntroElement[] cc = container.getChildren();
                this.addChildren(cc, buf, doc, titleSummary);
            }
            ++i;
        }
    }

    private void appendNewText(StringBuilder buf, String text) {
        if (text == null) {
            return;
        }
        if (buf.length() > 0) {
            buf.append(" ");
        }
        buf.append(text);
    }

    public void clear() {
        this.model = null;
    }

    public boolean open(String id) {
        IIntroManager introManager = PlatformUI.getWorkbench().getIntroManager();
        IIntroPart intro = introManager.showIntro(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), false);
        if (intro == null) {
            return false;
        }
        IIntroURL url = IntroURLFactory.createIntroURL("http://org.eclipse.ui.intro/showPage?id=" + id);
        return url.execute();
    }

    private static class TitleAndSummary {
        String title;
        String summary;

        private TitleAndSummary() {
        }
    }
}

