/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.site;

import java.io.PrintWriter;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteDescription;
import org.eclipse.pde.internal.core.site.SiteCategory;
import org.eclipse.pde.internal.core.site.SiteDescription;
import org.eclipse.pde.internal.core.site.SiteObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SiteCategoryDefinition
extends SiteObject
implements ISiteCategoryDefinition {
    private static final long serialVersionUID = 1L;
    private String name;
    private ISiteDescription description;
    private final Vector<ISiteCategory> fCategories = new Vector();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isValid() {
        return this.name != null && this.getLabel() != null;
    }

    @Override
    public void setName(String name) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.name;
        this.name = name;
        this.firePropertyChanged("name", oldValue, name);
    }

    @Override
    public ISiteDescription getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(ISiteDescription description) throws CoreException {
        this.ensureModelEditable();
        ISiteDescription oldValue = this.description;
        this.description = description;
        this.firePropertyChanged("description", oldValue, description);
    }

    @Override
    protected void reset() {
        super.reset();
        this.name = null;
        this.description = null;
    }

    @Override
    protected void parse(Node node) {
        super.parse(node);
        this.name = this.getNodeAttribute(node, "name");
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equalsIgnoreCase("description")) {
                this.description = this.getModel().getFactory().createDescription(this);
                ((SiteDescription)this.description).parse(child);
                ((SiteDescription)this.description).setInTheModel(true);
                break;
            }
            if (child.getNodeType() == 1 && child.getNodeName().equalsIgnoreCase("category")) {
                SiteCategory category = (SiteCategory)this.getModel().getFactory().createCategory(this);
                category.parse(child);
                category.setInTheModel(true);
                this.fCategories.add(category);
            }
            ++i;
        }
    }

    @Override
    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("name")) {
            this.setName(newValue != null ? newValue.toString() : null);
        } else if (name.equals("description") && newValue instanceof ISiteDescription) {
            this.setDescription((ISiteDescription)newValue);
        } else {
            super.restoreProperty(name, oldValue, newValue);
        }
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        boolean hasChildrenElements;
        writer.print(indent);
        writer.print("<category-def");
        if (this.name != null) {
            writer.print(" name=\"" + SiteObject.getWritableString(this.name) + "\"");
        }
        if (this.label != null) {
            writer.print(" label=\"" + SiteObject.getWritableString(this.label) + "\"");
        }
        boolean bl = hasChildrenElements = this.description != null || !this.fCategories.isEmpty();
        if (hasChildrenElements) {
            writer.println(">");
            for (ISiteCategory category : this.fCategories) {
                category.write(String.valueOf(indent) + "   ", writer);
            }
            if (this.description != null) {
                this.description.write(String.valueOf(indent) + "   ", writer);
            }
            writer.println(String.valueOf(indent) + "</category-def>");
        } else {
            writer.println("/>");
        }
    }

    @Override
    public void addCategories(ISiteCategory[] newCategories) throws CoreException {
        this.ensureModelEditable();
        ISiteCategory[] iSiteCategoryArray = newCategories;
        int n = newCategories.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteCategory category = iSiteCategoryArray[n2];
            ((SiteCategory)category).setInTheModel(true);
            this.fCategories.add(category);
            ++n2;
        }
        this.fireStructureChanged(newCategories, 1);
    }

    @Override
    public void removeCategories(ISiteCategory[] newCategories) throws CoreException {
        this.ensureModelEditable();
        ISiteCategory[] iSiteCategoryArray = newCategories;
        int n = newCategories.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteCategory category = iSiteCategoryArray[n2];
            ((SiteCategory)category).setInTheModel(false);
            this.fCategories.remove(category);
            ++n2;
        }
        this.fireStructureChanged(newCategories, 2);
    }

    @Override
    public ISiteCategory[] getCategories() {
        return this.fCategories.toArray(new ISiteCategory[this.fCategories.size()]);
    }

    public String toString() {
        String separator = ", ";
        StringBuilder builder = new StringBuilder();
        builder.append(SiteCategoryDefinition.class.getSimpleName()).append("{").append("name=").append(this.name).append(separator).append("label=").append(this.label).append(separator).append("categories=").append(this.fCategories.size()).append("}");
        return builder.toString();
    }
}

